/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.spi;

import java.io.File;
import org.openide.filesystems.FileUtil;

public interface ArtifactListener {
    public void artifactsUpdated(Iterable<Artifact> var1);

    public static final class Artifact {
        private final File file;
        private final File distributionPath;
        private final boolean library;
        private final boolean relocatable;
        private final boolean serverResource;
        private final String relocation;

        private Artifact(File file, File distributionPath, boolean library, boolean relocatable, boolean resource, String relocation) {
            this.file = file;
            this.distributionPath = distributionPath;
            this.library = library;
            this.relocatable = relocatable;
            this.serverResource = resource;
            this.relocation = relocation;
        }

        public static Artifact forFile(File file) {
            return new Artifact(FileUtil.normalizeFile((File)file), null, false, false, false, null);
        }

        public File getFile() {
            return this.file;
        }

        public Artifact referencedLibrary() {
            return new Artifact(this.file, this.distributionPath, true, this.relocatable, this.isServerResource(), this.relocation);
        }

        public boolean isReferencedLibrary() {
            return this.library;
        }

        public Artifact distributionPath(File distributionPath) {
            return new Artifact(this.file, distributionPath, this.library, this.relocatable, this.isServerResource(), this.relocation);
        }

        public File getDistributionPath() {
            return this.distributionPath;
        }

        public Artifact relocatable() {
            return new Artifact(this.file, this.distributionPath, this.library, true, this.isServerResource(), null);
        }

        public Artifact relocatable(String path) {
            return new Artifact(this.file, this.distributionPath, this.library, true, this.isServerResource(), path);
        }

        public boolean isRelocatable() {
            return this.relocatable;
        }

        public String getRelocation() {
            return this.relocation;
        }

        public Artifact serverResource() {
            return new Artifact(this.file, this.distributionPath, this.library, this.relocatable, true, this.relocation);
        }

        public boolean isServerResource() {
            return this.serverResource;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Artifact other = (Artifact)obj;
            if (!(this.file == other.file || this.file != null && this.file.equals(other.file))) {
                return false;
            }
            if (!(this.distributionPath == other.distributionPath || this.distributionPath != null && this.distributionPath.equals(other.distributionPath))) {
                return false;
            }
            return this.library == other.library;
        }

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + (this.file != null ? this.file.hashCode() : 0);
            hash = 59 * hash + (this.distributionPath != null ? this.distributionPath.hashCode() : 0);
            hash = 59 * hash + (this.library ? 1 : 0);
            return hash;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getFile().toString());
            builder.append(", ");
            builder.append(this.getDistributionPath());
            builder.append(", ");
            builder.append("isReferencedLibrary: ").append(this.isReferencedLibrary());
            builder.append(", ");
            builder.append("isRelocatable: ").append(this.isRelocatable());
            builder.append(", ");
            builder.append("isServerResource: ").append(this.isServerResource());
            return builder.toString();
        }
    }
}

