/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExportedKeyData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="keyVersionId")
    private final String keyVersionId;
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="vaultId")
    private final String vaultId;
    @JsonProperty(value="encryptedKey")
    private final String encryptedKey;
    @JsonProperty(value="algorithm")
    private final Algorithm algorithm;

    @Deprecated
    @ConstructorProperties(value={"keyVersionId", "keyId", "timeCreated", "vaultId", "encryptedKey", "algorithm"})
    public ExportedKeyData(String keyVersionId, String keyId, Date timeCreated, String vaultId, String encryptedKey, Algorithm algorithm) {
        this.keyVersionId = keyVersionId;
        this.keyId = keyId;
        this.timeCreated = timeCreated;
        this.vaultId = vaultId;
        this.encryptedKey = encryptedKey;
        this.algorithm = algorithm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String getEncryptedKey() {
        return this.encryptedKey;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportedKeyData(");
        sb.append("super=").append(super.toString());
        sb.append("keyVersionId=").append(String.valueOf(this.keyVersionId));
        sb.append(", keyId=").append(String.valueOf(this.keyId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", vaultId=").append(String.valueOf(this.vaultId));
        sb.append(", encryptedKey=").append(String.valueOf(this.encryptedKey));
        sb.append(", algorithm=").append(String.valueOf((Object)this.algorithm));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportedKeyData)) {
            return false;
        }
        ExportedKeyData other = (ExportedKeyData)((Object)o);
        return Objects.equals(this.keyVersionId, other.keyVersionId) && Objects.equals(this.keyId, other.keyId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.vaultId, other.vaultId) && Objects.equals(this.encryptedKey, other.encryptedKey) && Objects.equals((Object)this.algorithm, (Object)other.algorithm) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.keyVersionId == null ? 43 : this.keyVersionId.hashCode());
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + (this.encryptedKey == null ? 43 : this.encryptedKey.hashCode());
        result = result * 59 + (this.algorithm == null ? 43 : this.algorithm.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Algorithm implements BmcEnum
    {
        RsaOaepAesSha256("RSA_OAEP_AES_SHA256"),
        RsaOaepSha256("RSA_OAEP_SHA256"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Algorithm> map;

        private Algorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Algorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Algorithm', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Algorithm.class);
            map = new HashMap<String, Algorithm>();
            for (Algorithm v : Algorithm.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="keyVersionId")
        private String keyVersionId;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="encryptedKey")
        private String encryptedKey;
        @JsonProperty(value="algorithm")
        private Algorithm algorithm;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder keyVersionId(String keyVersionId) {
            this.keyVersionId = keyVersionId;
            this.__explicitlySet__.add("keyVersionId");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder encryptedKey(String encryptedKey) {
            this.encryptedKey = encryptedKey;
            this.__explicitlySet__.add("encryptedKey");
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            this.__explicitlySet__.add("algorithm");
            return this;
        }

        public ExportedKeyData build() {
            ExportedKeyData model = new ExportedKeyData(this.keyVersionId, this.keyId, this.timeCreated, this.vaultId, this.encryptedKey, this.algorithm);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExportedKeyData model) {
            if (model.wasPropertyExplicitlySet("keyVersionId")) {
                this.keyVersionId(model.getKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("encryptedKey")) {
                this.encryptedKey(model.getEncryptedKey());
            }
            if (model.wasPropertyExplicitlySet("algorithm")) {
                this.algorithm(model.getAlgorithm());
            }
            return this;
        }
    }
}

