/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.artifact.ArtifactPackagingMapper;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.locator.ArtifactLocator;
import org.apache.maven.index.locator.GavHelpedLocator;
import org.apache.maven.index.locator.Locator;
import org.apache.maven.index.locator.MetadataLocator;
import org.apache.maven.index.locator.PomLocator;
import org.codehaus.plexus.util.StringUtils;

@Singleton
@Named
public class DefaultArtifactContextProducer
implements ArtifactContextProducer {
    private final ArtifactPackagingMapper mapper;
    private GavHelpedLocator pl = new PomLocator();
    private Locator ml = new MetadataLocator();

    @Inject
    public DefaultArtifactContextProducer(ArtifactPackagingMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public ArtifactContext getArtifactContext(IndexingContext context, File file) {
        File pom;
        File artifact;
        String repositoryPath = context.getRepository().getAbsolutePath();
        String artifactPath = file.getAbsolutePath();
        if (artifactPath.length() <= repositoryPath.length()) {
            return null;
        }
        if (!this.isIndexable(file)) {
            return null;
        }
        Gav gav = this.getGavFromPath(context, repositoryPath, artifactPath);
        if (gav == null) {
            return null;
        }
        if (file.getName().endsWith(".pom")) {
            ArtifactLocator al = new ArtifactLocator(this.mapper);
            artifact = al.locate(file, context.getGavCalculator(), gav);
            if (artifact != null) {
                gav = this.getGavFromPath(context, repositoryPath, artifact.getAbsolutePath());
            }
            pom = file;
        } else {
            artifact = file;
            pom = this.pl.locate(file, context.getGavCalculator(), gav);
        }
        String groupId = gav.getGroupId();
        String artifactId = gav.getArtifactId();
        String version = gav.getBaseVersion();
        String classifier = gav.getClassifier();
        ArtifactInfo ai = new ArtifactInfo(context.getRepositoryId(), groupId, artifactId, version, classifier, gav.getExtension());
        if (!StringUtils.isEmpty((String)ai.getClassifier())) {
            ai.setPackaging(gav.getExtension());
        }
        ai.setFileName(file.getName());
        ai.setFileExtension(gav.getExtension());
        File metadata = this.ml.locate(pom);
        return new ArtifactContext(pom, artifact, metadata, ai, gav);
    }

    protected boolean isIndexable(File file) {
        if (file == null) {
            return false;
        }
        String filename = file.getName();
        return !(filename.equals("maven-metadata.xml") || filename.startsWith("maven-metadata-") && filename.endsWith(".xml") || filename.startsWith("_") && filename.endsWith(".repositories") || filename.endsWith(".properties") || filename.endsWith(".asc") || filename.endsWith(".md5") || filename.endsWith(".sha1"));
    }

    protected Gav getGavFromPath(IndexingContext context, String repositoryPath, String artifactPath) {
        String path = artifactPath.substring(repositoryPath.length() + 1).replace('\\', '/');
        return context.getGavCalculator().pathToGav(path);
    }
}

