/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import com.sun.source.util.TreePath;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.beans.CdiUtil;
import org.netbeans.modules.web.beans.api.model.BeansModel;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.InjectablesModel;
import org.netbeans.modules.web.beans.navigation.InjectablesPopup;
import org.netbeans.modules.web.beans.navigation.PopupUtil;
import org.netbeans.modules.web.beans.navigation.actions.AbstractCdiAction;
import org.netbeans.modules.web.beans.navigation.actions.GoToInjectableAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GoToDecoratorAtCaretAction
extends AbstractCdiAction {
    private static final long serialVersionUID = 6777839777383350958L;
    private static final String GOTO_DECORATOR_AT_CARET = "go-to-decorator-at-caret";
    private static final String GOTO_DECORATOR_AT_CARET_POPUP = "go-to-decorator-at-caret-popup";

    public GoToDecoratorAtCaretAction() {
        super(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)GOTO_DECORATOR_AT_CARET));
    }

    @Override
    protected boolean findContext(final JTextComponent component, final Object[] context) {
        JavaSource javaSource = JavaSource.forDocument((Document)component.getDocument());
        if (javaSource == null) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){
                final /* synthetic */ GoToDecoratorAtCaretAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    int dot = component.getCaret().getDot();
                    TreePath tp = controller.getTreeUtilities().pathFor(dot);
                    Element contextElement = controller.getTrees().getElement(tp);
                    if (contextElement == null) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebBeansActionHelper.class, (String)"LBL_ElementNotFound"));
                        return;
                    }
                    context[0] = contextElement;
                }
            }, true);
        }
        catch (IOException e) {
            Logger.getLogger(GoToDecoratorAtCaretAction.class.getName()).log(Level.INFO, e.getMessage(), e);
        }
        boolean result = context[0] instanceof TypeElement;
        if (!result) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToDecoratorAtCaretAction.class, (String)"LBL_NotTypeElement"), 700);
        } else {
            context[0] = ElementHandle.create((Element)((TypeElement)context[0]));
        }
        return result;
    }

    @Override
    protected void modelAcessAction(WebBeansModel model, final MetadataModel<WebBeansModel> metaModel, Object[] subject, final JTextComponent component, FileObject fileObject) {
        Element element = ((ElementHandle)subject[0]).resolve((CompilationInfo)model.getCompilationController());
        if (element == null) {
            return;
        }
        Collection<TypeElement> decorators = model.getDecorators((TypeElement)element);
        if (decorators.size() == 0) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToDecoratorAtCaretAction.class, (String)"LBL_DecoratorsNotFound"), 700);
            return;
        }
        BeansModel beansModel = model.getModelImplementation().getBeansModel();
        final LinkedHashSet<TypeElement> enabledDecorators = WebBeansActionHelper.getEnabledDecorators(decorators, beansModel, null, model.getCompilationController());
        if (enabledDecorators.size() == 0) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToDecoratorAtCaretAction.class, (String)"LBL_EnabledDecoratorsNotFound"), 700);
            return;
        }
        if (enabledDecorators.size() == 1) {
            final ElementHandle handle = ElementHandle.create((Element)((TypeElement)enabledDecorators.iterator().next()));
            final ClasspathInfo classpathInfo = model.getCompilationController().getClasspathInfo();
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ GoToDecoratorAtCaretAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    ElementOpen.open((ClasspathInfo)classpathInfo, (ElementHandle)handle);
                }
            });
        } else {
            final CompilationController controller = model.getCompilationController();
            if (SwingUtilities.isEventDispatchThread()) {
                this.showPopup(enabledDecorators, controller, metaModel, component);
            } else {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ GoToDecoratorAtCaretAction this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        this.this$0.showPopup(enabledDecorators, controller, (MetadataModel<WebBeansModel>)metaModel, component);
                    }
                });
            }
        }
    }

    private void showPopup(LinkedHashSet<TypeElement> elements, CompilationController controller, MetadataModel<WebBeansModel> model, JTextComponent target) {
        ArrayList<ElementHandle<? extends Element>> handles = new ArrayList<ElementHandle<? extends Element>>(elements.size());
        for (TypeElement element : elements) {
            handles.add(ElementHandle.create((Element)element));
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)"LBL_WaitNode"));
        try {
            Rectangle rectangle = target.modelToView(target.getCaret().getDot());
            Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
            SwingUtilities.convertPointToScreen(point, target);
            String title = NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_ChooseDecorator");
            PopupUtil.showPopup(new InjectablesPopup(title, handles, controller), title, point.x, point.y);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    protected String getActionCommand() {
        return GOTO_DECORATOR_AT_CARET;
    }

    @Override
    protected String getPopupMenuKey() {
        return GOTO_DECORATOR_AT_CARET_POPUP;
    }

    @Override
    protected void handleProject(Project project, ActionEvent event) {
        String msg = null;
        msg = event == null ? "USG_CDI_GO_TO_DECORATOR_GLYPH" : "USG_CDI_GO_TO_DECORATOR";
        CdiUtil logger = (CdiUtil)project.getLookup().lookup(CdiUtil.class);
        if (logger != null) {
            logger.log(msg, GoToDecoratorAtCaretAction.class, new Object[]{project.getClass().getName()});
        }
    }
}

