/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.batch;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchSearch;
import org.netbeans.modules.java.hints.spiimpl.batch.ProgressHandleWrapper;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class Scopes {
    public static BatchSearch.Scope allOpenedProjectsScope() {
        return new AllOpenedProjectsScope();
    }

    public static BatchSearch.Scope specifiedFoldersScope(BatchSearch.Folder ... roots) {
        return new SpecificFoldersScope(roots);
    }

    public static BatchSearch.MapIndices getDefaultIndicesMapper() {
        return (root, progress, recursive) -> {
            BatchSearch.IndexEnquirer e = Scopes.findIndexEnquirer(root, progress, recursive);
            return e != null ? e : new BatchSearch.FileSystemBasedIndexEnquirer(root, recursive);
        };
    }

    public static BatchSearch.IndexEnquirer findIndexEnquirer(FileObject root, ProgressHandleWrapper progress, boolean recursive) {
        for (BatchSearch.MapIndices mi : Lookup.getDefault().lookupAll(BatchSearch.MapIndices.class)) {
            BatchSearch.IndexEnquirer r = mi.findIndex(root, progress, recursive);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private static final class AllOpenedProjectsScope
    extends BatchSearch.Scope {
        private AllOpenedProjectsScope() {
        }

        @Override
        public String getDisplayName() {
            return "All Opened Projects";
        }

        @Override
        public Collection<? extends BatchSearch.Folder> getTodo() {
            HashSet<BatchSearch.Folder> todo = new HashSet<BatchSearch.Folder>();
            for (ClassPath source : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                todo.addAll(Arrays.asList(BatchSearch.Folder.convert(source.getRoots())));
            }
            return todo;
        }

        @Override
        public BatchSearch.MapIndices getIndexMapper(Iterable<? extends HintDescription> hints) {
            return Scopes.getDefaultIndicesMapper();
        }
    }

    private static final class SpecificFoldersScope
    extends BatchSearch.Scope {
        private final Collection<? extends BatchSearch.Folder> roots;

        public SpecificFoldersScope(BatchSearch.Folder ... roots) {
            this.roots = Arrays.asList(roots);
        }

        @Override
        public String getDisplayName() {
            return "Specified Root";
        }

        @Override
        public Collection<? extends BatchSearch.Folder> getTodo() {
            return this.roots;
        }

        @Override
        public BatchSearch.MapIndices getIndexMapper(Iterable<? extends HintDescription> hints) {
            return Scopes.getDefaultIndicesMapper();
        }
    }
}

