/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import com.thaiopensource.relaxng.impl.CombineValidator;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.SchemaResolver;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import nu.validator.checker.XmlPiChecker;
import nu.validator.checker.jing.CheckerSchema;
import nu.validator.htmlparser.common.DocumentMode;
import nu.validator.htmlparser.common.DocumentModeHandler;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.localentities.LocalCacheEntityResolver;
import nu.validator.messages.BufferingRootNamespaceSniffer;
import nu.validator.messages.MessageEmitterAdapter;
import nu.validator.spec.Spec;
import nu.validator.xml.TypedInputSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class ValidationTransaction
implements DocumentModeHandler,
SchemaResolver {
    private static final Logger LOGGER = Logger.getLogger(ValidationTransaction.class.getCanonicalName());
    private static final String[] KNOWN_CONTENT_TYPES = new String[]{"application/atom+xml", "application/docbook+xml", "application/xhtml+xml", "application/xv+xml", "image/svg+xml"};
    private static final String[] NAMESPACES_FOR_KNOWN_CONTENT_TYPES = new String[]{"http://www.w3.org/2005/Atom", "http://docbook.org/ns/docbook", "http://www.w3.org/1999/xhtml", "http://www.w3.org/1999/xhtml", "http://www.w3.org/2000/svg"};
    protected static final String[] ALL_CHECKERS = new String[]{"http://c.validator.nu/table/", "http://c.validator.nu/nfc/", "http://c.validator.nu/text-content/", "http://c.validator.nu/unchecked/", "http://c.validator.nu/usemap/", "http://c.validator.nu/obsolete/", "http://c.validator.nu/xml-pi/"};
    private static final String[] ALL_CHECKERS_HTML4 = new String[]{"http://c.validator.nu/table/", "http://c.validator.nu/nfc/", "http://c.validator.nu/unchecked/", "http://c.validator.nu/usemap/"};
    protected BufferingRootNamespaceSniffer bufferingRootNamespaceSniffer = null;
    protected boolean rootNamespaceSeen = false;
    protected String contentType = null;
    protected static int[] presetDoctypes;
    protected static String[] presetLabels;
    protected static String[] presetUrls;
    protected static String[] presetNamespaces;
    protected MessageEmitterAdapter errorHandler;
    protected static String[] preloadedSchemaUrls;
    protected static Schema[] preloadedSchemas;
    private Map<String, Validator> loadedValidatorUrls = new HashMap<String, Validator>();
    protected Validator validator = null;
    protected LocalCacheEntityResolver entityResolver;
    private static final Pattern SPACE;
    protected static final int HTML5_SCHEMA = 3;
    protected static final int XHTML1STRICT_SCHEMA = 2;
    protected static final int XHTML1FRAMESET_SCHEMA = 4;
    protected static final int XHTML1TRANSITIONAL_SCHEMA = 1;
    protected static final int XHTML5_SCHEMA = 7;
    public HtmlParser htmlParser = null;
    protected PropertyMap jingPropertyMap;
    protected static Spec html5spec;
    protected XMLReader reader;
    protected LexicalHandler lexicalHandler;

    public void rootNamespace(String namespace, Locator locator) throws SAXException {
        if (this.validator == null) {
            int index = -1;
            for (int i = 0; i < presetNamespaces.length; ++i) {
                if (!namespace.equals(presetNamespaces[i])) continue;
                index = i;
                break;
            }
            if (index == -1) {
                String message = "Cannot find preset schema for namespace: \u201c" + namespace + "\u201d.";
                SAXException se = new SAXException(message);
                this.errorHandler.schemaError(se);
                throw se;
            }
            String label = presetLabels[index];
            String urls = presetUrls[index];
            this.errorHandler.info("Using the preset for " + label + " based on the root namespace " + namespace);
            try {
                this.validator = this.validatorByUrls(urls);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            catch (IncorrectSchemaException e) {
                throw new RuntimeException(e);
            }
            if (this.bufferingRootNamespaceSniffer == null) {
                throw new RuntimeException("Bug! bufferingRootNamespaceSniffer was null.");
            }
            this.bufferingRootNamespaceSniffer.setContentHandler(this.validator.getContentHandler());
        }
        if (!this.rootNamespaceSeen) {
            int i;
            this.rootNamespaceSeen = true;
            if (this.contentType != null && (i = Arrays.binarySearch(KNOWN_CONTENT_TYPES, this.contentType)) > -1 && !NAMESPACES_FOR_KNOWN_CONTENT_TYPES[i].equals(namespace)) {
                String message = "".equals(namespace) ? "\u201c" + this.contentType + "\u201d is not an appropriate Content-Type for a document whose root element is not in a namespace." : "\u201c" + this.contentType + "\u201d is not an appropriate Content-Type for a document whose root namespace is \u201c" + namespace + "\u201d.";
                SAXParseException spe = new SAXParseException(message, locator);
                this.errorHandler.warning(spe);
            }
        }
    }

    public void documentMode(DocumentMode mode, String publicIdentifier, String systemIdentifier) throws SAXException {
        this.documentMode(mode, publicIdentifier, systemIdentifier, false);
    }

    public void documentMode(DocumentMode mode, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
        if (this.validator == null) {
            try {
                if ("-//W3C//DTD XHTML 1.0 Transitional//EN".equals(publicIdentifier)) {
                    this.errorHandler.info("XHTML 1.0 Transitional doctype seen. Appendix C is not supported. Proceeding anyway for your convenience. The parser is still an HTML parser, so namespace processing is not performed and \u201cxml:*\u201d attributes are not supported. Using the schema for " + this.getPresetLabel(1) + "." + (html4SpecificAdditionalErrorChecks ? " HTML4-specific tokenization errors are enabled." : ""));
                    this.validator = this.validatorByDoctype(1);
                } else if ("-//W3C//DTD XHTML 1.0 Strict//EN".equals(publicIdentifier)) {
                    this.errorHandler.info("XHTML 1.0 Strict doctype seen. Appendix C is not supported. Proceeding anyway for your convenience. The parser is still an HTML parser, so namespace processing is not performed and \u201cxml:*\u201d attributes are not supported. Using the schema for " + this.getPresetLabel(2) + "." + (html4SpecificAdditionalErrorChecks ? " HTML4-specific tokenization errors are enabled." : ""));
                    this.validator = this.validatorByDoctype(2);
                } else if ("-//W3C//DTD HTML 4.01 Transitional//EN".equals(publicIdentifier)) {
                    this.errorHandler.info("HTML 4.01 Transitional doctype seen. Using the schema for " + this.getPresetLabel(1) + "." + (html4SpecificAdditionalErrorChecks ? "" : " HTML4-specific tokenization errors are not enabled."));
                    this.validator = this.validatorByDoctype(1);
                } else if ("-//W3C//DTD HTML 4.01//EN".equals(publicIdentifier)) {
                    this.errorHandler.info("HTML 4.01 Strict doctype seen. Using the schema for " + this.getPresetLabel(2) + "." + (html4SpecificAdditionalErrorChecks ? "" : " HTML4-specific tokenization errors are not enabled."));
                    this.validator = this.validatorByDoctype(2);
                } else if ("-//W3C//DTD HTML 4.0 Transitional//EN".equals(publicIdentifier)) {
                    this.errorHandler.info("Legacy HTML 4.0 Transitional doctype seen.  Please consider using HTML 4.01 Transitional instead. Proceeding anyway for your convenience with the schema for " + this.getPresetLabel(1) + "." + (html4SpecificAdditionalErrorChecks ? "" : " HTML4-specific tokenization errors are not enabled."));
                    this.validator = this.validatorByDoctype(1);
                } else if ("-//W3C//DTD HTML 4.0//EN".equals(publicIdentifier)) {
                    this.errorHandler.info("Legacy HTML 4.0 Strict doctype seen. Please consider using HTML 4.01 instead. Proceeding anyway for your convenience with the schema for " + this.getPresetLabel(2) + "." + (html4SpecificAdditionalErrorChecks ? "" : " HTML4-specific tokenization errors are not enabled."));
                    this.validator = this.validatorByDoctype(2);
                } else {
                    this.errorHandler.info("Using the schema for " + this.getPresetLabel(3) + "." + (html4SpecificAdditionalErrorChecks ? " HTML4-specific tokenization errors are enabled." : ""));
                    this.validator = this.validatorByDoctype(3);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            catch (IncorrectSchemaException e) {
                throw new RuntimeException(e);
            }
            ContentHandler ch = this.validator.getContentHandler();
            ch.setDocumentLocator(this.htmlParser.getDocumentLocator());
            ch.startDocument();
            this.reader.setContentHandler(ch);
        } else if (html4SpecificAdditionalErrorChecks) {
            this.errorHandler.info("HTML4-specific tokenization errors are enabled.");
        }
    }

    public Schema resolveSchema(String url, PropertyMap options) throws SAXException, IOException, IncorrectSchemaException {
        int i = Arrays.binarySearch(preloadedSchemaUrls, url);
        if (i > -1) {
            Schema rv = preloadedSchemas[i];
            if (options.contains((PropertyId)WrapProperty.ATTRIBUTE_OWNER)) {
                if (rv instanceof ProxySchema && ((ProxySchema)rv).getWrappedSchema() instanceof CheckerSchema) {
                    this.errorHandler.error(new SAXParseException("A non-schema checker cannot be used as an attribute schema.", null, url, -1, -1));
                    throw new IncorrectSchemaException();
                }
            } else {
                return rv;
            }
        }
        LOGGER.log(Level.INFO, "Going to create a non preloaded Schema for {0}", url);
        TypedInputSource schemaInput = (TypedInputSource)this.entityResolver.resolveEntity(null, url);
        Object sr = null;
        sr = "application/relax-ng-compact-syntax".equals(schemaInput.getType()) ? CompactSchemaReader.getInstance() : new AutoSchemaReader();
        Schema sch = sr.createSchema((InputSource)schemaInput, options);
        return sch;
    }

    protected Validator validatorByUrls(String schemaList) throws SAXException, IOException, IncorrectSchemaException {
        Validator v = null;
        String[] schemas = SPACE.split(schemaList);
        for (int i = schemas.length - 1; i > -1; --i) {
            int j;
            String url = schemas[i];
            if ("http://c.validator.nu/all/".equals(url) || "http://hsivonen.iki.fi/checkers/all/".equals(url)) {
                for (j = 0; j < ALL_CHECKERS.length; ++j) {
                    v = this.combineValidatorByUrl(v, ALL_CHECKERS[j]);
                }
                continue;
            }
            if ("http://c.validator.nu/all-html4/".equals(url) || "http://hsivonen.iki.fi/checkers/all-html4/".equals(url)) {
                for (j = 0; j < ALL_CHECKERS_HTML4.length; ++j) {
                    v = this.combineValidatorByUrl(v, ALL_CHECKERS_HTML4[j]);
                }
                continue;
            }
            v = this.combineValidatorByUrl(v, url);
        }
        return v;
    }

    private Validator combineValidatorByUrl(Validator val, String url) throws SAXException, IOException, IncorrectSchemaException {
        if (!"".equals(url)) {
            Validator v = this.validatorByUrl(url);
            val = val == null ? v : new CombineValidator(v, val);
        }
        return val;
    }

    private Validator validatorByUrl(String url) throws SAXException, IOException, IncorrectSchemaException {
        Schema sch;
        Validator validatorInstance;
        Validator v = this.loadedValidatorUrls.get(url);
        if (v != null) {
            return v;
        }
        if ("http://s.validator.nu/html5/html5full-aria.rnc".equals(url) || "http://s.validator.nu/xhtml5-aria-rdf-svg-mathml.rnc".equals(url) || "http://s.validator.nu/html5/html5full.rnc".equals(url) || "http://s.validator.nu/html5/xhtml5full-xhtml.rnc".equals(url) || "http://s.validator.nu/html5-aria-svg-mathml.rnc".equals(url)) {
            this.errorHandler.setSpec(html5spec);
        }
        if ((validatorInstance = (sch = this.resolveSchema(url, this.jingPropertyMap)).createValidator(this.jingPropertyMap)).getContentHandler() instanceof XmlPiChecker) {
            this.lexicalHandler = (LexicalHandler)((Object)validatorInstance.getContentHandler());
        }
        this.loadedValidatorUrls.put(url, v);
        return validatorInstance;
    }

    private String getPresetLabel(int schemaId) {
        for (int i = 0; i < presetDoctypes.length; ++i) {
            if (presetDoctypes[i] != schemaId) continue;
            return presetLabels[i];
        }
        return "unknown";
    }

    protected Validator validatorByDoctype(int schemaId) throws SAXException, IOException, IncorrectSchemaException {
        if (schemaId == 0) {
            return null;
        }
        for (int i = 0; i < presetDoctypes.length; ++i) {
            if (presetDoctypes[i] != schemaId) continue;
            return this.validatorByUrls(presetUrls[i]);
        }
        throw new RuntimeException("Doctype mappings not initialized properly.");
    }

    private static Schema schemaByUrl(String url, EntityResolver resolver, PropertyMap pMap) throws SAXException, IOException, IncorrectSchemaException {
        TypedInputSource schemaInput;
        LOGGER.fine(String.format("Will load schema: %s", url));
        long a = System.currentTimeMillis();
        try {
            schemaInput = (TypedInputSource)resolver.resolveEntity(null, url);
        }
        catch (ClassCastException e) {
            LOGGER.log(Level.SEVERE, url, e);
            throw e;
        }
        SchemaReader sr = null;
        if ("application/relax-ng-compact-syntax".equals(schemaInput.getType())) {
            sr = CompactSchemaReader.getInstance();
            LOGGER.log(Level.FINE, "Used CompactSchemaReader");
        } else {
            sr = new AutoSchemaReader();
            LOGGER.log(Level.FINE, "Used AutoSchemaReader");
        }
        long c = System.currentTimeMillis();
        Schema sch = sr.createSchema((InputSource)schemaInput, pMap);
        LOGGER.log(Level.FINE, String.format("Schema created in %s ms.", System.currentTimeMillis() - c));
        return sch;
    }

    protected static Schema proxySchemaByUrl(String uri, EntityResolver resolver, PropertyMap pMap) {
        return new ProxySchema(uri, resolver, pMap);
    }

    static {
        SPACE = Pattern.compile("\\s+");
    }

    private static class ProxySchema
    implements Schema {
        private String uri;
        private EntityResolver resolver;
        private PropertyMap pMap;
        private SoftReference<Schema> delegateWeakRef;

        private ProxySchema(String uri, EntityResolver resolver, PropertyMap pMap) {
            this.uri = uri;
            this.resolver = resolver;
            this.pMap = pMap;
        }

        private Schema getWrappedSchema() throws SAXException, IOException, IncorrectSchemaException {
            return this.getSchemaDelegate();
        }

        public Validator createValidator(PropertyMap pm) {
            try {
                return this.getSchemaDelegate().createValidator(pm);
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "Cannot create schema delegate", ex);
                return null;
            }
        }

        public PropertyMap getProperties() {
            try {
                return this.getSchemaDelegate().getProperties();
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "Cannot create schema delegate", ex);
                return null;
            }
        }

        private synchronized Schema getSchemaDelegate() throws SAXException, IOException, IncorrectSchemaException {
            Schema delegate;
            Schema schema = delegate = this.delegateWeakRef != null ? this.delegateWeakRef.get() : null;
            if (delegate == null) {
                long a = System.currentTimeMillis();
                delegate = ValidationTransaction.schemaByUrl(this.uri, this.resolver, this.pMap);
                long b = System.currentTimeMillis();
                this.delegateWeakRef = new SoftReference<Schema>(delegate);
                LOGGER.log(Level.FINE, "Created new Schema instance for {0} in {1}ms.", new Object[]{this.uri, b - a});
            } else {
                LOGGER.log(Level.FINE, "Using cached Schema instance for {0}", this.uri);
            }
            return delegate;
        }
    }
}

