/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringUIFactory;
import org.netbeans.modules.refactoring.java.ui.SafeDeletePanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class SafeDeleteUI
implements RefactoringUI,
RefactoringUIBypass,
JavaRefactoringUIFactory {
    private SafeDeleteRefactoring refactoring;
    private Object[] elementsToDelete;
    private SafeDeletePanel panel;
    private ResourceBundle bundle;
    private boolean regulardelete = false;
    private Lookup lookup;

    private SafeDeleteUI(FileObject[] selectedFiles, Collection<TreePathHandle> handles, boolean regulardelete) {
        this.elementsToDelete = selectedFiles;
        this.refactoring = new SafeDeleteRefactoring((Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])this.elementsToDelete), Lookups.fixed((Object[])handles.toArray(new Object[0]))}));
        this.refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor(selectedFiles));
        this.regulardelete = regulardelete;
    }

    private SafeDeleteUI(TreePathHandle[] selectedElements) {
        this.elementsToDelete = selectedElements;
        this.refactoring = new SafeDeleteRefactoring(Lookups.fixed((Object[])this.elementsToDelete));
        this.refactoring.getContext().add((Object)RefactoringUtils.getClasspathInfoFor(selectedElements[0]));
    }

    private SafeDeleteUI(NonRecursiveFolder nonRecursiveFolder, boolean regulardelete) {
        this.refactoring = new SafeDeleteRefactoring(Lookups.fixed((Object[])new Object[]{nonRecursiveFolder}));
        this.refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor(nonRecursiveFolder.getFolder()));
        this.regulardelete = regulardelete;
    }

    private SafeDeleteUI(Lookup lookup) {
        this.lookup = lookup;
    }

    public Problem checkParameters() {
        this.refactoring.setCheckInComments(this.panel.isSearchInComments());
        return this.refactoring.fastCheckParameters();
    }

    public String getDescription() {
        NonRecursiveFolder folder = (NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        if (folder != null) {
            return NbBundle.getMessage(SafeDeleteUI.class, (String)"DSC_SafeDelPkg", (Object)folder.getFolder().getNameExt().replace('/', '.'));
        }
        return NbBundle.getMessage(SafeDeleteUI.class, (String)"DSC_SafeDel", (Object[])this.elementsToDelete);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.refactoring.java.ui.SafeDeleteUI");
    }

    public String getName() {
        return NbBundle.getMessage(SafeDeleteUI.class, (String)"LBL_SafeDel");
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new SafeDeletePanel(this.refactoring, this.regulardelete, parent);
        }
        return this.panel;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean hasParameters() {
        return true;
    }

    public boolean isQuery() {
        return false;
    }

    public Problem setParameters() {
        this.refactoring.setCheckInComments(this.panel.isSearchInComments());
        return this.refactoring.checkParameters();
    }

    public boolean isRefactoringBypassRequired() {
        return this.panel.isRegularDelete();
    }

    public void doRefactoringBypass() throws IOException {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                        public void run() throws IOException {
                            for (FileObject file : SafeDeleteUI.this.getRefactoring().getRefactoringSource().lookupAll(FileObject.class)) {
                                if (!file.isValid()) continue;
                                DataObject.find((FileObject)file).delete();
                            }
                            NonRecursiveFolder f = (NonRecursiveFolder)SafeDeleteUI.this.getRefactoring().getRefactoringSource().lookup(NonRecursiveFolder.class);
                            if (f != null) {
                                SafeDeleteUI.this.deletePackage(f.getFolder());
                            }
                        }
                    });
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void deletePackage(FileObject source) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)source, (String)"classpath/source");
        FileObject root = classPath != null ? classPath.findOwnerRoot(source) : null;
        DataFolder dataFolder = DataFolder.findFolder((FileObject)source);
        FileObject parent = dataFolder.getPrimaryFile().getParent();
        try {
            DataObject[] ch = dataFolder.getChildren();
            boolean empty = true;
            for (int i = 0; ch != null && i < ch.length; ++i) {
                if (!ch[i].getPrimaryFile().isFolder()) {
                    ch[i].delete();
                    continue;
                }
                if (!empty || !VisibilityQuery.getDefault().isVisible(ch[i].getPrimaryFile())) continue;
                empty = false;
            }
            if (empty) {
                dataFolder.delete();
            }
            while (!parent.equals(root) && parent.getChildren().length == 0) {
                FileObject newParent = parent.getParent();
                parent.delete();
                parent = newParent;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public RefactoringUI create(CompilationInfo info, TreePathHandle[] handles, FileObject[] files, NonRecursiveFolder[] packages) {
        boolean b;
        boolean bl = b = this.lookup.lookup(ExplorerContext.class) != null;
        if (packages != null && packages.length == 1) {
            return new SafeDeleteUI(packages[0], b);
        }
        if (handles != null && handles.length == 0 || files != null && files.length > 1) {
            return new SafeDeleteUI(files, Arrays.asList(handles), b);
        }
        if (b && files != null && files.length == 1) {
            return new SafeDeleteUI(files, Arrays.asList(handles), b);
        }
        if (info == null) {
            return new SafeDeleteUI(handles);
        }
        TreePathHandle selectedElement = handles[0];
        Element selected = selectedElement.resolveElement(info);
        TreePath selectedTree = selectedElement.resolve(info);
        if (selected == null || selectedTree == null) {
            return null;
        }
        if (selected.getKind() == ElementKind.PACKAGE || selected.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
            ElementHandle handle = ElementHandle.create((Element)selected);
            FileObject file = SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo());
            if (file == null) {
                return null;
            }
            if (file.getName().equals(selected.getSimpleName().toString())) {
                return new SafeDeleteUI(new FileObject[]{file}, Collections.singleton(selectedElement), b);
            }
        }
        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)selectedTree.getParentPath().getLeaf().getKind()) && selectedTree.getParentPath().getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && selectedTree.getLeaf().getKind() == Tree.Kind.VARIABLE) {
            switch (selectedTree.getParentPath().getLeaf().getKind()) {
                case BLOCK: 
                case METHOD: {
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return new SafeDeleteUI(new TreePathHandle[]{selectedElement});
    }

    public static JavaRefactoringUIFactory factory(Lookup lookup) {
        return new SafeDeleteUI(lookup);
    }
}

