/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSErrorObjectGen;
import com.oracle.truffle.js.runtime.objects.JSCopyableObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.objects.JSObject;

@ExportLibrary(value=InteropLibrary.class)
@ImportStatic(value={JSConfig.class})
public final class JSErrorObject
extends JSNonProxyObject
implements JSCopyableObject {
    protected JSErrorObject(Shape shape, JSDynamicObject proto) {
        super(shape, proto);
    }

    public static JSErrorObject create(Shape shape, JSDynamicObject proto) {
        return new JSErrorObject(shape, proto);
    }

    @Override
    protected JSObject copyWithoutProperties(Shape shape) {
        return new JSErrorObject(shape, this.getPrototypeOf());
    }

    public GraalJSException getException() {
        return JSError.getException(this);
    }

    @ExportMessage
    public boolean isException() {
        return true;
    }

    @ExportMessage
    public RuntimeException throwException() {
        throw this.getException();
    }

    @ExportMessage
    public ExceptionType getExceptionType(@Cached.Shared(value="exceptions") @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) throws UnsupportedMessageException {
        return exceptions.getExceptionType((Object)this.getException());
    }

    @ExportMessage
    public boolean isExceptionIncompleteSource(@Cached.Shared(value="exceptions") @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) throws UnsupportedMessageException {
        return exceptions.isExceptionIncompleteSource((Object)this.getException());
    }

    @ExportMessage
    public boolean hasExceptionMessage(@Cached.Shared(value="exceptions") @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) {
        return exceptions.hasExceptionMessage((Object)this.getException());
    }

    @ExportMessage
    public Object getExceptionMessage(@Cached.Shared(value="exceptions") @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) throws UnsupportedMessageException {
        return exceptions.getExceptionMessage((Object)this.getException());
    }

    @ExportMessage
    public boolean hasExceptionStackTrace(@Cached.Shared(value="exceptions") @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) {
        return exceptions.hasExceptionStackTrace((Object)this.getException());
    }

    @ExportMessage
    public Object getExceptionStackTrace(@Cached.Shared(value="exceptions") @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) throws UnsupportedMessageException {
        return exceptions.getExceptionStackTrace((Object)this.getException());
    }

    @ExportMessage
    public boolean hasExceptionCause(@Cached.Shared(value="exceptions") @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) {
        return exceptions.hasExceptionCause((Object)this.getException());
    }

    @ExportMessage
    public Object getExceptionCause(@Cached.Shared(value="exceptions") @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) throws UnsupportedMessageException {
        return exceptions.getExceptionCause((Object)this.getException());
    }

    public static void ensureInitialized() throws ClassNotFoundException {
        Class.forName(JSErrorObjectGen.class.getName());
    }

    @ExportMessage
    public static final class IsIdenticalOrUndefined {
        @Specialization
        public static TriState doError(JSErrorObject receiver, JSDynamicObject other) {
            return TriState.valueOf((receiver == other ? 1 : 0) != 0);
        }

        @Specialization
        public static TriState doException(JSErrorObject receiver, GraalJSException other) {
            return TriState.valueOf((receiver == other.getErrorObjectLazy() ? 1 : 0) != 0);
        }

        @Fallback
        public static TriState doOther(JSErrorObject receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }
}

