/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.beans;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndexListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.RootsEvent;
import org.netbeans.api.java.source.TypesEvent;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

class FxBeanCache
implements ChangeListener {
    private final Map<String, Reference<ClasspathCache>> cache = new HashMap<String, Reference<ClasspathCache>>();
    private static volatile FxBeanCache INSTANCE;

    FxBeanCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static FxBeanCache instance() {
        if (INSTANCE != null) return INSTANCE;
        Class<FxBeanCache> clazz = FxBeanCache.class;
        synchronized (FxBeanCache.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new FxBeanCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        ClasspathInfo source = (ClasspathInfo)e.getSource();
        Map<String, Reference<ClasspathCache>> map = this.cache;
        synchronized (map) {
            this.cache.remove(source);
        }
    }

    private static void addCp(StringBuilder sb, ClassPath cp) {
        if (cp == null) {
            return;
        }
        sb.append(cp.toString());
    }

    private String createKey(ClasspathInfo cp) {
        StringBuilder sb = new StringBuilder();
        FxBeanCache.addCp(sb, cp.getClassPath(ClasspathInfo.PathKind.BOOT));
        sb.append("/");
        FxBeanCache.addCp(sb, cp.getClassPath(ClasspathInfo.PathKind.COMPILE));
        sb.append("/");
        FxBeanCache.addCp(sb, cp.getClassPath(ClasspathInfo.PathKind.SOURCE));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FxBean getBeanInfo(ClasspathInfo cp, String classname) {
        Map<String, Reference<ClasspathCache>> map = this.cache;
        synchronized (map) {
            Reference<ClasspathCache> c = this.cache.get(this.createKey(cp));
            if (c == null) {
                return null;
            }
            ClasspathCache cc = c.get();
            if (cc == null) {
                return null;
            }
            return cc.getBean(classname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanInfo(ClasspathInfo cp, FxBean instance, Set<String> parents) {
        ClasspathCache cc = null;
        Map<String, Reference<ClasspathCache>> map = this.cache;
        synchronized (map) {
            String key = this.createKey(cp);
            Reference<ClasspathCache> c = this.cache.get(key);
            if (c != null) {
                cc = c.get();
            }
            if (cc == null) {
                cc = new ClasspathCache(cp);
                this.cache.put(key, new CacheRef(cc, key));
            }
        }
        cc.addBeanInfo(instance, parents);
    }

    private static class ClasspathCache
    implements ClassIndexListener {
        private final Map<String, FxBean> classInfos = new HashMap<String, FxBean>();
        private final Map<String, Object> dependencies = new HashMap<String, Object>();

        private ClasspathCache(ClasspathInfo cpInfo) {
            cpInfo.getClassIndex().addClassIndexListener((ClassIndexListener)WeakListeners.create(ClassIndexListener.class, (EventListener)((Object)this), (Object)cpInfo));
        }

        public void typesRemoved(TypesEvent event) {
            this.clearFrom(event);
        }

        public void typesChanged(TypesEvent event) {
            this.clearFrom(event);
        }

        public void rootsAdded(RootsEvent event) {
            this.clear();
        }

        public void rootsRemoved(RootsEvent event) {
            this.clear();
        }

        public void typesAdded(TypesEvent event) {
        }

        private synchronized void clear() {
            this.classInfos.clear();
            this.dependencies.clear();
        }

        private synchronized void addDependency(String from, String to) {
            HashSet<String> deps;
            Object o = this.dependencies.get(from);
            if (o == null) {
                this.dependencies.put(from, to);
                return;
            }
            if (o instanceof String) {
                if (to.equals(o)) {
                    return;
                }
                deps = new HashSet<String>();
                deps.add((String)o);
                this.dependencies.put(from, deps);
            } else {
                deps = (HashSet<String>)o;
            }
            deps.add(to);
        }

        private void clearFrom(TypesEvent event) {
            ArrayList<String> fqns = new ArrayList<String>();
            for (ElementHandle t : event.getTypes()) {
                fqns.add(t.getQualifiedName());
            }
            this.clearFrom(fqns);
        }

        public synchronized FxBean getBean(String fqn) {
            return this.classInfos.get(fqn);
        }

        public synchronized void clearFrom(Collection<String> roots) {
            HashSet<String> allDeps = new HashSet<String>();
            LinkedList<String> process = new LinkedList<String>();
            process.addAll(roots);
            while (!process.isEmpty()) {
                String x = (String)process.removeFirst();
                allDeps.add(x);
                Object deps = this.dependencies.get(x);
                if (deps == null) continue;
                if (deps instanceof String) {
                    process.add((String)deps);
                    continue;
                }
                process.addAll((Collection)deps);
            }
            this.dependencies.keySet().removeAll(allDeps);
            this.classInfos.keySet().removeAll(allDeps);
        }

        public synchronized void addBeanInfo(FxBean info, Set<String> superClasses) {
            String clName = info.getClassName();
            if (this.classInfos.containsKey(clName)) {
                return;
            }
            this.classInfos.put(clName, info);
            for (String scn : superClasses) {
                this.addDependency(scn, clName);
            }
        }
    }

    private static class CacheRef
    extends WeakReference<ClasspathCache>
    implements Runnable {
        private String refKey;

        public CacheRef(ClasspathCache referent, String key) {
            super(referent, Utilities.activeReferenceQueue());
            this.refKey = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = FxBeanCache.instance().cache;
            synchronized (map) {
                Map m = FxBeanCache.instance().cache;
                Object o = m.get(this.refKey);
                if (o == this) {
                    m.remove(this.refKey);
                }
            }
        }
    }
}

