/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import org.netbeans.lib.profiler.results.cpu.CPUResultsDiff;
import org.netbeans.lib.profiler.ui.components.table.DiffBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.cpu.CCTDisplay;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.utils.StringUtils;

public class DiffCCTDisplay
extends CCTDisplay {
    public DiffCCTDisplay(CPUResUserActionsHandler actionsHandler, Boolean sampling) {
        super(actionsHandler, sampling);
    }

    @Override
    protected boolean supportsReverseCallGraph() {
        return false;
    }

    @Override
    protected boolean supportsSubtreeCallGraph() {
        return false;
    }

    @Override
    protected Float getNodeTimeRel(long time, float percent) {
        return Float.valueOf(time);
    }

    @Override
    protected String getNodeTime(long time, float percent) {
        return this.getNodeSecondaryTime(time);
    }

    @Override
    protected String getNodeSecondaryTime(long time) {
        return (time > 0L ? "+" : "") + StringUtils.mcsTimeToString((long)time) + " ms";
    }

    @Override
    protected String getNodeInvocations(int nCalls) {
        return (nCalls > 0 ? "+" : "") + Integer.valueOf(nCalls).toString();
    }

    @Override
    protected void initColumnsData() {
        super.initColumnsData();
        this.columnRenderers[1] = new DiffBarCellRenderer(0L, 0L);
        this.columnRenderers[2] = new LabelTableCellRenderer(11);
    }

    @Override
    public void prepareResults() {
        super.prepareResults();
        DiffBarCellRenderer renderer = (DiffBarCellRenderer)this.columnRenderers[1];
        long bound = ((CPUResultsDiff)this.snapshot).getBound(this.currentView);
        renderer.setMinimum(-bound);
        renderer.setMaximum(bound);
    }
}

