/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarProvider;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.core.dev.wizard.EJBListViewChildren;
import org.netbeans.modules.websvc.core.dev.wizard.EjbChooser;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebServiceTypePanel
extends JPanel
implements HelpCtx.Provider,
ItemListener {
    private Project project;
    private Node[] sessionBeanNodes;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private boolean jsr109Supported;
    private boolean jsr109oldSupported;
    private boolean isWebModule;
    WSStackUtils stackUtils;
    private ButtonGroup buttonGroup1;
    private JButton jButtonConvert;
    private JButton jButtonDelegate;
    private JLabel jLabelConvert;
    private JLabel jLabelDelegate;
    private JRadioButton jRadioButtonConvert;
    private JRadioButton jRadioButtonDelegate;
    private JRadioButton jRadioButtonScratch;
    private JTextField jTextFieldConvert;
    private JTextField jTextFieldDelegate;
    private JCheckBox sessionBeanCB;

    public WebServiceTypePanel(Project project) {
        this.project = project;
        this.initComponents();
        this.stackUtils = new WSStackUtils(project);
        this.jsr109Supported = this.stackUtils.isJsr109Supported();
        this.jsr109oldSupported = this.stackUtils.isJsr109OldSupported();
        this.jRadioButtonConvert.setEnabled(false);
        this.jLabelConvert.setEnabled(false);
        this.jTextFieldConvert.setEnabled(false);
        this.jButtonConvert.setEnabled(false);
        this.jRadioButtonConvert.setVisible(false);
        this.jLabelConvert.setVisible(false);
        this.jTextFieldConvert.setVisible(false);
        this.jButtonConvert.setVisible(false);
        if (JaxWsUtils.isEjbJavaEE5orHigher(project)) {
            this.sessionBeanCB.setSelected(true);
            this.sessionBeanCB.setEnabled(false);
        } else if (WebServiceTypePanel.isEjbInWebSupported(project)) {
            this.sessionBeanCB.setEnabled(true);
        } else {
            this.sessionBeanCB.setEnabled(false);
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            this.isWebModule = J2eeModule.Type.WAR.equals(j2eeModuleProvider.getJ2eeModule().getType());
        }
        if (j2eeModuleProvider == null || !this.jsr109Supported && !this.jsr109oldSupported) {
            this.disableDelegateToEJB();
        }
        this.addItemListener(this);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jRadioButtonScratch = new JRadioButton();
        this.jRadioButtonDelegate = new JRadioButton();
        this.jLabelDelegate = new JLabel();
        this.jTextFieldDelegate = new JTextField();
        this.jButtonDelegate = new JButton();
        this.jRadioButtonConvert = new JRadioButton();
        this.jLabelConvert = new JLabel();
        this.jTextFieldConvert = new JTextField();
        this.jButtonConvert = new JButton();
        this.sessionBeanCB = new JCheckBox();
        this.buttonGroup1.add(this.jRadioButtonScratch);
        this.jRadioButtonScratch.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonScratch, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_EmptyWebService"));
        this.jRadioButtonScratch.setToolTipText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"HINT_EmptyWebService"));
        this.jRadioButtonScratch.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonGroup1.add(this.jRadioButtonDelegate);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonDelegate, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_EncapsulateSessionBean"));
        this.jRadioButtonDelegate.setToolTipText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"HINT_EnterpriseBean"));
        this.jRadioButtonDelegate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jLabelDelegate.setLabelFor(this.jTextFieldDelegate);
        Mnemonics.setLocalizedText((JLabel)this.jLabelDelegate, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_EnterpriseBean"));
        this.jLabelDelegate.setToolTipText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"HINT_EnterpriseBean"));
        this.jTextFieldDelegate.setEditable(false);
        this.jTextFieldDelegate.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonDelegate, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_Browse"));
        this.jButtonDelegate.setToolTipText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"HINT_BrowseBean"));
        this.jButtonDelegate.setEnabled(false);
        this.jButtonDelegate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceTypePanel.this.jButtonDelegateActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonConvert);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonConvert, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_ConvertJavaClass"));
        this.jRadioButtonConvert.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jLabelConvert.setLabelFor(this.jTextFieldConvert);
        Mnemonics.setLocalizedText((JLabel)this.jLabelConvert, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_JavaClass"));
        this.jTextFieldConvert.setEditable(false);
        this.jTextFieldConvert.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonConvert, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_Browse"));
        this.jButtonConvert.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.sessionBeanCB, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_WsAsSessionBean"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonScratch).addContainerGap(330, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonDelegate).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelConvert).addComponent(this.jLabelDelegate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldConvert).addComponent(this.jTextFieldDelegate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonConvert).addComponent(this.jButtonDelegate))).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonConvert, 0, 578, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.sessionBeanCB).addContainerGap()));
        layout.linkSize(0, this.jLabelConvert, this.jLabelDelegate);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonScratch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonDelegate, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDelegate).addComponent(this.jLabelDelegate).addComponent(this.jTextFieldDelegate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonConvert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelConvert).addComponent(this.jButtonConvert).addComponent(this.jTextFieldConvert, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.sessionBeanCB).addContainerGap(145, Short.MAX_VALUE)));
    }

    private void jButtonDelegateActionPerformed(ActionEvent evt) {
        Project[] allProjects = this.getCallableEjbProjects(this.project);
        LinkedList<2> ejbProjectNodes = new LinkedList<2>();
        for (int i = 0; i < allProjects.length; ++i) {
            LogicalViewProvider lvp = (LogicalViewProvider)allProjects[i].getLookup().lookup(LogicalViewProvider.class);
            Node projectView = lvp.createLogicalView();
            ejbProjectNodes.add(new FilterNode(projectView, (Children)new EJBListViewChildren(allProjects[i])){

                public Action[] getActions(boolean context) {
                    return new Action[0];
                }
            });
        }
        Children.Array children = new Children.Array();
        children.add(ejbProjectNodes.toArray(new Node[ejbProjectNodes.size()]));
        AbstractNode root = new AbstractNode((Children)children);
        EjbChooser chooser = new EjbChooser((Node)root, J2eeProjectCapabilities.forProject((Project)this.project).isEjb31LiteSupported());
        final DialogDescriptor dd = new DialogDescriptor((Object)chooser, NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_BrowseBean_Title"));
        dd.setValid(false);
        chooser.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ WebServiceTypePanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("ejbChooser_isValid") && (newvalue = evt.getNewValue()) instanceof Boolean) {
                    dd.setValid(((Boolean)newvalue).booleanValue());
                }
            }
        });
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.getAccessibleContext().setAccessibleDescription(dlg.getTitle());
        dlg.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            this.jTextFieldDelegate.setText(chooser.getSelectedEJBProjectName() + "#" + chooser.getSelectedNodes()[0].getDisplayName());
            this.sessionBeanNodes = chooser.getSelectedNodes();
            this.fireChange();
        }
    }

    void validate(WizardDescriptor wizardDescriptor) {
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.getServiceType() == 1 && this.jTextFieldDelegate.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_SelectOneEJB"));
            return false;
        }
        WSStackUtils.ErrorMessage message = this.stackUtils.getErrorMessage(WSStackUtils.WizardType.WS);
        if (message != null) {
            wizardDescriptor.putProperty(message.getWizardMessageProperty(), (Object)message.getText());
            if (message.isSerious()) {
                return false;
            }
        }
        return true;
    }

    void store(WizardDescriptor d) {
        d.putProperty("webServiceType", (Object)this.getServiceType());
        if (this.getServiceType() == 1) {
            d.putProperty("delegateToSessionBean", (Object)this.sessionBeanNodes);
        }
        d.putProperty("endpointAsStatelessBean", (Object)this.sessionBeanCB.isSelected());
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebServiceTypePanel.class);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src.equals(this.jRadioButtonScratch)) {
            this.jButtonDelegate.setEnabled(false);
            this.jTextFieldDelegate.setEnabled(false);
        } else if (src.equals(this.jRadioButtonDelegate)) {
            this.jButtonDelegate.setEnabled(true);
            this.jTextFieldDelegate.setEnabled(true);
        }
        this.fireChange();
    }

    public void addItemListener(ItemListener l) {
        this.jRadioButtonScratch.addItemListener(l);
        this.jRadioButtonDelegate.addItemListener(l);
    }

    public void removeItemListener(ItemListener l) {
        this.jRadioButtonScratch.removeItemListener(l);
        this.jRadioButtonDelegate.removeItemListener(l);
    }

    public int getServiceType() {
        if (this.jRadioButtonScratch.isSelected()) {
            return 0;
        }
        return 1;
    }

    private void disableDelegateToEJB() {
        this.jRadioButtonDelegate.setEnabled(false);
        this.jLabelDelegate.setEnabled(false);
        this.jTextFieldDelegate.setEnabled(false);
        this.jButtonDelegate.setEnabled(false);
    }

    private Project[] getCallableEjbProjects(Project enterpriseProject) {
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        boolean isCallerEJBModule = false;
        J2eeModuleProvider callerJ2eeModuleProvider = (J2eeModuleProvider)enterpriseProject.getLookup().lookup(J2eeModuleProvider.class);
        if (callerJ2eeModuleProvider != null && callerJ2eeModuleProvider.getJ2eeModule().getType().equals(J2eeModule.Type.EJB)) {
            isCallerEJBModule = true;
        }
        boolean isCallerFreeform = enterpriseProject.getClass().getName().equals("org.netbeans.modules.ant.freeform.FreeformProject");
        ArrayList<Project> filteredResults = new ArrayList<Project>(allProjects.length);
        for (int i = 0; i < allProjects.length; ++i) {
            boolean isEJBModule = false;
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)allProjects[i].getLookup().lookup(J2eeModuleProvider.class);
            EjbJarProvider ejbJarProvider = (EjbJarProvider)allProjects[i].getLookup().lookup(EjbJarProvider.class);
            if (j2eeModuleProvider != null && ejbJarProvider != null) {
                isEJBModule = true;
            }
            if ((!isEJBModule || isCallerFreeform) && (!isCallerFreeform || !enterpriseProject.equals((Object)allProjects[i]))) continue;
            filteredResults.add(allProjects[i]);
        }
        return filteredResults.toArray(new Project[filteredResults.size()]);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator<ChangeListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().stateChanged(e);
        }
    }

    private static boolean isEjbInWebSupported(Project prj) {
        J2eeModule j2eeModule;
        if (prj == null) {
            throw new IllegalArgumentException("Passed null to Util.isEjbInWebSupported(Project prj)");
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)prj.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            J2eeModule.Type type = j2eeModule.getType();
            String moduleVersion = j2eeModule.getModuleVersion();
            if (moduleVersion != null) {
                double version = Double.parseDouble(moduleVersion);
                if (J2eeModule.Type.WAR.equals(type) && version >= 3.0) {
                    return true;
                }
            }
        }
        return false;
    }
}

