/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.AbstractMap;
import java.util.HashMap;

class MyFontMetrics {
    public int width;
    public int height;
    public int ascent;
    public int leading;
    public FontMetrics fm;
    private WidthCache cwidth_cache;

    public MyFontMetrics(Component component, Font font) {
        this.fm = component.getFontMetrics(font);
        this.width = this.fm.charWidth('m');
        this.height = this.fm.getHeight();
        this.ascent = this.fm.getAscent();
        this.leading = this.fm.getLeading();
        this.height -= this.leading;
        this.leading = 0;
        this.cwidth_cache = CacheFactory.cacheForFontMetrics(this.fm);
    }

    protected void finalize() {
        CacheFactory.disposeBy(this.fm);
    }

    public boolean isMultiCell() {
        return this.cwidth_cache.isMultiCell();
    }

    public int wcwidth(char c) {
        int cell_width = this.cwidth_cache.cache[c];
        if (cell_width == 0) {
            int pixel_width = this.fm.charWidth(c);
            if (pixel_width == this.width) {
                cell_width = 1;
            } else if (pixel_width == 0) {
                cell_width = 1;
            } else {
                int mod = pixel_width % this.width;
                int rounded_width = pixel_width;
                rounded_width = mod > this.width / 2 ? pixel_width + (this.width - mod) : pixel_width - mod;
                cell_width = rounded_width / this.width;
                if (cell_width == 0) {
                    cell_width = 1;
                } else if (cell_width > 1) {
                    this.cwidth_cache.setMultiCell(true);
                }
            }
            this.cwidth_cache.cache[c] = (byte)cell_width;
        }
        return cell_width;
    }

    void checkForMultiCell(char c) {
        this.wcwidth(c);
    }

    private static final class CacheFactory {
        private static final AbstractMap<FontMetrics, WidthCache> map = new HashMap<FontMetrics, WidthCache>();

        private CacheFactory() {
        }

        static synchronized WidthCache cacheForFontMetrics(FontMetrics fm) {
            WidthCache entry = map.get(fm);
            if (entry == null) {
                entry = new WidthCache();
                map.put(fm, entry);
            } else {
                entry.up();
            }
            return entry;
        }

        static synchronized void disposeBy(FontMetrics fm) {
            WidthCache entry = map.get(fm);
            if (entry != null) {
                entry.down();
            }
        }
    }

    static class WidthCache {
        byte[] cache = new byte[65536];
        int reference_count = 1;
        private boolean multiCell = false;

        WidthCache() {
        }

        public void up() {
            ++this.reference_count;
            if (this.reference_count == 1) {
                this.cache = new byte[65536];
            }
        }

        public void down() {
            if (this.reference_count == 0) {
                return;
            }
            --this.reference_count;
            if (this.reference_count == 0) {
                this.cache = null;
            }
        }

        public boolean isMultiCell() {
            return this.multiCell;
        }

        public void setMultiCell(boolean multiCell) {
            this.multiCell = multiCell;
        }
    }
}

