/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.credentials;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.docker.api.Credentials;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.credentials.Bundle;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CredentialsPanel
extends JPanel {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    private final JPasswordField reference = new JPasswordField();
    private final JButton actionButton;
    private final Set<String> registries;
    private NotificationLineSupport messageLine;
    private JLabel emailLabel;
    private JTextField emailTextField;
    private JLabel passwordLabel;
    private JPasswordField passwordPasswordField;
    private JLabel registryLabel;
    private JTextField registryTextField;
    private JCheckBox showPasswordCheckBox;
    private JLabel usernameLabel;
    private JTextField usernameTextField;

    public CredentialsPanel(JButton actionButton, Set<String> registries) {
        this.initComponents();
        this.actionButton = actionButton;
        this.registries = registries;
        DefaultDocumentListener listener = new DefaultDocumentListener();
        this.registryTextField.getDocument().addDocumentListener(listener);
        this.usernameTextField.getDocument().addDocumentListener(listener);
        this.emailTextField.getDocument().addDocumentListener(listener);
    }

    public void setMessageLine(NotificationLineSupport messageLine) {
        this.messageLine = messageLine;
        this.validateInput();
    }

    private void validateInput() {
        if (this.messageLine == null) {
            return;
        }
        this.messageLine.clearMessages();
        this.actionButton.setEnabled(true);
        String registry = UiUtils.getValue(this.registryTextField);
        if (registry == null) {
            this.messageLine.setErrorMessage(Bundle.MSG_EmptyRegistry());
            this.actionButton.setEnabled(false);
            return;
        }
        if (this.registries.contains(registry)) {
            this.messageLine.setErrorMessage(Bundle.MSG_ExistingRegistry());
            this.actionButton.setEnabled(false);
            return;
        }
        String username = UiUtils.getValue(this.usernameTextField);
        if (username == null) {
            this.messageLine.setErrorMessage(Bundle.MSG_EmptyUsername());
            this.actionButton.setEnabled(false);
            return;
        }
        String email = UiUtils.getValue(this.emailTextField);
        if (email != null && !EMAIL_PATTERN.matcher(email).matches()) {
            this.messageLine.setWarningMessage(Bundle.MSG_InvalidEmail());
        }
    }

    public Credentials getCredentials() {
        return new Credentials(UiUtils.getValue(this.registryTextField), UiUtils.getValue(this.usernameTextField), this.passwordPasswordField.getPassword(), UiUtils.getValue(this.emailTextField));
    }

    public void setCredentials(Credentials credentials) {
        this.registryTextField.setEditable(false);
        this.registryTextField.setText(credentials.getRegistry());
        this.usernameTextField.setText(credentials.getUsername());
        if (credentials.getPassword() != null) {
            this.passwordPasswordField.setText(new String(credentials.getPassword()));
        }
        this.emailTextField.setText(credentials.getEmail());
    }

    private void initComponents() {
        this.registryLabel = new JLabel();
        this.registryTextField = new JTextField();
        this.usernameLabel = new JLabel();
        this.usernameTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordPasswordField = new JPasswordField();
        this.emailLabel = new JLabel();
        this.emailTextField = new JTextField();
        this.showPasswordCheckBox = new JCheckBox();
        this.registryLabel.setLabelFor(this.registryTextField);
        Mnemonics.setLocalizedText((JLabel)this.registryLabel, (String)NbBundle.getMessage(CredentialsPanel.class, (String)"CredentialsPanel.registryLabel.text"));
        this.usernameLabel.setLabelFor(this.usernameTextField);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(CredentialsPanel.class, (String)"CredentialsPanel.usernameLabel.text"));
        this.usernameTextField.setColumns(10);
        this.passwordLabel.setLabelFor(this.passwordPasswordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(CredentialsPanel.class, (String)"CredentialsPanel.passwordLabel.text"));
        this.emailLabel.setLabelFor(this.emailTextField);
        Mnemonics.setLocalizedText((JLabel)this.emailLabel, (String)NbBundle.getMessage(CredentialsPanel.class, (String)"CredentialsPanel.emailLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.showPasswordCheckBox, (String)NbBundle.getMessage(CredentialsPanel.class, (String)"CredentialsPanel.showPasswordCheckBox.text"));
        this.showPasswordCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CredentialsPanel.this.showPasswordCheckBoxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usernameLabel).addComponent(this.registryLabel).addComponent(this.passwordLabel).addComponent(this.emailLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.registryTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.passwordPasswordField, GroupLayout.Alignment.LEADING).addComponent(this.usernameTextField, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showPasswordCheckBox).addGap(0, 101, Short.MAX_VALUE)).addComponent(this.emailTextField)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.registryLabel).addComponent(this.registryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usernameLabel).addComponent(this.usernameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordPasswordField, -2, -1, -2).addComponent(this.showPasswordCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.emailLabel).addComponent(this.emailTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void showPasswordCheckBoxItemStateChanged(ItemEvent evt) {
        if (this.showPasswordCheckBox.isSelected()) {
            this.passwordPasswordField.setEchoChar('\u0000');
        } else {
            this.passwordPasswordField.setEchoChar(this.reference.getEchoChar());
        }
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CredentialsPanel.this.validateInput();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CredentialsPanel.this.validateInput();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CredentialsPanel.this.validateInput();
        }
    }
}

