/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.jellytools.EditorWindowOperator;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.Operator;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditor;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class EditorOperator
extends TopComponentOperator {
    private static final int WAIT_TIME = 60000;
    private JEditorPaneOperator _txtEditorPane;
    private JLabelOperator _lblRowColumn;
    private JLabelOperator _lblInputMode;
    private JLabelOperator _lblStatusBar;

    public EditorOperator(String filename) {
        this(filename, 0);
    }

    public EditorOperator(String filename, int index) {
        super(EditorOperator.waitTopComponent(null, (String)filename, (int)index, (ComponentChooser)new EditorSubchooser()));
        this.requestFocus();
    }

    public EditorOperator(ContainerOperator contOper, String filename) {
        this(contOper, filename, 0);
    }

    public EditorOperator(JComponent editorComponent) {
        super(editorComponent);
    }

    public EditorOperator(ContainerOperator contOper, String filename, int index) {
        super(EditorOperator.waitTopComponent((ContainerOperator)contOper, (String)filename, (int)index, (ComponentChooser)new EditorSubchooser()));
        this.copyEnvironment((Operator)contOper);
        this.requestFocus();
    }

    public static void closeDiscardAll() {
        Mode mode = (Mode)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("findMode"){

            public Object launch() {
                return WindowManager.getDefault().findMode("editor");
            }
        });
        EditorWindowOperator.closeDiscard(mode);
    }

    public void close(boolean save) {
        if (save) {
            super.save();
            this.close();
        } else {
            this.closeDiscard();
        }
    }

    static void close(final Object tc, boolean save) {
        Boolean isOpened = (Boolean)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("isOpened"){

            public Object launch() {
                return ((TopComponent)tc).isOpened();
            }
        });
        if (isOpened.booleanValue()) {
            TopComponentOperator tco = new TopComponentOperator((JComponent)((TopComponent)tc));
            if (save) {
                tco.save();
                tco.close();
            } else {
                tco.closeDiscard();
            }
        }
    }

    public JEditorPaneOperator txtEditorPane() {
        if (this._txtEditorPane == null) {
            this._txtEditorPane = new JEditorPaneOperator((ContainerOperator)this);
        }
        return this._txtEditorPane;
    }

    public JLabelOperator lblRowColumn() {
        if (this._lblRowColumn == null) {
            this._lblRowColumn = new JLabelOperator((ContainerOperator)this, 0);
        }
        return this._lblRowColumn;
    }

    public JLabelOperator lblInputMode() {
        if (this._lblInputMode == null) {
            this._lblInputMode = new JLabelOperator((ContainerOperator)this, 1);
        }
        return this._lblInputMode;
    }

    public JLabelOperator lblStatusBar() {
        if (this._lblStatusBar == null) {
            this._lblStatusBar = new JLabelOperator((ContainerOperator)this, 2);
        }
        return this._lblStatusBar;
    }

    public String getText() {
        return this.txtEditorPane().getText();
    }

    public String getText(int lineNumber) {
        return ((Line)this.getLine(lineNumber)).getText();
    }

    private Object getLine(int lineNumber) {
        Document doc = this.txtEditorPane().getDocument();
        DataObject od = (DataObject)doc.getProperty("stream");
        Line.Set set = ((LineCookie)od.getCookie(LineCookie.class)).getLineSet();
        try {
            return set.getCurrent(lineNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new JemmyException("Index must be > 0", (Throwable)e);
        }
    }

    public boolean contains(String text) {
        return this.getText().indexOf(text) != -1;
    }

    public void select(int lineNumber) {
        int lineOffset = this.getLineOffset(lineNumber);
        this.setCaretPosition(lineOffset);
        this.txtEditorPane().moveCaretPosition(lineOffset + this.getText(lineNumber).length());
    }

    public void select(int line1, int line2) {
        this.setCaretPosition(this.getLineOffset(line1));
        this.txtEditorPane().moveCaretPosition(this.getLineOffset(line2) + this.getText(line2).length());
    }

    public void select(int lineNumber, int column1, int column2) {
        int lineOffset = this.getLineOffset(lineNumber);
        this.setCaretPosition(lineOffset + column1 - 1);
        this.txtEditorPane().moveCaretPosition(lineOffset + column2);
    }

    public void select(String text, int index) {
        int position = this.txtEditorPane().getPositionByText(text, index);
        if (position == -1) {
            throw new JemmyException(index + "-th occurrence of \"" + text + "\" not found.");
        }
        this.setCaretPosition(position);
        this.txtEditorPane().moveCaretPosition(position + text.length());
    }

    public void select(String text) {
        this.select(text, 0);
    }

    public void replace(String oldText, String newText) {
        this.replace(oldText, newText, 0);
    }

    public void replace(String oldText, String newText, int index) {
        this.select(oldText, index);
        this.txtEditorPane().replaceSelection(newText);
    }

    public void insert(final String text) {
        final int offset = this.txtEditorPane().getCaretPosition();
        this.runMapping(new Operator.MapVoidAction(this, "insertString"){
            final /* synthetic */ EditorOperator this$0;
            {
                this.this$0 = this$0;
                super((Operator)this$0, description);
            }

            public void map() {
                try {
                    this.this$0.txtEditorPane().getDocument().insertString(offset, text, null);
                }
                catch (BadLocationException e) {
                    throw new JemmyException("Cannot insert \"" + text + "\" to position " + offset + ".", (Throwable)e);
                }
            }
        });
    }

    public void insert(String text, int lineNumber, int column) {
        this.setCaretPosition(lineNumber, column);
        this.insert(text);
    }

    public void delete(final int offset, final int length) {
        this.runMapping(new Operator.MapVoidAction(this, "remove"){
            final /* synthetic */ EditorOperator this$0;
            {
                this.this$0 = this$0;
                super((Operator)this$0, description);
            }

            public void map() {
                try {
                    this.this$0.txtEditorPane().getDocument().remove(offset, length);
                }
                catch (BadLocationException e) {
                    throw new JemmyException("Cannot delete " + length + " characters from position " + offset + ".", (Throwable)e);
                }
            }
        });
    }

    public void delete(int length) {
        this.delete(this.txtEditorPane().getCaretPosition(), length);
    }

    public void deleteLine(int line) {
        this.delete(this.getLineOffset(line), this.getText(line).length());
    }

    public void delete(int lineNumber, int column1, int column2) {
        this.delete(this.getLineOffset(lineNumber) + column1 - 1, column2 - column1 + 1);
    }

    public int getLineNumber() {
        StyledDocument doc = (StyledDocument)this.txtEditorPane().getDocument();
        int offset = this.txtEditorPane().getCaretPosition();
        return NbDocument.findLineNumber((StyledDocument)doc, (int)offset) + 1;
    }

    public void typeKey(char keyChar) {
        this.requestFocus();
        this.txtEditorPane().typeKey(keyChar);
    }

    public void typeKey(char keyChar, int modifiers) {
        this.requestFocus();
        this.txtEditorPane().typeKey(keyChar, modifiers);
    }

    public void typeKey(int keyCode, char keyChar, int modifiers) {
        this.requestFocus();
        this.txtEditorPane().typeKey(keyCode, keyChar, modifiers);
    }

    public void pushKey(int keyCode, int modifiers) {
        this.requestFocus();
        this.txtEditorPane().pushKey(keyCode, modifiers);
    }

    public void pushKey(int keyCode) {
        this.pushKey(keyCode, 0);
    }

    public void pushHomeKey() {
        this.pushKey(36);
    }

    public void pushEndKey() {
        this.pushKey(35);
    }

    public void pushTabKey() {
        this.pushKey(9);
    }

    public void pushDownArrowKey() {
        this.pushKey(40);
    }

    public void pushUpArrowKey() {
        this.pushKey(38);
    }

    private int getLineOffset(int lineNumber) {
        try {
            StyledDocument doc = (StyledDocument)this.txtEditorPane().getDocument();
            return NbDocument.findLineOffset((StyledDocument)doc, (int)(lineNumber - 1));
        }
        catch (IndexOutOfBoundsException e) {
            throw new JemmyException("Invalid line number " + lineNumber, (Throwable)e);
        }
    }

    public void setCaretPositionRelative(int relativeMove) {
        this.setCaretPosition(this.txtEditorPane().getCaretPosition() + relativeMove);
    }

    public void setCaretPositionToLine(int lineNumber) {
        this.txtEditorPane().setCaretPosition(this.getLineOffset(lineNumber));
    }

    public void setCaretPositionToEndOfLine(int lineNumber) {
        this.txtEditorPane().setCaretPosition(this.getLineOffset(lineNumber) + this.getText(lineNumber).length() - (this.getText(lineNumber).contains("\n") ? 1 : 0));
    }

    public void setCaretPosition(int lineNumber, int column) {
        this.setCaretPosition(this.getLineOffset(lineNumber) + column - 1);
    }

    public void setCaretPosition(int position) {
        if (position < 0 || position > this.getText().length()) {
            throw new JemmyException("Invalid caret position " + position);
        }
        this.txtEditorPane().setCaretPosition(position);
    }

    public void setCaretPosition(String text, int index, boolean before) {
        this.setCaretPosition(this.txtEditorPane().getPositionByText(text, index) + (before ? 0 : text.length()));
    }

    public void setCaretPosition(String text, boolean before) {
        this.setCaretPosition(text, 0, before);
    }

    public Object[] getAnnotations(final int lineNumber) {
        ArrayList result = (ArrayList)this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction(this, "getAnnotations"){
            final /* synthetic */ EditorOperator this$0;
            {
                this.this$0 = this$0;
                super(description);
            }

            public Object launch() {
                ArrayList result = new ArrayList();
                try {
                    Class<?> annotationsClass = Class.forName("org.netbeans.editor.Annotations");
                    Method getLineAnnotationsMethod = annotationsClass.getDeclaredMethod("getLineAnnotations", Integer.TYPE);
                    getLineAnnotationsMethod.setAccessible(true);
                    Object lineAnnotations = getLineAnnotationsMethod.invoke(this.this$0.getAnnotationsInstance(), lineNumber - 1);
                    if (lineAnnotations != null) {
                        result = this.this$0.getAnnotations(lineAnnotations);
                    }
                }
                catch (Exception e) {
                    throw new JemmyException("getAnnotations failed.", (Throwable)e);
                }
                return result;
            }
        });
        return result.toArray(new Annotation[0]);
    }

    public Object[] getAnnotations() {
        ArrayList result = (ArrayList)this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("getAnnotations"){

            public Object launch() {
                ArrayList result = new ArrayList();
                try {
                    Class<?> annotationsClass = Class.forName("org.netbeans.editor.Annotations");
                    Field lineAnnotationsArrayField = annotationsClass.getDeclaredField("lineAnnotationsArray");
                    lineAnnotationsArrayField.setAccessible(true);
                    List lineAnnotationsArray = (List)lineAnnotationsArrayField.get(EditorOperator.this.getAnnotationsInstance());
                    for (int i = 0; i < lineAnnotationsArray.size(); ++i) {
                        result.addAll(EditorOperator.this.getAnnotations(lineAnnotationsArray.get(i)));
                    }
                }
                catch (Exception e) {
                    throw new JemmyException("getAnnotations failed.", (Throwable)e);
                }
                return result;
            }
        });
        return result.toArray(new Annotation[0]);
    }

    private Object getAnnotationsInstance() throws Exception {
        Class<?> baseDocumentClass = Class.forName("org.netbeans.editor.BaseDocument");
        Method getAnnotationsMethod = baseDocumentClass.getDeclaredMethod("getAnnotations", null);
        getAnnotationsMethod.setAccessible(true);
        return getAnnotationsMethod.invoke((Object)this.txtEditorPane().getDocument(), (Object[])null);
    }

    private ArrayList<Object> getAnnotations(Object lineAnnotations) throws Exception {
        Class<?> lineAnnotationsClass = Class.forName("org.netbeans.editor.Annotations$LineAnnotations");
        Class<?> annotationDescDelegateClass = Class.forName("org.netbeans.modules.editor.NbEditorDocument$AnnotationDescDelegate", true, Thread.currentThread().getContextClassLoader());
        Field delegateField = annotationDescDelegateClass.getDeclaredField("delegate");
        delegateField.setAccessible(true);
        Method getAnnotationsMethod = lineAnnotationsClass.getDeclaredMethod("getAnnotations", null);
        getAnnotationsMethod.setAccessible(true);
        Iterator annotations = (Iterator)getAnnotationsMethod.invoke(lineAnnotations, (Object[])null);
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator it = annotations;
        while (it.hasNext()) {
            result.add(delegateField.get(it.next()));
        }
        return result;
    }

    public static String getAnnotationType(Object annotation) {
        return ((Annotation)annotation).getAnnotationType();
    }

    public static String getAnnotationShortDescription(Object annotation) {
        return ((Annotation)annotation).getShortDescription();
    }

    public AbstractButtonOperator getToolbarButton(String buttonTooltip) {
        ToolbarButtonChooser chooser = new ToolbarButtonChooser(buttonTooltip, this.getComparator());
        return new AbstractButtonOperator(AbstractButtonOperator.waitAbstractButton((Container)((Container)this.findParentTopComponent().getSource()), (ComponentChooser)chooser));
    }

    public AbstractButtonOperator getToolbarButton(int index) {
        ComponentChooser chooser = new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp instanceof JToolBar;
            }

            public String getDescription() {
                return "javax.swing.JToolBar";
            }
        };
        Container toolbar = (Container)EditorOperator.findComponent((Container)((Container)this.findParentTopComponent().getSource()), (ComponentChooser)chooser);
        if (toolbar == null) {
            throw new JemmyException("Toolbar not present.");
        }
        JComboBox combo = JComboBoxOperator.findJComboBox((Container)toolbar, (ComponentChooser)ComponentSearcher.getTrueChooser((String)"JComboBox"));
        if (combo != null) {
            ++index;
        }
        return new AbstractButtonOperator(AbstractButtonOperator.waitAbstractButton((Container)toolbar, (ComponentChooser)ComponentSearcher.getTrueChooser((String)"AbstractButton"), (int)index));
    }

    public void waitFolding() {
        JTextComponent textComponent = (JTextComponent)this.txtEditorPane().getSource();
        final AbstractDocument adoc = (AbstractDocument)this.txtEditorPane().getDocument();
        final FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)textComponent);
        this.getOutput().printTrace("Wait folding is initialized.");
        this.waitState(new ComponentChooser(){
            final /* synthetic */ EditorOperator this$0;
            {
                this.this$0 = this$0;
            }

            public boolean checkComponent(Component comp) {
                adoc.readLock();
                try {
                    boolean bl;
                    hierarchy.lock();
                    try {
                        bl = hierarchy.getRootFold().getFoldCount() > 0;
                    }
                    catch (Throwable throwable) {
                        hierarchy.unlock();
                        throw throwable;
                    }
                    hierarchy.unlock();
                    return bl;
                }
                finally {
                    adoc.readUnlock();
                }
            }

            public String getDescription() {
                return "Folding initialized";
            }
        });
    }

    public void waitCollapsed() {
        this.getOutput().printTrace("Wait fold is collapsed at line " + this.getLineNumber());
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return EditorOperator.this.isCollapsed();
            }

            public String getDescription() {
                return "Fold collapsed";
            }
        });
    }

    public void waitExpanded() {
        this.getOutput().printTrace("Wait fold is expanded at line " + this.getLineNumber());
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return !EditorOperator.this.isCollapsed();
            }

            public String getDescription() {
                return "Fold expanded";
            }
        });
    }

    public void collapseFold() {
        this.getOutput().printTrace("Collapse fold at line " + this.getLineNumber());
        this.requestFocus();
        this.txtEditorPane().pushKey(109, 128);
        this.waitCollapsed();
    }

    public void collapseFold(int lineNumber) {
        this.setCaretPositionToLine(lineNumber);
        this.collapseFold();
    }

    public void expandFold() {
        this.getOutput().printTrace("Expand fold at line " + this.getLineNumber());
        this.requestFocus();
        this.txtEditorPane().pushKey(107, 128);
        this.waitExpanded();
    }

    public void expandFold(int lineNumber) {
        this.setCaretPositionToLine(lineNumber);
        this.expandFold();
    }

    public boolean isCollapsed() {
        return this.isCollapsed(this.getLineNumber());
    }

    public boolean isCollapsed(int lineNumber) {
        JTextComponent textComponent = (JTextComponent)this.txtEditorPane().getSource();
        FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)textComponent);
        int dot = this.getLineOffset(lineNumber);
        hierarchy.lock();
        try {
            int rowStart = Utilities.getRowStart(textComponent, dot);
            int rowEnd = Utilities.getRowEnd(textComponent, dot);
            Fold fold = EditorOperator.getLineFold(hierarchy, dot, rowStart, rowEnd);
            if (fold != null) {
                boolean bl = fold.isCollapsed();
                return bl;
            }
            try {
                throw new JemmyException("No fold found at position " + dot + ".");
            }
            catch (BadLocationException ble) {
                throw new JemmyException("BadLocationException when seraching for fold.", (Throwable)ble);
            }
        }
        finally {
            hierarchy.unlock();
        }
    }

    private static Fold getLineFold(FoldHierarchy hierarchy, int dot, int lineStart, int lineEnd) {
        Fold nextFold;
        Fold caretOffsetFold = FoldUtilities.findOffsetFold((FoldHierarchy)hierarchy, (int)dot);
        Fold fold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)lineStart);
        while (fold != null && (fold.getEndOffset() <= dot || !fold.isCollapsed() && fold.getFoldCount() > 0 && fold.getStartOffset() + 1 < dot) && (nextFold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)(fold.getFoldCount() > 0 ? fold.getStartOffset() + 1 : fold.getEndOffset()))) != null && nextFold.getStartOffset() < lineEnd) {
            if (nextFold == fold) {
                return fold;
            }
            fold = nextFold;
        }
        if (fold == null || fold.getStartOffset() > lineEnd) {
            if (caretOffsetFold == null) {
                caretOffsetFold = FoldUtilities.findOffsetFold((FoldHierarchy)hierarchy, (int)lineStart);
            }
            return caretOffsetFold;
        }
        if (caretOffsetFold == null) {
            return fold;
        }
        if (caretOffsetFold.isCollapsed()) {
            return caretOffsetFold;
        }
        if (caretOffsetFold.getEndOffset() > fold.getEndOffset() && fold.getEndOffset() > dot) {
            return fold;
        }
        if (fold.getStartOffset() > caretOffsetFold.getEndOffset()) {
            return caretOffsetFold;
        }
        if (fold.getEndOffset() < dot) {
            return caretOffsetFold;
        }
        return fold;
    }

    public void waitModified(final boolean modified) {
        try {
            Waiter waiter = new Waiter(new Waitable(){
                final /* synthetic */ EditorOperator this$0;
                {
                    this.this$0 = this$0;
                }

                public Object actionProduced(Object obj) {
                    return this.this$0.isModified() == modified ? Boolean.TRUE : null;
                }

                public String getDescription() {
                    return "Wait Modified State=" + modified;
                }
            });
            Timeouts times = this.getTimeouts().cloneThis();
            times.setTimeout("Waiter.WaitingTime", times.getTimeout("EditorOperator.WaitModifiedTimeout"));
            waiter.setTimeouts(times);
            waiter.setOutput(this.getOutput());
            waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void save() {
        super.save();
        if (this.getVerification()) {
            this.waitModified(false);
        }
    }

    public void clickForPopup() {
        this.txtEditorPane().clickForPopup();
    }

    public void verify() {
        this.txtEditorPane();
    }

    static {
        Timeouts.initDefault((String)"EditorOperator.WaitModifiedTimeout", (long)60000L);
    }

    public static final class EditorSubchooser
    implements ComponentChooser {
        public boolean checkComponent(Component comp) {
            return comp instanceof CloneableEditor;
        }

        public String getDescription() {
            return "org.openide.text.CloneableEditor";
        }
    }

    private static class ToolbarButtonChooser
    implements ComponentChooser {
        private String buttonTooltip;
        private Operator.StringComparator comparator;

        public ToolbarButtonChooser(String buttonTooltip, Operator.StringComparator comparator) {
            this.buttonTooltip = buttonTooltip;
            this.comparator = comparator;
        }

        public boolean checkComponent(Component comp) {
            return this.comparator.equals(((JComponent)comp).getToolTipText(), this.buttonTooltip);
        }

        public String getDescription() {
            return "Toolbar button with tooltip \"" + this.buttonTooltip + "\".";
        }
    }
}

