/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.UserAttributeEntity;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowInvalidStateException;
import org.keycloak.storage.jpa.JpaHashUtils;

public class UserAttributeWorkflowConditionProvider
implements WorkflowConditionProvider {
    private final String expectedAttribute;
    private final KeycloakSession session;

    public UserAttributeWorkflowConditionProvider(KeycloakSession session, String expectedAttribute) {
        this.session = session;
        this.expectedAttribute = expectedAttribute;
    }

    public boolean evaluate(WorkflowExecutionContext context) {
        this.validate();
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = this.session.users().getUserById(realm, context.getResourceId());
        if (user == null) {
            return false;
        }
        String[] parsedKeyValuePair = UserAttributeWorkflowConditionProvider.parseKeyValuePair(this.expectedAttribute);
        List values = user.getAttributes().getOrDefault(parsedKeyValuePair[0], List.of());
        List<String> expectedValues = List.of(parsedKeyValuePair[1].split(","));
        return CollectionUtil.collectionEquals(expectedValues, values);
    }

    public Predicate toPredicate(CriteriaBuilder cb, CriteriaQuery<String> query, Root<?> path) {
        this.validate();
        String[] parsedKeyValuePair = UserAttributeWorkflowConditionProvider.parseKeyValuePair(this.expectedAttribute);
        String attributeName = parsedKeyValuePair[0];
        List<String> expectedValues = Arrays.asList(parsedKeyValuePair[1].split(","));
        Subquery matchingCountSubquery = query.subquery(Long.class);
        Root attrRoot1 = matchingCountSubquery.from(UserAttributeEntity.class);
        matchingCountSubquery.select(cb.count((Expression)attrRoot1));
        Predicate[] valuePredicates = (Predicate[])expectedValues.stream().map(expectedValue -> {
            if (expectedValue.length() > 255) {
                return cb.equal((Expression)attrRoot1.get("longValueHash"), (Object)JpaHashUtils.hashForAttributeValue(expectedValue));
            }
            return cb.equal((Expression)attrRoot1.get("value"), expectedValue);
        }).toArray(Predicate[]::new);
        matchingCountSubquery.where((Expression)cb.and(new Predicate[]{cb.equal((Expression)attrRoot1.get("user").get("id"), (Expression)path.get("id")), cb.equal((Expression)attrRoot1.get("name"), (Object)attributeName), cb.or(valuePredicates)}));
        Subquery totalCountSubquery = query.subquery(Long.class);
        Root attrRoot2 = totalCountSubquery.from(UserAttributeEntity.class);
        totalCountSubquery.select(cb.count((Expression)attrRoot2));
        totalCountSubquery.where((Expression)cb.and((Expression)cb.equal((Expression)attrRoot2.get("user").get("id"), (Expression)path.get("id")), (Expression)cb.equal((Expression)attrRoot2.get("name"), (Object)attributeName)));
        int expectedCount = expectedValues.size();
        return cb.and((Expression)cb.equal((Expression)matchingCountSubquery, (Object)expectedCount), (Expression)cb.equal((Expression)totalCountSubquery, (Object)expectedCount));
    }

    public void validate() {
        if (this.expectedAttribute == null) {
            throw new WorkflowInvalidStateException("Expected 'key:value' pair is not set.");
        }
    }

    public void close() {
    }

    public static String[] parseKeyValuePair(String keyValuePair) {
        Properties props = new Properties();
        try {
            props.load(new StringReader(keyValuePair));
        }
        catch (IOException e) {
            throw new WorkflowInvalidStateException("Error reading key-value pair " + keyValuePair + ". Expected format 'key:value'");
        }
        String key = props.stringPropertyNames().iterator().next();
        String value = props.getProperty(key);
        return new String[]{key, value};
    }
}

