/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.io.OutputStream;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Internal;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JdbcDateJavaType;
import org.hibernate.type.descriptor.java.JdbcTimeJavaType;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaType;
import org.hibernate.type.descriptor.java.OffsetDateTimeJavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.StructAttributeValues;
import org.hibernate.type.descriptor.jdbc.StructHelper;
import org.hibernate.type.descriptor.jdbc.XmlArrayJdbcType;

@Internal
public class XmlHelper {
    public static final String ROOT_TAG = "e";
    private static final String START_TAG = "<e>";
    private static final String END_TAG = "</e>";
    private static final String NULL_TAG = "<e/>";
    private static final String COLLECTION_START_TAG = "<Collection>";
    private static final String COLLECTION_END_TAG = "</Collection>";
    private static final String EMPTY_COLLECTION_TAG = "<Collection/>";
    private static final CollectionTags DEFAULT = new CollectionTags("Collection", "e");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String unescape(String string, int start, int end) {
        StringBuilder sb = new StringBuilder(end - start);
        block10: for (int i = start; i < end; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block10;
                }
                case '&': {
                    if (i + 3 >= end) throw new IllegalArgumentException("Illegal XML content: " + string.substring(start, end));
                    char c1 = string.charAt(i + 1);
                    switch (c1) {
                        case 'l': {
                            if (string.charAt(i + 2) != 't' || string.charAt(i + 3) != ';') continue block10;
                            sb.append('<');
                            i += 3;
                            continue block10;
                        }
                        case 'a': {
                            if (i + 4 < end && string.charAt(i + 2) == 'm' && string.charAt(i + 3) == 'p' && string.charAt(i + 4) == ';') {
                                sb.append('&');
                                i += 4;
                                continue block10;
                            }
                            if (i + 5 >= end || string.charAt(i + 2) != 'p' || string.charAt(i + 3) != 'o' || string.charAt(i + 4) != 's' || string.charAt(i + 5) != ';') continue block10;
                            sb.append('\'');
                            i += 5;
                            continue block10;
                        }
                        case 'g': {
                            if (string.charAt(i + 2) != 't' || string.charAt(i + 3) != ';') continue block10;
                            sb.append('>');
                            i += 3;
                            continue block10;
                        }
                        case 'q': {
                            if (i + 5 >= end || string.charAt(i + 2) != 'u' || string.charAt(i + 3) != 'o' || string.charAt(i + 4) != 't' || string.charAt(i + 5) != ';') continue block10;
                            sb.append('\"');
                            i += 5;
                            continue block10;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal XML content: " + string.substring(start, end));
                        }
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static Object fromString(EmbeddableMappingType embeddableMappingType, String string, boolean returnEmbeddable, WrapperOptions options, int selectableIndex, int start, int end) throws SQLException {
        JdbcMapping jdbcMapping = embeddableMappingType.getJdbcValueSelectable(selectableIndex).getJdbcMapping();
        return XmlHelper.fromString(jdbcMapping.getMappedJavaType(), jdbcMapping.getJdbcJavaType(), jdbcMapping.getJdbcType(), string, returnEmbeddable, options, start, end);
    }

    private static Object fromString(JavaType<?> javaType, JavaType<?> jdbcJavaType, JdbcType jdbcType, String string, boolean returnEmbeddable, WrapperOptions options, int start, int end) throws SQLException {
        switch (jdbcType.getDefaultSqlTypeCode()) {
            case -6: 
            case 4: 
            case 5: {
                if (jdbcJavaType.getJavaTypeClass() == Boolean.class) {
                    return jdbcJavaType.wrap(Integer.parseInt(string, start, end, 10), options);
                }
                if (jdbcJavaType instanceof EnumJavaType) {
                    return jdbcJavaType.wrap(Integer.parseInt(string, start, end, 10), options);
                }
            }
            case -7: 
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return jdbcJavaType.fromEncodedString(string, start, end);
            }
            case 91: {
                return jdbcJavaType.wrap(JdbcDateJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case 92: 
            case 2013: 
            case 3007: {
                return jdbcJavaType.wrap(JdbcTimeJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case 93: {
                return jdbcJavaType.wrap(JdbcTimestampJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case 2014: 
            case 3003: {
                return jdbcJavaType.wrap(OffsetDateTimeJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 3004: 
            case 4003: {
                return jdbcJavaType.wrap((byte[])PrimitiveByteArrayJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case 3000: {
                return jdbcJavaType.wrap(PrimitiveByteArrayJavaType.INSTANCE.fromString(string.substring(start, end).replace("-", "")), options);
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if (jdbcJavaType.getJavaTypeClass() != Boolean.class || end != start + 1) break;
                return jdbcJavaType.wrap(Character.valueOf(string.charAt(start)), options);
            }
        }
        if (jdbcType instanceof AggregateJdbcType) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)jdbcType;
            Object[] subValues = aggregateJdbcType.extractJdbcValues(CharSequenceHelper.subSequence(string, start, end), options);
            if (returnEmbeddable) {
                StructAttributeValues subAttributeValues = StructHelper.getAttributeValues(aggregateJdbcType.getEmbeddableMappingType(), subValues, options);
                return StructHelper.instantiate(aggregateJdbcType.getEmbeddableMappingType(), subAttributeValues);
            }
            return subValues;
        }
        String unescaped = XmlHelper.unescape(string, start, end);
        return jdbcJavaType.fromEncodedString(unescaped, 0, unescaped.length());
    }

    public static <X> X fromString(EmbeddableMappingType embeddableMappingType, String string, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        Object[] array;
        int end;
        int contentEnd;
        if (NULL_TAG.equals(string)) {
            return null;
        }
        for (contentEnd = string.length() - 1; contentEnd >= 0 && Character.isWhitespace(string.charAt(contentEnd)); --contentEnd) {
        }
        if (!string.startsWith(START_TAG) || !string.regionMatches(contentEnd - END_TAG.length() + 1, END_TAG, 0, END_TAG.length())) {
            throw new IllegalArgumentException("XML not properly formatted: " + string);
        }
        if (embeddableMappingType == null) {
            assert (!returnEmbeddable);
            ArrayList<Object> values = new ArrayList<Object>(8);
            end = XmlHelper.fromString(string, values, START_TAG.length());
            array = values.toArray();
        } else {
            array = new Object[embeddableMappingType.getJdbcValueCount() + (embeddableMappingType.isPolymorphic() ? 1 : 0)];
            end = XmlHelper.fromString(embeddableMappingType, string, returnEmbeddable, options, array, START_TAG.length());
        }
        assert (end + END_TAG.length() == contentEnd + 1);
        if (returnEmbeddable) {
            StructAttributeValues attributeValues = StructHelper.getAttributeValues(embeddableMappingType, array, options);
            return (X)StructHelper.instantiate(embeddableMappingType, attributeValues);
        }
        return (X)array;
    }

    public static <X> X arrayFromString(JavaType<X> javaType, XmlArrayJdbcType xmlArrayJdbcType, String string, WrapperOptions options) throws SQLException {
        if (string == null) {
            return null;
        }
        if (EMPTY_COLLECTION_TAG.equals(string)) {
            return javaType.wrap(Collections.emptyList(), options);
        }
        if (!string.startsWith(COLLECTION_START_TAG) || !string.endsWith(COLLECTION_END_TAG)) {
            throw new IllegalArgumentException("Illegal XML for array: " + string);
        }
        JavaType elementJavaType = ((BasicPluralJavaType)((Object)javaType)).getElementJavaType();
        Class<?> preferredJavaTypeClass = xmlArrayJdbcType.getElementJdbcType().getPreferredJavaTypeClass(options);
        JavaType<Object> jdbcJavaType = preferredJavaTypeClass == null || preferredJavaTypeClass == elementJavaType.getJavaTypeClass() ? elementJavaType : options.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(preferredJavaTypeClass);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int end = XmlHelper.fromArrayString(string, true, options, COLLECTION_START_TAG.length(), arrayList, elementJavaType, jdbcJavaType, xmlArrayJdbcType.getElementJdbcType());
        assert (end + COLLECTION_END_TAG.length() == string.length());
        return javaType.wrap(arrayList, options);
    }

    private static int fromString(String string, List<Object> values, int start) {
        int tagNameStart = -1;
        int contentStart = -1;
        String tagName = null;
        block5: for (int i = start; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    if (tagNameStart == -1) {
                        if (string.charAt(i + 1) == '/') {
                            assert (tagName == null);
                            assert (contentStart == -1);
                            return i;
                        }
                        tagNameStart = i + 1;
                        continue block5;
                    }
                    assert (contentStart != -1);
                    if (string.charAt(i + 1) == '/') {
                        assert (tagName != null);
                        values.add(XmlHelper.unescape(string, contentStart, i));
                    } else {
                        ArrayList<Object> subValues = new ArrayList<Object>(8);
                        int end = XmlHelper.fromString(string, subValues, i);
                        values.add(subValues.toArray());
                        assert (string.charAt(end) == '<');
                        assert (string.charAt(end + 1) == '/');
                        assert (string.regionMatches(end + 2, tagName, 0, tagName.length()));
                        i = end;
                    }
                    i += tagName.length() + 2;
                    tagNameStart = -1;
                    contentStart = -1;
                    tagName = null;
                    continue block5;
                }
                case '>': {
                    if (tagName == null) {
                        assert (contentStart == -1);
                        assert (tagNameStart != -1);
                        tagName = string.substring(tagNameStart, i);
                        contentStart = i + 1;
                        continue block5;
                    }
                    assert (contentStart != -1);
                    continue block5;
                }
                case '/': {
                    if (tagName == null) {
                        values.add(null);
                        tagNameStart = -1;
                        assert (string.charAt(++i) == '>');
                        continue block5;
                    }
                    assert (contentStart != -1);
                    continue block5;
                }
            }
        }
        throw new IllegalArgumentException("XML not properly formed: " + string.substring(start));
    }

    private static int fromString(EmbeddableMappingType embeddableMappingType, String string, boolean returnEmbeddable, WrapperOptions options, Object[] values, int start) throws SQLException {
        int tagNameStart = -1;
        int contentStart = -1;
        String tagName = null;
        block5: for (int i = start; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    if (tagNameStart == -1) {
                        if (string.charAt(i + 1) == '/') {
                            assert (tagName == null);
                            assert (contentStart == -1);
                            return i;
                        }
                        tagNameStart = i + 1;
                        continue block5;
                    }
                    assert (contentStart != -1);
                    if (string.charAt(i + 1) == '/') {
                        assert (tagName != null);
                        int selectableMapping = XmlHelper.getSelectableMapping(embeddableMappingType, tagName);
                        values[selectableMapping] = XmlHelper.fromString(embeddableMappingType, string, returnEmbeddable, options, selectableMapping, contentStart, i);
                    } else {
                        int selectableIndex = XmlHelper.getSelectableMapping(embeddableMappingType, tagName);
                        SelectableMapping selectable = embeddableMappingType.getJdbcValueSelectable(selectableIndex);
                        JdbcType jdbcType = selectable.getJdbcMapping().getJdbcType();
                        if (jdbcType instanceof AggregateJdbcType) {
                            Object[] subValues;
                            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)jdbcType;
                            subMappingType = aggregateJdbcType.getEmbeddableMappingType();
                            if (aggregateJdbcType.getJdbcTypeCode() == 2009 || aggregateJdbcType.getDefaultSqlTypeCode() == 2009) {
                                subValues = new Object[subMappingType.getJdbcValueCount()];
                                end = XmlHelper.fromString((EmbeddableMappingType)subMappingType, string, returnEmbeddable, options, subValues, i);
                            } else {
                                while (string.charAt(i) != '<') {
                                    ++i;
                                }
                                end = i;
                                subValues = aggregateJdbcType.extractJdbcValues(CharSequenceHelper.subSequence(string, start, end), options);
                            }
                            if (returnEmbeddable) {
                                StructAttributeValues attributeValues = StructHelper.getAttributeValues((EmbeddableMappingType)subMappingType, subValues, options);
                                values[selectableIndex] = StructHelper.instantiate((EmbeddableMappingType)subMappingType, attributeValues);
                            } else {
                                values[selectableIndex] = subValues;
                            }
                            assert (string.charAt(end) == '<');
                            assert (string.charAt(end + 1) == '/');
                            assert (string.regionMatches(end + 2, tagName, 0, tagName.length()));
                            i = end;
                        } else {
                            subMappingType = selectable.getJdbcMapping();
                            if (subMappingType instanceof BasicPluralType) {
                                BasicPluralType pluralType = (BasicPluralType)subMappingType;
                                BasicType elementType = pluralType.getElementType();
                                ArrayList<Object> arrayList = new ArrayList<Object>();
                                end = XmlHelper.fromArrayString(string, returnEmbeddable, options, i, arrayList, elementType.getMappedJavaType(), elementType.getJdbcJavaType(), elementType.getJdbcType());
                                values[selectableIndex] = selectable.getJdbcMapping().getJdbcJavaType().wrap(arrayList, options);
                                assert (string.charAt(end) == '<');
                                assert (string.charAt(end + 1) == '/');
                                assert (string.regionMatches(end + 2, tagName, 0, tagName.length()));
                                i = end;
                            } else {
                                throw new IllegalArgumentException(String.format("XML starts sub-object for a non-aggregate type at index %d. Selectable [%s] is of type [%s]", i, selectable.getSelectableName(), jdbcType.getClass().getName()));
                            }
                        }
                    }
                    i += tagName.length() + 2;
                    tagNameStart = -1;
                    contentStart = -1;
                    tagName = null;
                    continue block5;
                }
                case '>': {
                    if (tagName == null) {
                        assert (contentStart == -1);
                        assert (tagNameStart != -1);
                        tagName = string.substring(tagNameStart, i);
                        contentStart = i + 1;
                        continue block5;
                    }
                    assert (contentStart != -1);
                    continue block5;
                }
                case '/': {
                    if (tagName == null) {
                        tagNameStart = -1;
                        assert (string.charAt(++i) == '>');
                        continue block5;
                    }
                    assert (contentStart != -1);
                    continue block5;
                }
            }
        }
        throw new IllegalArgumentException("XML not properly formed: " + string.substring(start));
    }

    private static int fromArrayString(String string, boolean returnEmbeddable, WrapperOptions options, int start, ArrayList<Object> arrayList, JavaType<?> javaType, JavaType<?> jdbcJavaType, JdbcType jdbcType) throws SQLException {
        int tagNameStart = -1;
        int contentStart = -1;
        block5: for (int i = start; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    if (tagNameStart == -1) {
                        if (string.charAt(i + 1) == '/') {
                            assert (contentStart == -1);
                            return i;
                        }
                        tagNameStart = i + 1;
                        continue block5;
                    }
                    if (string.charAt(i + 1) == '/') {
                        if (!string.regionMatches(i + 2, "e>", 0, ROOT_TAG.length() + 1)) {
                            throw new IllegalArgumentException("XML not properly formed: " + string.substring(start));
                        }
                        arrayList.add(XmlHelper.fromString(javaType, jdbcJavaType, jdbcType, string, returnEmbeddable, options, contentStart, i));
                    } else if (jdbcType instanceof AggregateJdbcType) {
                        AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)jdbcType;
                        EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                        Object[] array = new Object[embeddableMappingType.getJdbcValueCount() + (embeddableMappingType.isPolymorphic() ? 1 : 0)];
                        int end = XmlHelper.fromString(embeddableMappingType, string, returnEmbeddable, options, array, contentStart);
                        if (returnEmbeddable) {
                            StructAttributeValues attributeValues = StructHelper.getAttributeValues(embeddableMappingType, array, options);
                            arrayList.add(StructHelper.instantiate(embeddableMappingType, attributeValues));
                        } else {
                            arrayList.add(array);
                        }
                        i = end;
                    } else {
                        throw new IllegalArgumentException("XML not properly formed: " + string.substring(start));
                    }
                    i += ROOT_TAG.length() + 2;
                    tagNameStart = -1;
                    contentStart = -1;
                    continue block5;
                }
                case '>': {
                    if (contentStart != -1) continue block5;
                    assert (tagNameStart != -1);
                    if (!ROOT_TAG.equals(string.substring(tagNameStart, i))) {
                        throw new IllegalArgumentException("XML not properly formed: " + string.substring(start));
                    }
                    contentStart = i + 1;
                    continue block5;
                }
                case '/': {
                    if (contentStart != -1) continue block5;
                    arrayList.add(null);
                    tagNameStart = -1;
                    assert (string.charAt(++i) == '>');
                    continue block5;
                }
            }
        }
        throw new IllegalArgumentException("XML not properly formed: " + string.substring(start));
    }

    public static String toString(EmbeddableMappingType embeddableMappingType, Object value, WrapperOptions options) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append(START_TAG);
        XmlHelper.toString(embeddableMappingType, embeddableMappingType.getValues(value), options, new XMLAppender(sb));
        sb.append(END_TAG);
        return sb.toString();
    }

    public static String arrayToString(EmbeddableMappingType elementMappingType, Object[] values, WrapperOptions options) {
        if (values.length == 0) {
            return EMPTY_COLLECTION_TAG;
        }
        StringBuilder sb = new StringBuilder();
        XMLAppender xmlAppender = new XMLAppender(sb);
        sb.append(COLLECTION_START_TAG);
        for (Object value : values) {
            if (value == null) {
                sb.append(NULL_TAG);
                continue;
            }
            sb.append(START_TAG);
            XmlHelper.toString(elementMappingType, elementMappingType.getValues(value), options, xmlAppender);
            sb.append(END_TAG);
        }
        sb.append(COLLECTION_END_TAG);
        return sb.toString();
    }

    public static String arrayToString(JavaType<?> elementJavaType, JdbcType elementJdbcType, Object[] values, WrapperOptions options) {
        if (values.length == 0) {
            return EMPTY_COLLECTION_TAG;
        }
        StringBuilder sb = new StringBuilder();
        XMLAppender xmlAppender = new XMLAppender(sb);
        sb.append(COLLECTION_START_TAG);
        for (Object value : values) {
            if (value == null) {
                sb.append(NULL_TAG);
                continue;
            }
            sb.append(START_TAG);
            XmlHelper.convertedBasicValueToString(xmlAppender, value, options, elementJavaType, elementJdbcType);
            sb.append(END_TAG);
        }
        sb.append(COLLECTION_END_TAG);
        return sb.toString();
    }

    private static void toString(EmbeddableMappingType embeddableMappingType, @Nullable Object[] attributeValues, WrapperOptions options, XMLAppender sb) {
        int attributeCount = embeddableMappingType.getNumberOfAttributeMappings();
        for (int i = 0; i < attributeCount; ++i) {
            Object attributeValue = attributeValues == null ? null : attributeValues[i];
            ValuedModelPart attributeMapping = StructHelper.getSubPart(embeddableMappingType, i);
            if (attributeMapping instanceof SelectableMapping) {
                SelectableMapping selectable = (SelectableMapping)((Object)attributeMapping);
                String tagName = selectable.getSelectableName();
                sb.append('<');
                sb.append(tagName);
                if (attributeValue == null) {
                    sb.append("/>");
                    continue;
                }
                sb.append('>');
                XmlHelper.convertedBasicValueToString(sb, selectable.getJdbcMapping().convertToRelationalValue(attributeValue), options, selectable.getJdbcMapping().getJdbcJavaType(), selectable.getJdbcMapping().getJdbcType());
                sb.append("</");
                sb.append(tagName);
                sb.append('>');
                continue;
            }
            if (attributeMapping instanceof EmbeddedAttributeMapping) {
                String tagName;
                EmbeddableMappingType mappingType = (EmbeddableMappingType)attributeMapping.getMappedType();
                SelectableMapping aggregateMapping = mappingType.getAggregateMapping();
                String string = tagName = aggregateMapping == null ? null : aggregateMapping.getSelectableName();
                if (tagName != null) {
                    sb.append('<');
                    sb.append(tagName);
                    if (attributeValue == null) {
                        sb.append("/>");
                        continue;
                    }
                    sb.append('>');
                }
                XmlHelper.toString(mappingType, attributeValue == null ? null : mappingType.getValues(attributeValue), options, sb);
                if (tagName == null) continue;
                sb.append("</");
                sb.append(tagName);
                sb.append('>');
                continue;
            }
            throw new UnsupportedOperationException("Support for attribute mapping type not yet implemented: " + attributeMapping.getClass().getName());
        }
    }

    private static void convertedBasicValueToString(XMLAppender appender, Object value, WrapperOptions options, JavaType<Object> jdbcJavaType, JdbcType jdbcType) {
        switch (jdbcType.getDefaultSqlTypeCode()) {
            case -6: 
            case 4: 
            case 5: {
                if (value instanceof Boolean) {
                    Boolean booleanValue = (Boolean)value;
                    appender.append(booleanValue != false ? (char)'1' : '0');
                    break;
                }
                if (value instanceof Enum) {
                    Enum enumValue = (Enum)value;
                    appender.appendSql(enumValue.ordinal());
                    break;
                }
            }
            case -7: 
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 3000: 
            case 3015: {
                jdbcJavaType.appendEncodedString(appender, jdbcJavaType.unwrap(value, jdbcJavaType.getJavaTypeClass(), options));
                break;
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if (value instanceof Boolean) {
                    Boolean booleanValue = (Boolean)value;
                    appender.append(booleanValue != false ? (char)'Y' : 'N');
                    break;
                }
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: 
            case 3005: 
            case 3006: 
            case 4001: 
            case 4002: 
            case 6000: 
            case 6001: {
                appender.startEscaping();
                jdbcJavaType.appendEncodedString(appender, jdbcJavaType.unwrap(value, jdbcJavaType.getJavaTypeClass(), options));
                appender.endEscaping();
                break;
            }
            case 91: {
                JdbcDateJavaType.INSTANCE.appendEncodedString((SqlAppender)appender, jdbcJavaType.unwrap(value, Date.class, options));
                break;
            }
            case 92: 
            case 2013: 
            case 3007: {
                JdbcTimeJavaType.INSTANCE.appendEncodedString((SqlAppender)appender, jdbcJavaType.unwrap(value, Time.class, options));
                break;
            }
            case 93: {
                JdbcTimestampJavaType.INSTANCE.appendEncodedString((SqlAppender)appender, jdbcJavaType.unwrap(value, Timestamp.class, options));
                break;
            }
            case 2014: 
            case 3003: {
                DateTimeFormatter.ISO_OFFSET_DATE_TIME.formatTo(jdbcJavaType.unwrap(value, OffsetDateTime.class, options), appender);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 3004: 
            case 4003: {
                appender.write(jdbcJavaType.unwrap(value, byte[].class, options));
                break;
            }
            case 2003: 
            case 3019: {
                int length = Array.getLength(value);
                if (length == 0) break;
                JavaType<Object> elementJavaType = ((BasicPluralJavaType)((Object)jdbcJavaType)).getElementJavaType();
                JdbcType elementJdbcType = ((ArrayJdbcType)jdbcType).getElementJdbcType();
                if (elementJdbcType instanceof AggregateJdbcType) {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)elementJdbcType;
                    EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                    for (int i = 0; i < length; ++i) {
                        Object arrayElement = Array.get(value, i);
                        if (arrayElement == null) {
                            appender.append(NULL_TAG);
                            continue;
                        }
                        Object[] arrayElementValues = embeddableMappingType.getValues(arrayElement);
                        appender.append(START_TAG);
                        XmlHelper.toString(embeddableMappingType, arrayElementValues, options, appender);
                        appender.append(END_TAG);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        Object arrayElement = Array.get(value, i);
                        if (arrayElement == null) {
                            appender.append(NULL_TAG);
                            continue;
                        }
                        appender.append(START_TAG);
                        XmlHelper.convertedBasicValueToString(appender, arrayElement, options, elementJavaType, elementJdbcType);
                        appender.append(END_TAG);
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported JdbcType nested in struct: " + String.valueOf(jdbcType));
            }
        }
    }

    private static int getSelectableMapping(EmbeddableMappingType embeddableMappingType, String name) {
        int selectableIndex = embeddableMappingType.getSelectableIndex(name);
        if (selectableIndex == -1) {
            throw new IllegalArgumentException(String.format("Could not find selectable [%s] in embeddable type [%s] for XML processing.", name, embeddableMappingType.getMappedJavaType().getJavaTypeClass().getName()));
        }
        return selectableIndex;
    }

    public static boolean isValidXmlName(String name) {
        if (name.isEmpty() || !XmlHelper.isValidXmlNameStart(name.charAt(0)) || name.regionMatches(true, 0, "xml", 0, 3)) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (XmlHelper.isValidXmlNameChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidXmlNameStart(char c) {
        return Character.isLetter(c) || c == '_' || c == ':';
    }

    public static boolean isValidXmlNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == ':' || c == '-' || c == '.';
    }

    public static CollectionTags determineCollectionTags(BasicPluralJavaType<?> pluralJavaType, SessionFactoryImplementor sessionFactory) {
        int itemNameStart;
        if (!sessionFactory.getSessionFactoryOptions().isXmlFormatMapperLegacyFormatEnabled()) {
            return DEFAULT;
        }
        JavaType javaType = (JavaType)((Object)pluralJavaType);
        String nullElementXml = sessionFactory.getSessionFactoryOptions().getXmlFormatMapper().toString(javaType.fromString("{null}"), javaType, sessionFactory.getWrapperOptions());
        int rootCloseTagPosition = nullElementXml.lastIndexOf(60);
        assert (nullElementXml.charAt(rootCloseTagPosition + 1) == '/');
        int rootNameStart = rootCloseTagPosition + 2;
        int rootCloseTagEnd = nullElementXml.indexOf(62, rootCloseTagPosition);
        String rootTag = nullElementXml.substring(rootNameStart, rootCloseTagEnd);
        int itemTagStart = nullElementXml.indexOf(60, nullElementXml.indexOf("<" + rootTag + ">") + rootTag.length() + 2);
        int itemNameEnd = itemNameStart = itemTagStart + 1;
        for (int i = itemNameStart + 1; i < nullElementXml.length(); ++i) {
            if (XmlHelper.isValidXmlNameChar(nullElementXml.charAt(i))) continue;
            itemNameEnd = i;
            break;
        }
        String elementNodeName = nullElementXml.substring(itemNameStart, itemNameEnd);
        return new CollectionTags(rootTag, elementNodeName);
    }

    private static class XMLAppender
    extends OutputStream
    implements SqlAppender {
        private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        private final StringBuilder sb;
        private boolean escape;

        public XMLAppender(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void appendSql(String fragment) {
            this.append(fragment);
        }

        @Override
        public void appendSql(char fragment) {
            this.append(fragment);
        }

        @Override
        public void appendSql(int value) {
            this.sb.append(value);
        }

        @Override
        public void appendSql(long value) {
            this.sb.append(value);
        }

        @Override
        public void appendSql(boolean value) {
            this.sb.append(value);
        }

        public String toString() {
            return this.sb.toString();
        }

        public void startEscaping() {
            assert (!this.escape);
            this.escape = true;
        }

        public void endEscaping() {
            assert (this.escape);
            this.escape = false;
        }

        @Override
        public XMLAppender append(char fragment) {
            if (this.escape) {
                this.appendEscaped(fragment);
            } else {
                this.sb.append(fragment);
            }
            return this;
        }

        @Override
        public XMLAppender append(CharSequence csq) {
            return this.append(csq, 0, csq.length());
        }

        @Override
        public XMLAppender append(CharSequence csq, int start, int end) {
            if (this.escape) {
                int len = end - start;
                this.sb.ensureCapacity(this.sb.length() + len);
                for (int i = start; i < end; ++i) {
                    this.appendEscaped(csq.charAt(i));
                }
            } else {
                this.sb.append(csq, start, end);
            }
            return this;
        }

        private void appendEscaped(char fragment) {
            switch (fragment) {
                case '<': {
                    this.sb.append("&lt;");
                    break;
                }
                case '&': {
                    this.sb.append("&amp;");
                    break;
                }
                default: {
                    this.sb.append(fragment);
                }
            }
        }

        @Override
        public void write(int v) {
            String hex = Integer.toHexString(v);
            this.sb.ensureCapacity(this.sb.length() + hex.length() + 1);
            if ((hex.length() & 1) == 1) {
                this.sb.append('0');
            }
            this.sb.append(hex);
        }

        @Override
        public void write(byte[] bytes) {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int off, int len) {
            this.sb.ensureCapacity(this.sb.length() + (len << 1));
            for (int i = 0; i < len; ++i) {
                int v = bytes[off + i] & 0xFF;
                this.sb.append(HEX_ARRAY[v >>> 4]);
                this.sb.append(HEX_ARRAY[v & 0xF]);
            }
        }
    }

    public record CollectionTags(String rootName, String elementName) {
    }
}

