/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror.rest.resources;

import jakarta.inject.Inject;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.apache.kafka.connect.mirror.SourceAndTarget;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.RestRequestTimeout;
import org.apache.kafka.connect.runtime.rest.resources.InternalClusterResource;

@Path(value="/{source}/{target}/connectors")
public class InternalMirrorResource
extends InternalClusterResource {
    @Context
    private UriInfo uriInfo;
    private final Map<SourceAndTarget, Herder> herders;

    @Inject
    public InternalMirrorResource(Map<SourceAndTarget, Herder> herders, RestClient restClient, RestRequestTimeout requestTimeout) {
        super(restClient, requestTimeout);
        this.herders = herders;
    }

    protected Herder herderForRequest() {
        String target;
        String source = this.pathParam("source");
        Herder result = this.herders.get(new SourceAndTarget(source, target = this.pathParam("target")));
        if (result == null) {
            throw new NotFoundException("No replication flow found for source '" + source + "' and target '" + target + "'");
        }
        return result;
    }

    private String pathParam(String name) {
        String result = (String)this.uriInfo.getPathParameters().getFirst((Object)name);
        if (result == null) {
            throw new NotFoundException("Could not parse " + name + " cluster from request path");
        }
        return result;
    }
}

