/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jsampler.CC;
import org.jsampler.MidiDeviceModel;
import org.jsampler.event.MidiDeviceEvent;
import org.jsampler.event.MidiDeviceListener;
import org.jsampler.task.Midi;
import org.linuxsampler.lscp.MidiInputDevice;
import org.linuxsampler.lscp.Parameter;

public class DefaultMidiDeviceModel
implements MidiDeviceModel {
    private MidiInputDevice midiDevice;
    private final Vector<MidiDeviceListener> listeners = new Vector();

    public DefaultMidiDeviceModel(MidiInputDevice midiInputDevice) {
        if (midiInputDevice == null) {
            throw new IllegalArgumentException("midiDevice must be non null");
        }
        this.midiDevice = midiInputDevice;
    }

    @Override
    public void addMidiDeviceListener(MidiDeviceListener midiDeviceListener) {
        this.listeners.add(midiDeviceListener);
    }

    @Override
    public void removeMidiDeviceListener(MidiDeviceListener midiDeviceListener) {
        this.listeners.remove(midiDeviceListener);
    }

    @Override
    public int getDeviceId() {
        return this.midiDevice.getDeviceId();
    }

    @Override
    public MidiInputDevice getDeviceInfo() {
        return this.midiDevice;
    }

    @Override
    public void setDeviceInfo(MidiInputDevice midiInputDevice) {
        this.midiDevice = midiInputDevice;
        this.fireSettingsChanged();
    }

    @Override
    public void setActive(boolean bl) {
        if (bl == this.getDeviceInfo().isActive()) {
            return;
        }
        this.midiDevice.setActive(bl);
        this.fireSettingsChanged();
    }

    @Override
    public boolean isActive() {
        return this.midiDevice.isActive();
    }

    @Override
    public void setBackendActive(boolean bl) {
        CC.getTaskQueue().add(new Midi.EnableDevice(this.getDeviceId(), bl));
    }

    @Override
    public void setBackendDeviceParameter(Parameter parameter) {
        CC.getTaskQueue().add(new Midi.SetDeviceParameter(this.getDeviceId(), parameter));
    }

    @Override
    public void setBackendPortCount(int n) {
        CC.getTaskQueue().add(new Midi.SetPortCount(this.getDeviceId(), n));
    }

    @Override
    public void setBackendPortParameter(int n, Parameter parameter) {
        CC.getTaskQueue().add(new Midi.SetPortParameter(this.getDeviceId(), n, parameter));
    }

    private void fireSettingsChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultMidiDeviceModel defaultMidiDeviceModel = DefaultMidiDeviceModel.this;
                DefaultMidiDeviceModel.this.fireSettingsChanged(new MidiDeviceEvent(defaultMidiDeviceModel, defaultMidiDeviceModel));
            }
        });
    }

    private void fireSettingsChanged(MidiDeviceEvent midiDeviceEvent) {
        CC.getSamplerModel().setModified(true);
        for (MidiDeviceListener midiDeviceListener : this.listeners) {
            midiDeviceListener.settingsChanged(midiDeviceEvent);
        }
    }
}

