/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.htmltools.HtmlToolsBundle;
import com.intellij.htmltools.codeInspection.htmlInspections.CreateRequiredSubElement;
import com.intellij.htmltools.codeInspection.htmlInspections.InspectionUtils;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlCustomElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class HtmlRequiredTitleElementInspection
extends HtmlLocalInspectionTool {
    private static final String TITLE = "title";
    private static final String HEAD = "head";

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            HtmlRequiredTitleElementInspection.$$$reportNull$$$0(0);
        }
        if (InjectedLanguageManager.getInstance((Project)holder.getProject()).isInjectedFragment(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                HtmlRequiredTitleElementInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            HtmlRequiredTitleElementInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlRequiredTitleElementInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            HtmlRequiredTitleElementInspection.$$$reportNull$$$0(4);
        }
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            return;
        }
        if (!tag.getName().equalsIgnoreCase(HEAD)) {
            return;
        }
        if (XmlCustomElementDescriptor.isCustomElement((XmlTag)tag)) {
            return;
        }
        XmlTag[] subTags = tag.getSubTags();
        long count = Arrays.stream(subTags).filter(element -> element.getName().equalsIgnoreCase(TITLE)).count();
        if (count > 0L) {
            return;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        fixes.add((LocalQuickFix)new CreateRequiredSubElement(tag.getOriginalElement(), TITLE));
        InspectionUtils.RegisterProblem(tag, holder, fixes, HtmlToolsBundle.message("html.inspections.check.required.title.element", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredTitleElementInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredTitleElementInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

