/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.concurrency.JobScheduler;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.impl.GenericNotifierImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.io.PathKt;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.awt.Component;
import java.awt.Point;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootsToWorkingCopies;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfigurable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationData;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifierKt;
import org.jetbrains.idea.svn.auth.SvnInteractiveAuthenticationProvider;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.InfoClient;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 .2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0002-.B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0002H\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0002H\u0014J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0002H\u0014J\u0010\u0010$\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*J\u0015\u0010+\u001a\u00070\u001e\u00a2\u0006\u0002\b,2\u0006\u0010\u001c\u001a\u00020\u0002H\u0014RN\u0010\t\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f\u0018\u00010\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0002\b\u0003 \u000b*\b\u0012\u0002\b\u0003\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lorg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier;", "Lcom/intellij/openapi/vcs/impl/GenericNotifierImpl;", "Lorg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier$AuthenticationRequest;", "Lorg/jetbrains/idea/svn/api/Url;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myCopiesPassiveResults", "", "kotlin.jvm.PlatformType", "", "", "myTimer", "Ljava/util/concurrent/ScheduledFuture;", "myVerificationInProgress", "vcs", "Lorg/jetbrains/idea/svn/SvnVcs;", "getVcs", "()Lorg/jetbrains/idea/svn/SvnVcs;", "rootsToWorkingCopies", "Lorg/jetbrains/idea/svn/RootsToWorkingCopies;", "getRootsToWorkingCopies", "()Lorg/jetbrains/idea/svn/RootsToWorkingCopies;", "dispose", "", "ask", "obj", "description", "", "showAlreadyChecking", "onStateChangedToSuccess", "ensureNotify", "onFirstNotification", "getKey", "getWcUrl", "isAuthenticatedFor", "Lcom/intellij/util/ThreeState;", "vf", "Lcom/intellij/openapi/vfs/VirtualFile;", "factory", "Lorg/jetbrains/idea/svn/api/ClientFactory;", "getNotificationContent", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "AuthenticationRequest", "Companion", "intellij.vcs.svn"})
@SourceDebugExtension(value={"SMAP\nSvnAuthenticationNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvnAuthenticationNotifier.kt\norg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,376:1\n1869#2,2:377\n*S KotlinDebug\n*F\n+ 1 SvnAuthenticationNotifier.kt\norg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier\n*L\n151#1:377,2\n*E\n"})
public final class SvnAuthenticationNotifier
extends GenericNotifierImpl<AuthenticationRequest, Url>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Map<Url, Boolean> myCopiesPassiveResults;
    private final ScheduledFuture<?> myTimer;
    private volatile boolean myVerificationInProgress;

    public SvnAuthenticationNotifier(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = SvnBundle.message("notification.title.not.logged.into.subversion", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(project, "Subversion", string, NotificationType.ERROR);
        this.myCopiesPassiveResults = Collections.synchronizedMap(new LinkedHashMap());
        this.myTimer = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> SvnAuthenticationNotifier.myTimer$lambda$0(this), 10L, 600L, TimeUnit.SECONDS);
    }

    private final SvnVcs getVcs() {
        SvnVcs svnVcs = SvnVcs.getInstance(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)svnVcs), (String)"getInstance(...)");
        return svnVcs;
    }

    private final RootsToWorkingCopies getRootsToWorkingCopies() {
        return RootsToWorkingCopies.Companion.getInstance(this.myProject);
    }

    public void dispose() {
        this.myTimer.cancel(false);
    }

    protected boolean ask(@NotNull AuthenticationRequest obj, @Nullable String description) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (this.myVerificationInProgress) {
            this.showAlreadyChecking();
            return false;
        }
        this.myVerificationInProgress = true;
        Ref resultRef = new Ref();
        Function0 checker = () -> SvnAuthenticationNotifier.ask$lambda$0(obj, resultRef, this);
        if (ApplicationManager.getApplication().isReadAccessAllowed() || !ProgressManager.getInstance().hasProgressIndicator()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> SvnAuthenticationNotifier.ask$lambda$1(checker));
            bl = false;
        } else {
            checker.invoke();
            Object object = resultRef.get();
            Intrinsics.checkNotNull((Object)object);
            bl = (Boolean)object;
        }
        return bl;
    }

    private final void showAlreadyChecking() {
        IdeFrame ideFrame = WindowManagerEx.getInstanceEx().findFrameFor(this.myProject);
        if (ideFrame == null) {
            return;
        }
        IdeFrame frameFor = ideFrame;
        JComponent component = frameFor.getComponent();
        Point point = component.getMousePosition();
        if (point == null) {
            point = new Point((int)((double)component.getWidth() * 0.7), 0);
        }
        Point point2 = point;
        SwingUtilities.convertPointToScreen(point2, component);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(SvnBundle.message("popup.content.already.checking", new Object[0]), MessageType.WARNING, null).createBalloon().show(new RelativePoint(point2), Balloon.Position.below);
    }

    private final void onStateChangedToSuccess(AuthenticationRequest obj) {
        Map<Url, Boolean> map = this.myCopiesPassiveResults;
        Intrinsics.checkNotNullExpressionValue(map, (String)"myCopiesPassiveResults");
        Map<Url, Boolean> map2 = map;
        Url url = this.getKey(obj);
        Boolean bl = true;
        map2.put(url, bl);
        this.getVcs().invokeRefreshSvnRoots();
        List outdatedRequests = new ArrayList();
        for (Object e : this.getAllCurrentKeys()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Url key = (Url)e;
            Url commonAncestor = key.commonAncestorWith(obj.getUrl());
            if (commonAncestor == null || StringUtil.isEmptyOrSpaces((String)commonAncestor.getHost()) || StringUtil.isEmptyOrSpaces((String)commonAncestor.getPath())) continue;
            outdatedRequests.add(key);
        }
        SvnAuthenticationNotifierKt.access$getLOG$p().debug("on state changed ");
        ApplicationManager.getApplication().invokeLater(() -> SvnAuthenticationNotifier.onStateChangedToSuccess$lambda$0(outdatedRequests, this), ModalityState.nonModal());
    }

    public boolean ensureNotify(@NotNull AuthenticationRequest obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        this.myCopiesPassiveResults.remove(this.getKey(obj));
        return super.ensureNotify((Object)obj);
    }

    protected boolean onFirstNotification(@NotNull AuthenticationRequest obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return ProgressManager.getInstance().hasProgressIndicator() && this.ask(obj, null);
    }

    @NotNull
    protected Url getKey(@NotNull AuthenticationRequest obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Url url = obj.getWcUrl();
        Intrinsics.checkNotNull((Object)url);
        return url;
    }

    @Nullable
    public final Url getWcUrl(@NotNull AuthenticationRequest obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (obj.isOutsideCopies()) {
            return null;
        }
        if (obj.getWcUrl() != null) {
            return obj.getWcUrl();
        }
        WorkingCopy copy = this.getRootsToWorkingCopies().getMatchingCopy(obj.getUrl());
        if (copy != null) {
            obj.setOutsideCopies(false);
            obj.setWcUrl(copy.getUrl());
        } else {
            obj.setOutsideCopies(true);
        }
        WorkingCopy workingCopy = copy;
        return workingCopy != null ? workingCopy.getUrl() : null;
    }

    @NotNull
    public final ThreeState isAuthenticatedFor(@NotNull VirtualFile vf, @Nullable ClientFactory factory) {
        Intrinsics.checkNotNullParameter((Object)vf, (String)"vf");
        WorkingCopy workingCopy = this.getRootsToWorkingCopies().getWcRoot(vf);
        if (workingCopy == null) {
            return ThreeState.UNSURE;
        }
        WorkingCopy wcCopy = workingCopy;
        boolean haveCancellation = this.getStateFor(wcCopy.getUrl());
        if (haveCancellation) {
            return ThreeState.NO;
        }
        Boolean keptResult = this.myCopiesPassiveResults.get(wcCopy.getUrl());
        if (Intrinsics.areEqual((Object)true, (Object)keptResult)) {
            return ThreeState.YES;
        }
        if (Intrinsics.areEqual((Object)false, (Object)keptResult)) {
            return ThreeState.NO;
        }
        ClientFactory clientFactory = factory;
        boolean calculatedResult = clientFactory == null ? Companion.passiveValidation(this.getVcs(), wcCopy.getUrl()) : SvnAuthenticationNotifier.Companion.passiveValidation(clientFactory, wcCopy.getUrl());
        Map<Url, Boolean> map = this.myCopiesPassiveResults;
        Intrinsics.checkNotNullExpressionValue(map, (String)"myCopiesPassiveResults");
        Map<Url, Boolean> map2 = map;
        Url url = wcCopy.getUrl();
        Boolean bl = calculatedResult;
        map2.put(url, bl);
        return ThreeState.Companion.fromBoolean(calculatedResult);
    }

    @NotNull
    protected String getNotificationContent(@NotNull AuthenticationRequest obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        String string = HtmlChunk.link((String)"", (String)SvnBundle.message("notification.action.click.to.fix", new Object[0])).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String action = string;
        Object[] objectArray = new Object[]{obj.getRealm(), obj.getUrl().toDecodedString()};
        String string2 = SvnBundle.message("notification.content.not.logged.into.subversion", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String content = string2;
        return action + " " + content;
    }

    private static final void myTimer$lambda$0(SvnAuthenticationNotifier this$0) {
        this$0.myCopiesPassiveResults.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit ask$lambda$0(AuthenticationRequest $obj, Ref $resultRef, SvnAuthenticationNotifier this$0) {
        try {
            boolean result = Companion.interactiveValidation($obj.getMyProject(), $obj.getUrl(), $obj.getRealm(), $obj.getKind());
            SvnAuthenticationNotifierKt.access$getLOG$p().debug("ask result for: " + $obj.getUrl() + " is: " + result);
            $resultRef.set((Object)result);
            if (result) {
                this$0.onStateChangedToSuccess($obj);
            }
        }
        finally {
            this$0.myVerificationInProgress = false;
        }
        return Unit.INSTANCE;
    }

    private static final void ask$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void onStateChangedToSuccess$lambda$0(List $outdatedRequests, SvnAuthenticationNotifier this$0) {
        Iterable $this$forEach$iv = $outdatedRequests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Url it = (Url)element$iv;
            boolean bl = false;
            this$0.removeLazyNotificationByKey(it);
        }
    }

    @JvmStatic
    @NotNull
    public static final SvnAuthenticationNotifier getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final boolean passiveValidation(@NotNull SvnVcs vcs, @NotNull Url url) {
        return Companion.passiveValidation(vcs, url);
    }

    @JvmStatic
    public static final void clearAuthenticationCache(@NotNull Project project, @Nullable Component component, @Nullable String configDirPath) {
        Companion.clearAuthenticationCache(project, component, configDirPath);
    }

    @JvmStatic
    public static final void clearAuthenticationDirectory(@NotNull SvnConfiguration configuration) {
        Companion.clearAuthenticationDirectory(configuration);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier$AuthenticationRequest;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "kind", "", "url", "Lorg/jetbrains/idea/svn/api/Url;", "realm", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lorg/jetbrains/idea/svn/api/Url;Ljava/lang/String;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getKind", "()Ljava/lang/String;", "getUrl", "()Lorg/jetbrains/idea/svn/api/Url;", "getRealm", "wcUrl", "getWcUrl", "setWcUrl", "(Lorg/jetbrains/idea/svn/api/Url;)V", "isOutsideCopies", "", "()Z", "setOutsideCopies", "(Z)V", "intellij.vcs.svn"})
    public static final class AuthenticationRequest {
        @NotNull
        private final Project myProject;
        @NotNull
        private final String kind;
        @NotNull
        private final Url url;
        @NotNull
        private final String realm;
        @Nullable
        private Url wcUrl;
        private boolean isOutsideCopies;

        public AuthenticationRequest(@NotNull Project myProject, @NotNull String kind, @NotNull Url url, @NotNull String realm) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
            this.myProject = myProject;
            this.kind = kind;
            this.url = url;
            this.realm = realm;
        }

        @NotNull
        public final Project getMyProject() {
            return this.myProject;
        }

        @NotNull
        public final String getKind() {
            return this.kind;
        }

        @NotNull
        public final Url getUrl() {
            return this.url;
        }

        @NotNull
        public final String getRealm() {
            return this.realm;
        }

        @Nullable
        public final Url getWcUrl() {
            return this.wcUrl;
        }

        public final void setWcUrl(@Nullable Url url) {
            this.wcUrl = url;
        }

        public final boolean isOutsideCopies() {
            return this.isOutsideCopies;
        }

        public final void setOutsideCopies(boolean bl) {
            this.isOutsideCopies = bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0007J&\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012JL\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\tH\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J$\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010\u0012H\u0007J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u00a8\u0006$"}, d2={"Lorg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier;", "project", "Lcom/intellij/openapi/project/Project;", "passiveValidation", "", "factory", "Lorg/jetbrains/idea/svn/api/ClientFactory;", "url", "Lorg/jetbrains/idea/svn/api/Url;", "vcs", "Lorg/jetbrains/idea/svn/SvnVcs;", "interactiveValidation", "realm", "", "kind", "validationImpl", "configuration", "Lorg/jetbrains/idea/svn/SvnConfiguration;", "manager", "Lorg/jetbrains/idea/svn/auth/SvnAuthenticationManager;", "checkWrite", "interactive", "showAuthenticationFailedWithHotFixes", "", "e", "Lorg/jetbrains/idea/svn/commandLine/SvnBindException;", "clearAuthenticationCache", "component", "Ljava/awt/Component;", "configDirPath", "clearAuthenticationDirectory", "intellij.vcs.svn"})
    @SourceDebugExtension(value={"SMAP\nSvnAuthenticationNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvnAuthenticationNotifier.kt\norg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 path.kt\ncom/intellij/util/io/PathKt\n*L\n1#1,376:1\n30#2,2:377\n169#3,6:379\n*S KotlinDebug\n*F\n+ 1 SvnAuthenticationNotifier.kt\norg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier$Companion\n*L\n211#1:377,2\n358#1:379,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SvnAuthenticationNotifier getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SvnAuthenticationNotifier> serviceClass$iv = SvnAuthenticationNotifier.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SvnAuthenticationNotifier)((Object)object);
        }

        private final boolean passiveValidation(ClientFactory factory, Url url) {
            boolean bl;
            try {
                bl = factory.create(InfoClient.class, false).doInfo(Target.Companion.on$default(Target.Companion, url, null, 2, null), Revision.UNDEFINED) != null;
            }
            catch (SvnBindException ignore) {
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        public final boolean passiveValidation(@NotNull SvnVcs vcs, @NotNull Url url) {
            Intrinsics.checkNotNullParameter((Object)((Object)vcs), (String)"vcs");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            SvnConfiguration svnConfiguration = vcs.getSvnConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)svnConfiguration, (String)"getSvnConfiguration(...)");
            SvnConfiguration configuration = svnConfiguration;
            SvnAuthenticationManager passiveManager = configuration.getPassiveAuthenticationManager(vcs);
            Project project = vcs.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Intrinsics.checkNotNull((Object)passiveManager);
            return this.validationImpl(project, url, configuration, passiveManager, false, null, null, false);
        }

        public final boolean interactiveValidation(@NotNull Project project, @NotNull Url url, @NotNull String realm, @NotNull String kind) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            SvnConfiguration configuration = SvnConfiguration.getInstance(project);
            SvnAuthenticationManager passiveManager = configuration.getInteractiveManager(SvnVcs.getInstance(project));
            Intrinsics.checkNotNull((Object)configuration);
            Intrinsics.checkNotNull((Object)passiveManager);
            return this.validationImpl(project, url, configuration, passiveManager, true, realm, kind, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean validationImpl(Project project, Url url, SvnConfiguration configuration, SvnAuthenticationManager manager, boolean checkWrite, String realm, String kind, boolean interactive) {
            InetSocketAddress address;
            Proxy proxyToRelease = null;
            if (!interactive && configuration.isUseDefaultProxy()) {
                HttpConfigurable instance = HttpConfigurable.getInstance();
                if (instance.USE_HTTP_PROXY && instance.PROXY_AUTHENTICATION && (StringUtil.isEmptyOrSpaces((String)instance.getProxyLogin()) || StringUtil.isEmptyOrSpaces((String)instance.getPlainProxyPassword()))) {
                    return false;
                }
                if (instance.USE_PROXY_PAC) {
                    List list;
                    try {
                        list = CommonProxy.getInstance().select(new URI(url.toString()));
                    }
                    catch (URISyntaxException e) {
                        SvnAuthenticationNotifierKt.access$getLOG$p().info("wrong URL: " + url);
                        return false;
                    }
                    List list2 = list;
                    Intrinsics.checkNotNull((Object)list2);
                    List select = list2;
                    for (Proxy proxy : select) {
                        if (!HttpConfigurable.isRealProxy((Proxy)proxy) || Proxy.Type.HTTP != proxy.type()) continue;
                        SocketAddress socketAddress = proxy.address();
                        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
                        address = (InetSocketAddress)socketAddress;
                        PasswordAuthentication password = HttpConfigurable.getInstance().getGenericPassword(address.getHostString(), address.getPort());
                        if (password != null) continue;
                        CommonProxy.getInstance().noAuthentication("http", address.getHostString(), address.getPort());
                        proxyToRelease = proxy;
                    }
                }
            }
            SvnInteractiveAuthenticationProvider.clearCallState();
            Target target = Target.Companion.on$default(Target.Companion, url, null, 2, null);
            try {
                SvnVcs.getInstance(project).getFactory(target).create(InfoClient.class, interactive).doInfo(target, Revision.HEAD);
            }
            catch (ProcessCanceledException e) {
                boolean proxy = false;
                return proxy;
            }
            catch (SvnBindException e) {
                if (SvnUtil.isAuthError(e)) {
                    SvnAuthenticationNotifierKt.access$getLOG$p().debug((Throwable)((Object)e));
                    boolean proxy = false;
                    return proxy;
                }
                SvnAuthenticationNotifierKt.access$getLOG$p().info("some other exc", (Throwable)((Object)e));
                if (interactive) {
                    this.showAuthenticationFailedWithHotFixes(project, configuration, e);
                }
                boolean proxy = false;
                return proxy;
            }
            finally {
                if (!interactive && configuration.isUseDefaultProxy() && proxyToRelease != null) {
                    SocketAddress socketAddress = proxyToRelease.address();
                    Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
                    address = (InetSocketAddress)socketAddress;
                    CommonProxy.getInstance().noAuthentication("http", address.getHostString(), address.getPort());
                }
            }
            if (!checkWrite) {
                return true;
            }
            if (SvnInteractiveAuthenticationProvider.wasCalled() && SvnInteractiveAuthenticationProvider.wasCancelled()) {
                return false;
            }
            if (SvnInteractiveAuthenticationProvider.wasCalled()) {
                return true;
            }
            SvnVcs svnVcs = SvnVcs.getInstance(project);
            SvnInteractiveAuthenticationProvider provider = new SvnInteractiveAuthenticationProvider(svnVcs, manager);
            AuthenticationData svnAuthentication = provider.requestClientAuthentication(kind, url, realm, true);
            if (svnAuthentication != null) {
                String string = kind;
                Intrinsics.checkNotNull((Object)string);
                String string2 = realm;
                Intrinsics.checkNotNull((Object)string2);
                configuration.acknowledge(string, string2, svnAuthentication);
                configuration.getAuthenticationManager(svnVcs).acknowledgeAuthentication(kind, url, realm, svnAuthentication);
                return true;
            }
            return false;
        }

        private final void showAuthenticationFailedWithHotFixes(Project project, SvnConfiguration configuration, SvnBindException e) {
            ApplicationManager.getApplication().invokeLater(() -> Companion.showAuthenticationFailedWithHotFixes$lambda$0(project, e, configuration), ModalityState.nonModal(), project.getDisposed());
        }

        @JvmStatic
        public final void clearAuthenticationCache(@NotNull Project project, @Nullable Component component, @Nullable String configDirPath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (configDirPath != null) {
                int result;
                int n = result = component == null ? Messages.showYesNoDialog((Project)project, (String)SvnBundle.message("confirmation.text.delete.stored.authentication.information", new Object[0]), (String)SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0]), (Icon)Messages.getWarningIcon()) : Messages.showYesNoDialog((Component)component, (String)SvnBundle.message("confirmation.text.delete.stored.authentication.information", new Object[0]), (String)SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0]), (Icon)Messages.getWarningIcon());
                if (result == 0) {
                    SvnConfiguration.RUNTIME_AUTH_CACHE.clear();
                    SvnConfiguration svnConfiguration = SvnConfiguration.getInstance(project);
                    Intrinsics.checkNotNullExpressionValue((Object)svnConfiguration, (String)"getInstance(...)");
                    this.clearAuthenticationDirectory(svnConfiguration);
                }
            }
        }

        @JvmStatic
        public final void clearAuthenticationDirectory(@NotNull SvnConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            String[] stringArray = new String[]{"auth"};
            Path authDir = Paths.get(configuration.getConfigurationDirectory(), stringArray);
            Intrinsics.checkNotNull((Object)authDir);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(authDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Function0 process = () -> Companion.clearAuthenticationDirectory$lambda$0(authDir);
                if (ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread()) {
                    process.invoke();
                } else {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Companion.clearAuthenticationDirectory$lambda$1(process), SvnBundle.message("progress.title.clear.authentication.cache", new Object[0]), false, configuration.getProject());
                }
            }
        }

        private static final void showAuthenticationFailedWithHotFixes$lambda$0(Project $project, SvnBindException $e, SvnConfiguration $configuration) {
            Object[] objectArray = new Object[]{$e.getMessage()};
            String string = SvnBundle.message("notification.content.authentication.failed", objectArray);
            objectArray = new NamedRunnable[2];
            String string2 = SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0]);
            objectArray[0] = new NamedRunnable($project, $configuration, string2){
                final /* synthetic */ Project $project;
                final /* synthetic */ SvnConfiguration $configuration;
                {
                    this.$project = $project;
                    this.$configuration = $configuration;
                    super($super_call_param$1);
                }

                public void run() {
                    SvnAuthenticationNotifier.Companion.clearAuthenticationCache(this.$project, null, this.$configuration.getConfigurationDirectory());
                }
            };
            string2 = SvnBundle.message("action.title.select.configuration.directory", new Object[0]);
            objectArray[1] = new NamedRunnable($configuration, $project, string2){
                final /* synthetic */ SvnConfiguration $configuration;
                final /* synthetic */ Project $project;
                {
                    this.$configuration = $configuration;
                    this.$project = $project;
                    super($super_call_param$1);
                }

                public void run() {
                    SvnConfigurable.selectConfigurationDirectory(this.$configuration.getConfigurationDirectory(), (Consumer<? super String>)((Consumer)arg_0 -> showAuthenticationFailedWithHotFixes.1.2.run$lambda$1(arg_0 -> showAuthenticationFailedWithHotFixes.1.2.run$lambda$0(this.$configuration, arg_0), arg_0)), this.$project, null);
                }

                private static final Unit run$lambda$0(SvnConfiguration $configuration, String it) {
                    $configuration.setConfigurationDirParameters(false, it);
                    return Unit.INSTANCE;
                }

                private static final void run$lambda$1(Function1 $tmp0, Object p0) {
                    $tmp0.invoke(p0);
                }
            };
            VcsBalloonProblemNotifier.showOverChangesView((Project)$project, (String)string, (MessageType)MessageType.ERROR, (NamedRunnable[])objectArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private static final Unit clearAuthenticationDirectory$lambda$0(Path $authDir) {
            Object[] objectArray;
            ProgressIndicator ind;
            ProgressIndicator progressIndicator = ind = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setIndeterminate(true);
            }
            ProgressIndicator progressIndicator2 = ind;
            if (progressIndicator2 != null) {
                objectArray = new Object[]{$authDir};
                progressIndicator2.setText(SvnBundle.message("progress.text.clearing.stored.credentials", objectArray));
            }
            Intrinsics.checkNotNull((Object)$authDir);
            objectArray = $authDir;
            Function1 filter$iv = Companion::clearAuthenticationDirectory$lambda$0$0;
            boolean $i$f$directoryStreamIfExists = false;
            try {
                Unit unit;
                void $this$directoryStreamIfExists$iv;
                Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, PathKt.makeFilter((Function1)filter$iv));
                Throwable throwable = null;
                try {
                    DirectoryStream it = (DirectoryStream)closeable;
                    boolean bl = false;
                    Iterator iterator = it.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        Path dir = (Path)iterator2.next();
                        ProgressIndicator progressIndicator3 = ind;
                        if (progressIndicator3 != null) {
                            Object[] objectArray2 = new Object[]{dir};
                            progressIndicator3.setText(SvnBundle.message("progress.text.deleting", objectArray2));
                        }
                        Intrinsics.checkNotNull((Object)dir);
                        PathKt.delete$default((Path)dir, (boolean)false, (int)1, null);
                    }
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                closeable = unit;
            }
            catch (NoSuchFileException noSuchFileException) {
                Object var5_6 = null;
            }
            return Unit.INSTANCE;
        }

        private static final boolean clearAuthenticationDirectory$lambda$0$0(Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return SvnAuthenticationNotifierKt.access$getAUTH_KINDS$p().contains(((Object)it.getFileName()).toString());
        }

        private static final void clearAuthenticationDirectory$lambda$1(Function0 $tmp0) {
            $tmp0.invoke();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

