# QuaGroup, chapter 1
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("quagroup01.tst");

# doc/quagroup.xml:69-114
gap> # We define a root system by giving its type:
gap> R:= RootSystem( "B", 2 );
<root system of type B2>
gap> # Corresponding to the root system we define a quantized enveloping algebra:
gap> U:= QuantizedUEA( R );
QuantumUEA( <root system of type B2>, Qpar = q )
gap> # It is generated by the generators of a so-called PBW-type basis:
gap> GeneratorsOfAlgebra( U );
[ F1, F2, F3, F4, K1, (-q^2+q^-2)*[ K1 ; 1 ]+K1, K2, (-q+q^-1)*[ K2 ; 1 ]+K2, 
  E1, E2, E3, E4 ]
gap> # We can construct highest-weight modules:
gap> V:= HighestWeightModule( U, [1,1] );
<16-dimensional left-module over QuantumUEA( <root system of type B
2>, Qpar = q )>
gap> # For modules of small dimension we can compute the corresponding
gap> # R-matrix:
gap> U:= QuantizedUEA( RootSystem("A",2) );;
gap> V:= HighestWeightModule( U, [1,0] );;
gap> RMatrix( V );
[ [ q^2, 0, 0, 0, 0, 0, 0, 0, 0 ], [ 0, q^3, 0, -q^4+q^2, 0, 0, 0, 0, 0 ], 
  [ 0, 0, q^3, 0, 0, 0, -q^4+q^2, 0, 0 ], [ 0, 0, 0, q^3, 0, 0, 0, 0, 0 ], 
  [ 0, 0, 0, 0, q^2, 0, 0, 0, 0 ], [ 0, 0, 0, 0, 0, q^3, 0, -q^4+q^2, 0 ], 
  [ 0, 0, 0, 0, 0, 0, q^3, 0, 0 ], [ 0, 0, 0, 0, 0, 0, 0, q^3, 0 ], 
  [ 0, 0, 0, 0, 0, 0, 0, 0, q^2 ] ]
gap> # We can compute elements of the canonical basis of the "negative" part
gap> # of a quantized enveloping algebra:
gap> U:= QuantizedUEA( RootSystem("F",4) );;
gap> B:= CanonicalBasis( U );
<canonical basis of QuantumUEA( <root system of type F4>, Qpar = q ) >
gap> p:= PBWElements( B, [0,1,2,1] ); 
[ F3*F9^(2)*F24, F3*F9*F23+(q^2)*F3*F9^(2)*F24, 
  (q^3+q)*F3*F9^(2)*F24+F7*F9*F24, (q^2)*F3*F9*F23+(q^4+q^2)*F3*F9^(2)*F
    24+(q)*F7*F9*F24+F7*F23, (q^4)*F3*F9^(2)*F24+(q)*F7*F9*F24+F8*F24, 
  (q^4)*F3*F9*F23+(q^6)*F3*F9^(2)*F24+(q^3)*F7*F9*F24+(q^2)*F7*F23+(q^2)*F8*F
    24+F9*F21, (q^3+q)*F3*F9*F23+(q^5+q^3)*F3*F9^(2)*F24+(q^2)*F7*F9*F24+(q)*F
    7*F23+(q)*F9*F21+F16 ]
gap> # We can construct (anti-) automorphisms of quantized enveloping
gap> # algebras:
gap> t:= AntiAutomorphismTau( U );
<anti-automorphism of QuantumUEA( <root system of type F4>, Qpar = q )>
gap> Image( t, p[1] );
(q^4)*F3*F9*F23+(q^6)*F3*F9^(2)*F24+(q^3)*F7*F9*F24+(q^2)*F7*F23+(q^2)*F8*F
24+F9*F21
gap> # (This is the sixth element of p.)

#
gap> STOP_TEST("quagroup01.tst", 1);
