/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Date;
import java.util.Locale;
import org.jkiss.utils.Base64;

public class GsonUtils {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("MMM d, yyyy[, h:mm:ss a]").localizedBy(Locale.ENGLISH).withZone(ZoneId.of("UTC"));

    public static GsonBuilder gsonBuilder() {
        return new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter()).registerTypeHierarchyAdapter(Date.class, (Object)new DateTypeAdapter()).serializeNulls().enableComplexMapKeySerialization().setPrettyPrinting();
    }

    public static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Base64.decode(json.getAsString());
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Base64.encode(src));
        }
    }

    public static class DateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        public synchronized JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(LocalDateTime.ofInstant(date.toInstant(), ZoneId.of("UTC")).format(DATE_TIME_FORMATTER));
        }

        public synchronized Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            TemporalAccessor accessor = DATE_TIME_FORMATTER.parse(jsonElement.getAsString());
            LocalDate localDate = accessor.query(TemporalQueries.localDate());
            LocalTime localTime = accessor.query(TemporalQueries.localTime());
            if (localTime != null) {
                return Date.from(LocalDateTime.of(localDate, localTime).toInstant(ZoneOffset.UTC));
            }
            return Date.from(localDate.atStartOfDay().toInstant(ZoneOffset.UTC));
        }
    }

    public static final class InstantIsoAdapter
    implements JsonDeserializer<Instant>,
    JsonSerializer<Instant> {
        public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            if (json == null || json.isJsonNull()) {
                return null;
            }
            return Instant.parse(json.getAsString());
        }

        public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
            return src == null ? JsonNull.INSTANCE : new JsonPrimitive(src.toString());
        }
    }
}

