/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import java.util.List;
import org.apache.uniffle.common.config.ConfigOption;
import org.apache.uniffle.common.config.ConfigOptions;
import org.apache.uniffle.common.config.ConfigUtils;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.coordinator.ApplicationManager;
import org.apache.uniffle.coordinator.conf.ClientConfParser;
import org.apache.uniffle.coordinator.strategy.assignment.AbstractAssignmentStrategy;
import org.apache.uniffle.coordinator.strategy.assignment.AssignmentStrategyFactory;

public class CoordinatorConf
extends RssBaseConf {
    public static final ConfigOption<String> COORDINATOR_CLIENT_CONF_APPLY_STRATEGY = ConfigOptions.key((String)"rss.coordinator.client.confApplyStrategy").stringType().defaultValue((Object)"org.apache.uniffle.coordinator.conf.BypassRssClientConfApplyStrategy").withDescription("The client conf apply strategy which is used on fetchClientConf rpc interface.");
    public static final ConfigOption<String> COORDINATOR_EXCLUDE_NODES_FILE_PATH = ConfigOptions.key((String)"rss.coordinator.exclude.nodes.file.path").stringType().noDefaultValue().withDescription("The path of configuration file which have exclude nodes");
    public static final ConfigOption<Long> COORDINATOR_EXCLUDE_NODES_CHECK_INTERVAL = ConfigOptions.key((String)"rss.coordinator.exclude.nodes.check.interval.ms").longType().defaultValue((Object)60000L).withDescription("Update interval for exclude nodes");
    public static final ConfigOption<String> COORDINATOR_NODE_TAGS_FILE_PATH = ConfigOptions.key((String)"rss.coordinator.node.tags.filePath").stringType().noDefaultValue().withDescription("The path of configuration file which have tags for nodes");
    public static final ConfigOption<Long> COORDINATOR_NODE_TAGS_CHECK_INTERVAL = ConfigOptions.key((String)"rss.coordinator.node.tags.checkIntervalMs").longType().defaultValue((Object)60000L).withDescription("Update interval for node tags");
    public static final ConfigOption<Long> COORDINATOR_HEARTBEAT_TIMEOUT = ConfigOptions.key((String)"rss.coordinator.server.heartbeat.timeout").longType().defaultValue((Object)30000L).withDescription("timeout if can't get heartbeat from shuffle server");
    public static final ConfigOption<Long> COORDINATOR_NODES_PERIODIC_OUTPUT_INTERVAL_TIMES = ConfigOptions.key((String)"rss.coordinator.server.periodic.output.interval.times").longType().checkValue(ConfigUtils.POSITIVE_LONG_VALIDATOR, "output server list interval times must be positive").defaultValue((Object)30L).withDescription("The periodic interval times of output alive nodes. The interval sec can be calculated by (" + COORDINATOR_HEARTBEAT_TIMEOUT.key() + "/3 * rss.coordinator.server.periodic.output.interval.times)");
    public static final ConfigOption<AssignmentStrategyFactory.StrategyName> COORDINATOR_ASSIGNMENT_STRATEGY = ConfigOptions.key((String)"rss.coordinator.assignment.strategy").enumType(AssignmentStrategyFactory.StrategyName.class).defaultValue((Object)AssignmentStrategyFactory.StrategyName.PARTITION_BALANCE).withDescription("Strategy for assigning shuffle server to write partitions");
    public static final ConfigOption<Long> COORDINATOR_APP_EXPIRED = ConfigOptions.key((String)"rss.coordinator.app.expired").longType().defaultValue((Object)60000L).withDescription("Application expired time (ms), the heartbeat interval must be less than it");
    public static final ConfigOption<Integer> COORDINATOR_SHUFFLE_NODES_MAX = ConfigOptions.key((String)"rss.coordinator.shuffle.nodes.max").intType().defaultValue((Object)9).withDescription("The max limitation number of shuffle server when do the assignment");
    public static final ConfigOption<List<String>> COORDINATOR_ACCESS_CHECKERS = ConfigOptions.key((String)"rss.coordinator.access.checkers").stringType().asList().defaultValues((Object[])new String[]{"org.apache.uniffle.coordinator.access.checker.AccessClusterLoadChecker", "org.apache.uniffle.coordinator.access.checker.AccessQuotaChecker"}).withDescription("Access checkers");
    public static final ConfigOption<Integer> COORDINATOR_ACCESS_CANDIDATES_UPDATE_INTERVAL_SEC = ConfigOptions.key((String)"rss.coordinator.access.candidates.updateIntervalSec").intType().checkValue(ConfigUtils.POSITIVE_INTEGER_VALIDATOR_2, "access candidates update interval must be positive").defaultValue((Object)120).withDescription("Accessed candidates update interval in seconds");
    public static final ConfigOption<String> COORDINATOR_ACCESS_CANDIDATES_PATH = ConfigOptions.key((String)"rss.coordinator.access.candidates.path").stringType().noDefaultValue().withDescription("Accessed candidates file path");
    public static final ConfigOption<Double> COORDINATOR_ACCESS_LOADCHECKER_MEMORY_PERCENTAGE = ConfigOptions.key((String)"rss.coordinator.access.loadChecker.memory.percentage").doubleType().checkValue(ConfigUtils.PERCENTAGE_DOUBLE_VALIDATOR, "The recovery usage percentage must be between 0.0 and 100.0").defaultValue((Object)15.0).withDescription("The minimal percentage of available memory percentage of a server");
    public static final ConfigOption<Integer> COORDINATOR_ACCESS_LOADCHECKER_SERVER_NUM_THRESHOLD = ConfigOptions.key((String)"rss.coordinator.access.loadChecker.serverNum.threshold").intType().checkValue(ConfigUtils.POSITIVE_INTEGER_VALIDATOR_2, "load checker serverNum threshold must be positive").noDefaultValue().withDescription("The minimal required number of healthy shuffle servers when being accessed by client. And when not specified, it will use the required shuffle-server number from client as the checking condition. If there is no client shuffle-server number specified, the coordinator conf of rss.coordinator.shuffle.nodes.max will be adopted");
    public static final ConfigOption<Boolean> COORDINATOR_DYNAMIC_CLIENT_CONF_ENABLED = ConfigOptions.key((String)"rss.coordinator.dynamicClientConf.enabled").booleanType().defaultValue((Object)false).withDescription("enable dynamic client conf");
    public static final ConfigOption<String> COORDINATOR_DYNAMIC_CLIENT_CONF_PATH = ConfigOptions.key((String)"rss.coordinator.dynamicClientConf.path").stringType().noDefaultValue().withDescription("dynamic client conf of this cluster");
    public static final ConfigOption<ClientConfParser.Parser> COORDINATOR_DYNAMIC_CLIENT_RAW_CONF_PARSER = ConfigOptions.key((String)"rss.coordinator.dynamicClientConf.parser").enumType(ClientConfParser.Parser.class).defaultValue((Object)ClientConfParser.Parser.LEGACY).withDescription("dynamic client conf parser");
    public static final ConfigOption<String> COORDINATOR_REMOTE_STORAGE_PATH = ConfigOptions.key((String)"rss.coordinator.remote.storage.path").stringType().noDefaultValue().withDescription("all supported remote paths for RSS cluster, separated by ','");
    public static final ConfigOption<Integer> COORDINATOR_DYNAMIC_CLIENT_CONF_UPDATE_INTERVAL_SEC = ConfigOptions.key((String)"rss.coordinator.dynamicClientConf.updateIntervalSec").intType().checkValue(ConfigUtils.POSITIVE_INTEGER_VALIDATOR_2, "dynamic client conf update interval in seconds").defaultValue((Object)120).withDescription("The dynamic client conf update interval in seconds");
    public static final ConfigOption<String> COORDINATOR_REMOTE_STORAGE_CLUSTER_CONF = ConfigOptions.key((String)"rss.coordinator.remote.storage.cluster.conf").stringType().noDefaultValue().withDescription("Remote Storage Cluster related conf with format $clusterId,$key=$value, separated by ';'");
    public static final ConfigOption<ApplicationManager.StrategyName> COORDINATOR_REMOTE_STORAGE_SELECT_STRATEGY = ConfigOptions.key((String)"rss.coordinator.remote.storage.select.strategy").enumType(ApplicationManager.StrategyName.class).defaultValue((Object)ApplicationManager.StrategyName.APP_BALANCE).withDescription("Strategy for selecting the remote path");
    public static final ConfigOption<Long> COORDINATOR_REMOTE_STORAGE_SCHEDULE_TIME = ConfigOptions.key((String)"rss.coordinator.remote.storage.schedule.time").longType().defaultValue((Object)60000L).withDescription("The time of scheduling the read and write time of the paths to obtain different Hadoop FS");
    public static final ConfigOption<Integer> COORDINATOR_REMOTE_STORAGE_SCHEDULE_FILE_SIZE = ConfigOptions.key((String)"rss.coordinator.remote.storage.schedule.file.size").intType().defaultValue((Object)204800000).withDescription("The size of the file that the scheduled thread reads and writes");
    public static final ConfigOption<Integer> COORDINATOR_REMOTE_STORAGE_SCHEDULE_ACCESS_TIMES = ConfigOptions.key((String)"rss.coordinator.remote.storage.schedule.access.times").intType().defaultValue((Object)3).withDescription("The number of times to read and write Hadoop FS files");
    public static final ConfigOption<AbstractAssignmentStrategy.HostAssignmentStrategyName> COORDINATOR_ASSIGNMENT_HOST_STRATEGY = ConfigOptions.key((String)"rss.coordinator.assignment.host.strategy").enumType(AbstractAssignmentStrategy.HostAssignmentStrategyName.class).defaultValue((Object)AbstractAssignmentStrategy.HostAssignmentStrategyName.PREFER_DIFF).withDescription("Strategy for selecting shuffle servers");
    public static final ConfigOption<Boolean> COORDINATOR_START_SILENT_PERIOD_ENABLED = ConfigOptions.key((String)"rss.coordinator.startup-silent-period.enabled").booleanType().defaultValue((Object)false).withDescription("Enable the startup-silent-period to reject the assignment requests for avoiding partial assignments. To avoid service interruption, this mechanism is disabled by default. Especially it's recommended to use in coordinator HA mode when restarting single coordinator.");
    public static final ConfigOption<Long> COORDINATOR_START_SILENT_PERIOD_DURATION = ConfigOptions.key((String)"rss.coordinator.startup-silent-period.duration").longType().defaultValue((Object)20000L).withDescription("The waiting duration(ms) when conf of " + COORDINATOR_START_SILENT_PERIOD_ENABLED + " is enabled.");
    public static final ConfigOption<AbstractAssignmentStrategy.SelectPartitionStrategyName> COORDINATOR_SELECT_PARTITION_STRATEGY = ConfigOptions.key((String)"rss.coordinator.select.partition.strategy").enumType(AbstractAssignmentStrategy.SelectPartitionStrategyName.class).defaultValue((Object)AbstractAssignmentStrategy.SelectPartitionStrategyName.CONTINUOUS).withDescription("Strategy for selecting partitions");
    public static final ConfigOption<Integer> COORDINATOR_QUOTA_DEFAULT_APP_NUM = ConfigOptions.key((String)"rss.coordinator.quota.default.app.num").intType().defaultValue((Object)-1).withDescription("Default number of apps at user level, if set value < 0,then this user app quota check would passed");
    public static final ConfigOption<String> COORDINATOR_QUOTA_DEFAULT_PATH = ConfigOptions.key((String)"rss.coordinator.quota.default.path").stringType().noDefaultValue().withDescription("A configuration file for the number of apps for a user-defined user, if set value < 0,then this user app quota check would passed.");
    public static final ConfigOption<Long> COORDINATOR_QUOTA_UPDATE_INTERVAL = ConfigOptions.key((String)"rss.coordinator.quota.update.interval").longType().defaultValue((Object)60000L).withDescription("Update interval for the default number of submitted apps per user");
    public static final ConfigOption<Long> COORDINATOR_NODES_CLIENT_CACHE_EXPIRED = ConfigOptions.key((String)"rss.coordinator.nodes.client.cache.expired").longType().defaultValue((Object)120000L).withDescription("Expired time (ms) for the clients communicating with nodes.");
    public static final ConfigOption<Integer> COORDINATOR_NODES_CLIENT_CACHE_MAX = ConfigOptions.key((String)"rss.coordinator.nodes.client.cache.max").intType().defaultValue((Object)1000).withDescription("The max number of clients that communicating with nodes and storing in the cache.");
    public static final ConfigOption<Boolean> COORDINATOR_RPC_AUDIT_LOG_ENABLED = ConfigOptions.key((String)"rss.coordinator.rpc.audit.log.enabled").booleanType().defaultValue((Object)true).withDescription("When set to true, for auditing purposes, the coordinator will log audit records for every rpc request operation. ");
    public static final ConfigOption<List<String>> COORDINATOR_RPC_AUDIT_LOG_EXCLUDE_LIST = ConfigOptions.key((String)"rss.coordinator.rpc.audit.log.excludeList").stringType().asList().defaultValues((Object[])new String[]{"appHeartbeat", "heartbeat"}).withDescription("Exclude record rpc audit operation list, separated by ','");

    public CoordinatorConf() {
    }

    public CoordinatorConf(String fileName) {
        boolean ret = this.loadConfFromFile(fileName);
        if (!ret) {
            throw new IllegalStateException("Fail to load config file " + fileName);
        }
    }

    public boolean loadConfFromFile(String fileName) {
        return this.loadConfFromFile(fileName, ConfigUtils.getAllConfigOptions(CoordinatorConf.class));
    }
}

