/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.merge;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.internal.OutOfDirectMemoryError;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.netty.buffer.FileSegmentManagedBuffer;
import org.apache.uniffle.common.serializer.SerInputStream;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.NettyUtils;
import org.apache.uniffle.storage.common.FileBasedShuffleSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockFlushFileReader {
    private static final Logger LOG = LoggerFactory.getLogger(BlockFlushFileReader.class);
    private static final int BUFFER_SIZE = 4096;
    private final boolean direct;
    private String dataFile;
    private FileInputStream dataInput;
    private FileChannel dataFileChannel;
    boolean stop = false;
    private final Map<Long, BlockInputStream> inputStreamMap = JavaUtils.newConcurrentMap();
    private final LinkedHashMap<Long, FileBasedShuffleSegment> indexSegments = new LinkedHashMap();
    private FlushFileReader flushFileReader;
    private volatile Throwable readThrowable = null;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final int ringBufferSize;
    private final int mask;

    public BlockFlushFileReader(String dataFile, String indexFile, int ringBufferSize, boolean direct) {
        this.ringBufferSize = ringBufferSize;
        this.direct = direct;
        this.mask = ringBufferSize - 1;
        this.dataFile = dataFile;
        this.loadShuffleIndex(indexFile);
        this.lock.lock();
    }

    void start() throws IOException {
        this.dataInput = new FileInputStream(this.dataFile);
        this.dataFileChannel = this.dataInput.getChannel();
        this.flushFileReader = new FlushFileReader();
        this.flushFileReader.start();
    }

    public void loadShuffleIndex(String indexFileName) {
        File indexFile = new File(indexFileName);
        long indexFileSize = indexFile.length();
        int indexNum = (int)(indexFileSize / 40L);
        int len = indexNum * 40;
        ByteBuffer indexData = new FileSegmentManagedBuffer(indexFile, 0L, len).nioByteBuffer();
        while (indexData.hasRemaining()) {
            long offset = indexData.getLong();
            int length = indexData.getInt();
            int uncompressLength = indexData.getInt();
            long crc = indexData.getLong();
            long blockId = indexData.getLong();
            long taskAttemptId = indexData.getLong();
            FileBasedShuffleSegment fileBasedShuffleSegment = new FileBasedShuffleSegment(blockId, offset, length, uncompressLength, crc, taskAttemptId);
            this.indexSegments.put(fileBasedShuffleSegment.getBlockId(), fileBasedShuffleSegment);
        }
    }

    public void close() throws IOException {
        this.stop = true;
        for (BlockInputStream is : this.inputStreamMap.values()) {
            is.close();
        }
        this.inputStreamMap.clear();
        this.indexSegments.clear();
        if (this.flushFileReader != null) {
            this.flushFileReader.interrupt();
            this.flushFileReader = null;
        }
        if (this.dataInput != null) {
            this.dataInput.close();
            this.dataInput = null;
            this.dataFile = null;
            this.dataFileChannel = null;
        }
    }

    public BlockInputStream registerBlockInputStream(long blockId) {
        if (!this.indexSegments.containsKey(blockId)) {
            return null;
        }
        if (!this.inputStreamMap.containsKey(blockId)) {
            this.inputStreamMap.put(blockId, new BlockInputStream(this.indexSegments.get(blockId).getLength()));
        }
        return this.inputStreamMap.get(blockId);
    }

    public class BlockInputStream
    extends SerInputStream {
        private RingBuffer ringBuffer;
        private boolean eof = false;
        private final int length;
        private int pos = 0;
        private int offsetInThisBlock = 0;

        public BlockInputStream(int length) {
            this.length = length;
        }

        public void init() {
            if (this.ringBuffer == null) {
                this.ringBuffer = new RingBuffer();
            }
        }

        public int available() {
            return this.length - this.pos;
        }

        public long getStart() {
            return 0L;
        }

        public long getEnd() {
            return this.length;
        }

        public void transferTo(ByteBuf to, int len) throws IOException {
            while (len > 0) {
                int c = this.internalTransferTo(to, len);
                len -= c;
            }
        }

        private int internalTransferTo(ByteBuf out, int len) {
            Buffer buffer;
            if (BlockFlushFileReader.this.stop) {
                throw new RssException("Block flush file reader is closed, caused by " + BlockFlushFileReader.this.readThrowable);
            }
            if (len == 0) {
                return 0;
            }
            if (this.eof || len < 0) {
                throw new IndexOutOfBoundsException();
            }
            while (this.ringBuffer.empty() && !BlockFlushFileReader.this.stop) {
                if (BlockFlushFileReader.this.lock.isHeldByCurrentThread()) {
                    BlockFlushFileReader.this.lock.unlock();
                }
                try {
                    BlockFlushFileReader.this.lock.lockInterruptibly();
                }
                catch (InterruptedException e) {
                    throw new RssException((Throwable)e);
                }
            }
            int c = 0;
            while (len > 0 && (buffer = this.ringBuffer.getReadBuffer()) != null) {
                ByteBuf byteBuf = buffer.getByteBuf();
                int toRead = len;
                if (len >= byteBuf.readableBytes()) {
                    this.ringBuffer.incReadIndex();
                    toRead = byteBuf.readableBytes();
                }
                len -= toRead;
                out.writeBytes(byteBuf, toRead);
                this.pos += toRead;
                c += toRead;
            }
            if (this.pos >= this.length) {
                this.eof = true;
            }
            return c;
        }

        public long getOffsetInThisBlock() {
            return this.offsetInThisBlock;
        }

        public void close() {
            if (this.ringBuffer != null) {
                this.ringBuffer.release();
                this.ringBuffer = null;
            }
        }

        public boolean isBufferFull() {
            return this.ringBuffer.full();
        }

        public void writeBuffer() throws IOException {
            int size = this.ringBuffer.write(this.length - this.offsetInThisBlock);
            this.offsetInThisBlock += size;
        }

        public int read(byte[] bs, int off, int len) throws IOException {
            if (BlockFlushFileReader.this.stop) {
                throw new IOException("Block flush file reader is closed, caused by " + BlockFlushFileReader.this.readThrowable);
            }
            if (bs == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > bs.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.eof) {
                return -1;
            }
            while (this.ringBuffer.empty() && !BlockFlushFileReader.this.stop) {
                if (BlockFlushFileReader.this.lock.isHeldByCurrentThread()) {
                    BlockFlushFileReader.this.lock.unlock();
                }
                try {
                    BlockFlushFileReader.this.lock.lockInterruptibly();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            int c = this.ringBuffer.read(bs, off, len);
            this.pos += c;
            if (this.pos >= this.length) {
                this.eof = true;
            }
            return c;
        }

        public int read() throws IOException {
            if (BlockFlushFileReader.this.stop) {
                throw new IOException("Block flush file reader is closed, caused by " + BlockFlushFileReader.this.readThrowable);
            }
            if (this.eof) {
                return -1;
            }
            while (this.ringBuffer.empty() && !BlockFlushFileReader.this.stop) {
                if (BlockFlushFileReader.this.lock.isHeldByCurrentThread()) {
                    BlockFlushFileReader.this.lock.unlock();
                }
                try {
                    BlockFlushFileReader.this.lock.lockInterruptibly();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            int c = this.ringBuffer.read();
            ++this.pos;
            if (this.pos >= this.length) {
                this.eof = true;
            }
            return c;
        }
    }

    class RingBuffer {
        Buffer[] buffers;
        int readIndex = 0;
        int writeIndex = 0;

        RingBuffer() {
            try {
                this.buffers = new Buffer[BlockFlushFileReader.this.ringBufferSize];
                for (int i = 0; i < BlockFlushFileReader.this.ringBufferSize; ++i) {
                    this.buffers[i] = new Buffer();
                }
            }
            catch (OutOfDirectMemoryError error) {
                for (int i = 0; i < BlockFlushFileReader.this.ringBufferSize; ++i) {
                    if (this.buffers[i] == null) continue;
                    this.buffers[i].release();
                }
                throw error;
            }
        }

        boolean full() {
            return this.writeIndex - this.readIndex == BlockFlushFileReader.this.ringBufferSize;
        }

        boolean empty() {
            return this.writeIndex == this.readIndex;
        }

        int write(int available) throws IOException {
            int left = available;
            while (!this.full() && left > 0) {
                int size = Math.min(available, 4096);
                this.buffers[this.writeIndex & BlockFlushFileReader.this.mask].writeBuffer(size);
                left -= size;
                ++this.writeIndex;
            }
            return available - left;
        }

        int read() {
            int ret = this.buffers[this.readIndex & BlockFlushFileReader.this.mask].get();
            if (!this.buffers[this.readIndex & BlockFlushFileReader.this.mask].readable()) {
                ++this.readIndex;
            }
            return ret;
        }

        int read(byte[] bs, int off, int len) {
            int total = 0;
            int end = off + len;
            while (off < end && !this.empty()) {
                Buffer buffer = this.buffers[this.readIndex & BlockFlushFileReader.this.mask];
                int r = buffer.get(bs, off, len);
                if (!this.buffers[this.readIndex & BlockFlushFileReader.this.mask].readable()) {
                    ++this.readIndex;
                }
                off += r;
                len -= r;
                total += r;
            }
            return total;
        }

        Buffer getReadBuffer() {
            if (!this.empty()) {
                return this.buffers[this.readIndex & BlockFlushFileReader.this.mask];
            }
            return null;
        }

        void incReadIndex() {
            ++this.readIndex;
        }

        void release() {
            for (Buffer buffer : this.buffers) {
                buffer.release();
            }
        }
    }

    class Buffer {
        private ByteBuf buffer;

        Buffer() {
            UnpooledByteBufAllocator allocator = NettyUtils.getSharedUnpooledByteBufAllocator((boolean)true);
            this.buffer = BlockFlushFileReader.this.direct ? allocator.directBuffer(4096) : allocator.heapBuffer(4096);
        }

        public int get() {
            return this.buffer.readByte() & 0xFF;
        }

        public int get(byte[] bs, int off, int len) {
            int r = Math.min(this.buffer.readableBytes(), len);
            this.buffer.readBytes(bs, off, r);
            return r;
        }

        public boolean readable() {
            return this.buffer.readableBytes() > 0;
        }

        public void writeBuffer(int length) throws IOException {
            ByteBuffer byteBuffer = this.buffer.nioBuffer(0, length);
            BlockFlushFileReader.this.dataFileChannel.read(byteBuffer);
            this.buffer.readerIndex(0);
            this.buffer.writerIndex(length);
        }

        public ByteBuf getByteBuf() {
            return this.buffer;
        }

        public void release() {
            if (this.buffer != null) {
                this.buffer.release();
                this.buffer = null;
            }
        }
    }

    class FlushFileReader
    extends Thread {
        FlushFileReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!BlockFlushFileReader.this.stop) {
                int available = 0;
                int process = 0;
                try {
                    BlockFlushFileReader.this.lock.lockInterruptibly();
                    try {
                        Iterator iterator = BlockFlushFileReader.this.indexSegments.entrySet().iterator();
                        while (iterator.hasNext()) {
                            FileBasedShuffleSegment segment = (FileBasedShuffleSegment)iterator.next().getValue();
                            long blockId = segment.getBlockId();
                            BlockInputStream inputStream = (BlockInputStream)((Object)BlockFlushFileReader.this.inputStreamMap.get(blockId));
                            if (inputStream == null || inputStream.eof) continue;
                            ++available;
                            if (inputStream.isBufferFull()) continue;
                            ++process;
                            long off = segment.getOffset() + inputStream.getOffsetInThisBlock();
                            if (BlockFlushFileReader.this.dataFileChannel.position() != off) {
                                BlockFlushFileReader.this.dataFileChannel.position(off);
                            }
                            inputStream.writeBuffer();
                        }
                    }
                    catch (Throwable throwable) {
                        BlockFlushFileReader.this.readThrowable = throwable;
                        LOG.info("FlushFileReader read failed, caused by ", throwable);
                        BlockFlushFileReader.this.stop = true;
                    }
                    finally {
                        BlockFlushFileReader.this.lock.unlock();
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("statistics: load buffer available is {}, process is {}", (Object)available, (Object)process);
                    }
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("FlushFileReader for {} have been interrupted.", (Object)BlockFlushFileReader.this.dataFile);
                }
            }
        }
    }
}

