/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.uniffle.shaded.io.prometheus.client.Collector;
import org.apache.uniffle.shaded.io.prometheus.client.GaugeMetricFamily;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SupplierGauge<T extends Number>
extends Collector
implements Collector.Describable {
    private static final Logger LOG = LoggerFactory.getLogger(SupplierGauge.class);
    private String name;
    private String help;
    private Supplier<T> supplier;
    private List<String> labelNames;
    private List<String> labelValues;
    private long updateInterval;
    private long lastUpdateTime;
    private T lastValue;

    SupplierGauge(String name, String help, Supplier<T> supplier, String[] labelNames, String[] labelValues) {
        this(name, help, supplier, labelNames, labelValues, 0L);
    }

    SupplierGauge(String name, String help, Supplier<T> supplier, String[] labelNames, String[] labelValues, long updateInterval) {
        this.name = name;
        this.help = help;
        this.supplier = supplier;
        this.labelNames = Arrays.asList(labelNames);
        this.labelValues = Arrays.asList(labelValues);
        this.updateInterval = updateInterval;
        this.lastUpdateTime = 0L;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        long time = System.currentTimeMillis();
        if (time - this.lastUpdateTime > this.updateInterval) {
            this.lastValue = (Number)this.supplier.get();
            this.lastUpdateTime = time;
        }
        if (this.lastValue == null) {
            LOG.warn("SupplierGauge {} returned null value.", (Object)this.name);
            return Collections.emptyList();
        }
        samples.add(new Collector.MetricFamilySamples.Sample(this.name, this.labelNames, this.labelValues, ((Number)this.lastValue).doubleValue()));
        Collector.MetricFamilySamples mfs = new Collector.MetricFamilySamples(this.name, Collector.Type.GAUGE, this.help, samples);
        ArrayList<Collector.MetricFamilySamples> mfsList = new ArrayList<Collector.MetricFamilySamples>(1);
        mfsList.add(mfs);
        return mfsList;
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        return Collections.singletonList(new GaugeMetricFamily(this.name, this.help, this.labelNames));
    }
}

