/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.writer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.spark.Aggregator;
import org.apache.spark.Partitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.shuffle.RssShuffleHandle;
import org.apache.spark.shuffle.RssShuffleManager;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.spark.shuffle.RssSparkShuffleUtils;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.handle.ShuffleHandleInfo;
import org.apache.spark.shuffle.handle.SimpleShuffleHandleInfo;
import org.apache.spark.shuffle.writer.AddBlockEvent;
import org.apache.spark.shuffle.writer.BufferManagerOptions;
import org.apache.spark.shuffle.writer.WriteBufferManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.uniffle.client.api.ShuffleManagerClient;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.impl.FailedBlockSendTracker;
import org.apache.uniffle.client.request.RssReportShuffleWriteFailureRequest;
import org.apache.uniffle.client.response.RssReportShuffleWriteFailureResponse;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssSendFailedException;
import org.apache.uniffle.common.exception.RssWaitFailedException;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.com.google.common.collect.Maps;
import org.apache.uniffle.shaded.com.google.common.collect.Sets;
import org.apache.uniffle.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.uniffle.storage.util.StorageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Product2;
import scala.collection.Iterator;

public class RssShuffleWriter<K, V, C>
extends ShuffleWriter<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(RssShuffleWriter.class);
    private static final String DUMMY_HOST = "dummy_host";
    private static final int DUMMY_PORT = 99999;
    private final Set<ShuffleServerInfo> shuffleServersForData;
    private Map<ShuffleServerInfo, Map<Integer, Set<Long>>> serverToPartitionToBlockIds;
    private final ShuffleWriteClient shuffleWriteClient;
    private final Map<Integer, List<ShuffleServerInfo>> partitionToServers;
    private String appId;
    private int numMaps;
    private int shuffleId;
    private final ShuffleHandleInfo shuffleHandleInfo;
    private int bitmapSplitNum;
    private String taskId;
    private long taskAttemptId;
    private ShuffleDependency<K, V, C> shuffleDependency;
    private ShuffleWriteMetrics shuffleWriteMetrics;
    private Partitioner partitioner;
    private boolean shouldPartition;
    private WriteBufferManager bufferManager;
    private RssShuffleManager shuffleManager;
    private long sendCheckTimeout;
    private long sendCheckInterval;
    private boolean isMemoryShuffleEnabled;
    private final Function<String, Boolean> taskFailureCallback;
    private final Set<Long> blockIds = Sets.newConcurrentHashSet();
    private TaskContext taskContext;
    private SparkConf sparkConf;
    private Supplier<ShuffleManagerClient> managerClientSupplier;
    private boolean enableWriteFailureRetry;
    private Set<ShuffleServerInfo> recordReportFailedShuffleservers;

    public RssShuffleWriter(String appId, int shuffleId, String taskId, long taskAttemptId, WriteBufferManager bufferManager, ShuffleWriteMetrics shuffleWriteMetrics, RssShuffleManager shuffleManager, SparkConf sparkConf, ShuffleWriteClient shuffleWriteClient, Supplier<ShuffleManagerClient> managerClientSupplier, RssShuffleHandle<K, V, C> rssHandle, SimpleShuffleHandleInfo shuffleHandleInfo, TaskContext context) {
        this(appId, shuffleId, taskId, taskAttemptId, shuffleWriteMetrics, shuffleManager, sparkConf, shuffleWriteClient, managerClientSupplier, rssHandle, (String tid) -> true, (ShuffleHandleInfo)shuffleHandleInfo, context);
        this.bufferManager = bufferManager;
    }

    private RssShuffleWriter(String appId, int shuffleId, String taskId, long taskAttemptId, ShuffleWriteMetrics shuffleWriteMetrics, RssShuffleManager shuffleManager, SparkConf sparkConf, ShuffleWriteClient shuffleWriteClient, Supplier<ShuffleManagerClient> managerClientSupplier, RssShuffleHandle<K, V, C> rssHandle, Function<String, Boolean> taskFailureCallback, ShuffleHandleInfo shuffleHandleInfo, TaskContext context) {
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.taskId = taskId;
        this.taskAttemptId = taskAttemptId;
        this.numMaps = rssHandle.getNumMaps();
        this.shuffleDependency = rssHandle.getDependency();
        this.shuffleWriteMetrics = shuffleWriteMetrics;
        this.partitioner = this.shuffleDependency.partitioner();
        this.shuffleManager = shuffleManager;
        this.shouldPartition = this.partitioner.numPartitions() > 1;
        this.sendCheckTimeout = (Long)sparkConf.get(RssSparkConfig.RSS_CLIENT_SEND_CHECK_TIMEOUT_MS);
        this.sendCheckInterval = (Long)sparkConf.get(RssSparkConfig.RSS_CLIENT_SEND_CHECK_INTERVAL_MS);
        this.bitmapSplitNum = (Integer)sparkConf.get(RssSparkConfig.RSS_CLIENT_BITMAP_SPLIT_NUM);
        this.serverToPartitionToBlockIds = Maps.newHashMap();
        this.shuffleWriteClient = shuffleWriteClient;
        this.managerClientSupplier = managerClientSupplier;
        this.shuffleServersForData = shuffleHandleInfo.getServers();
        this.partitionToServers = shuffleHandleInfo.getAvailablePartitionServersForWriter();
        this.isMemoryShuffleEnabled = this.isMemoryShuffleEnabled(sparkConf.get(RssSparkConfig.RSS_STORAGE_TYPE.key()));
        this.taskFailureCallback = taskFailureCallback;
        this.shuffleHandleInfo = shuffleHandleInfo;
        this.taskContext = context;
        this.sparkConf = sparkConf;
        this.enableWriteFailureRetry = RssSparkConfig.toRssConf(sparkConf).get(RssSparkConfig.RSS_RESUBMIT_STAGE_WITH_WRITE_FAILURE_ENABLED);
        this.recordReportFailedShuffleservers = Sets.newConcurrentHashSet();
    }

    public RssShuffleWriter(String appId, int shuffleId, String taskId, long taskAttemptId, ShuffleWriteMetrics shuffleWriteMetrics, RssShuffleManager shuffleManager, SparkConf sparkConf, ShuffleWriteClient shuffleWriteClient, Supplier<ShuffleManagerClient> managerClientSupplier, RssShuffleHandle<K, V, C> rssHandle, Function<String, Boolean> taskFailureCallback, TaskContext context) {
        this(appId, shuffleId, taskId, taskAttemptId, shuffleWriteMetrics, shuffleManager, sparkConf, shuffleWriteClient, managerClientSupplier, rssHandle, taskFailureCallback, shuffleManager.getShuffleHandleInfo(context.stageId(), context.stageAttemptNumber(), rssHandle, true), context);
        WriteBufferManager bufferManager;
        BufferManagerOptions bufferOptions = new BufferManagerOptions(sparkConf);
        this.bufferManager = bufferManager = new WriteBufferManager(shuffleId, taskId, taskAttemptId, bufferOptions, rssHandle.getDependency().serializer(), this.shuffleHandleInfo.getAvailablePartitionServersForWriter(), context.taskMemoryManager(), shuffleWriteMetrics, RssSparkConfig.toRssConf(sparkConf), this::processShuffleBlockInfos, context.stageAttemptNumber());
    }

    private boolean isMemoryShuffleEnabled(String storageType) {
        return StorageType.withMemory(StorageType.valueOf(storageType));
    }

    private BlockManagerId createDummyBlockManagerId(String executorId, long taskAttemptId) {
        return BlockManagerId.apply((String)executorId, (String)DUMMY_HOST, (int)99999, (Option)Option.apply((Object)Long.toString(taskAttemptId)));
    }

    public void write(Iterator<Product2<K, V>> records) {
        try {
            this.writeImpl(records);
        }
        catch (Exception e) {
            this.taskFailureCallback.apply(this.taskId);
            if (this.enableWriteFailureRetry) {
                this.throwFetchFailedIfNecessary(e, Sets.newConcurrentHashSet());
            }
            throw e;
        }
    }

    private void writeImpl(Iterator<Product2<K, V>> records) {
        List<ShuffleBlockInfo> shuffleBlockInfos;
        long recordCount = 0L;
        while (records.hasNext()) {
            ++recordCount;
            Product2 record = (Product2)records.next();
            int partition = this.getPartition(record._1());
            if (this.shuffleDependency.mapSideCombine()) {
                Function1 createCombiner = ((Aggregator)this.shuffleDependency.aggregator().get()).createCombiner();
                Object c = createCombiner.apply(record._2());
                shuffleBlockInfos = this.bufferManager.addRecord(partition, record._1(), c);
            } else {
                shuffleBlockInfos = this.bufferManager.addRecord(partition, record._1(), record._2());
            }
            this.processShuffleBlockInfos(shuffleBlockInfos);
        }
        long start = System.currentTimeMillis();
        shuffleBlockInfos = this.bufferManager.clear(1.0);
        this.processShuffleBlockInfos(shuffleBlockInfos);
        long s2 = System.currentTimeMillis();
        this.checkAllBufferSpilled();
        this.checkSentRecordCount(recordCount);
        this.checkBlockSendResult(new HashSet<Long>(this.blockIds));
        this.checkSentBlockCount();
        long checkDuration = System.currentTimeMillis() - s2;
        long commitDuration = 0L;
        if (!this.isMemoryShuffleEnabled) {
            s2 = System.currentTimeMillis();
            this.sendCommit();
            commitDuration = System.currentTimeMillis() - s2;
        }
        long writeDurationMs = this.bufferManager.getWriteTime() + (System.currentTimeMillis() - start);
        this.shuffleWriteMetrics.incWriteTime(TimeUnit.MILLISECONDS.toNanos(writeDurationMs));
        LOG.info("Finish write shuffle for appId[" + this.appId + "], shuffleId[" + this.shuffleId + "], taskId[" + this.taskId + "] with write " + writeDurationMs + " ms, include checkSendResult[" + checkDuration + "], commit[" + commitDuration + "], " + this.bufferManager.getManagerCostInfo());
    }

    private void checkAllBufferSpilled() {
        if (this.bufferManager.getBuffers().size() > 0) {
            throw new RssSendFailedException("Potential data loss due to existing remaining data buffers that are not flushed. This should not happen.");
        }
    }

    private void checkSentRecordCount(long recordCount) {
        if (recordCount != this.bufferManager.getRecordCount()) {
            String errorMsg = "Potential record loss may have occurred while preparing to send blocks for task[" + this.taskId + "]";
            throw new RssSendFailedException(errorMsg);
        }
    }

    private void checkSentBlockCount() {
        long expected = this.blockIds.size();
        long bufferManagerTracked = this.bufferManager.getBlockCount();
        if (this.serverToPartitionToBlockIds == null) {
            throw new RssException("serverToPartitionToBlockIds should not be null");
        }
        HashSet blockIds = new HashSet();
        for (Map<Integer, Set<Long>> partitionBlockIds : this.serverToPartitionToBlockIds.values()) {
            partitionBlockIds.values().forEach(x -> blockIds.addAll(x));
        }
        long serverTracked = blockIds.size();
        if (expected != serverTracked || expected != bufferManagerTracked) {
            throw new RssSendFailedException("Potential block loss may occur for task[" + this.taskId + "]. BlockId number expected: " + expected + ", serverTracked: " + serverTracked + ", bufferManagerTracked: " + bufferManagerTracked);
        }
    }

    private List<CompletableFuture<Long>> processShuffleBlockInfos(List<ShuffleBlockInfo> shuffleBlockInfoList) {
        if (shuffleBlockInfoList != null && !shuffleBlockInfoList.isEmpty()) {
            shuffleBlockInfoList.stream().forEach(sbi -> {
                long blockId = sbi.getBlockId();
                this.blockIds.add(blockId);
                int partitionId = sbi.getPartitionId();
                sbi.getShuffleServerInfos().forEach(shuffleServerInfo -> {
                    Map pToBlockIds = this.serverToPartitionToBlockIds.computeIfAbsent((ShuffleServerInfo)shuffleServerInfo, k -> Maps.newHashMap());
                    pToBlockIds.computeIfAbsent(partitionId, v -> Sets.newHashSet()).add(blockId);
                });
            });
            return this.postBlockEvent(shuffleBlockInfoList);
        }
        return Collections.emptyList();
    }

    protected List<CompletableFuture<Long>> postBlockEvent(List<ShuffleBlockInfo> shuffleBlockInfoList) {
        ArrayList<CompletableFuture<Long>> futures = new ArrayList<CompletableFuture<Long>>();
        for (AddBlockEvent event : this.bufferManager.buildBlockEvents(shuffleBlockInfoList)) {
            futures.add(this.shuffleManager.sendData(event));
        }
        return futures;
    }

    @VisibleForTesting
    protected void sendCommit() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> future = executor.submit(() -> this.shuffleWriteClient.sendCommit(this.shuffleServersForData, this.appId, this.shuffleId, this.numMaps));
        long start = System.currentTimeMillis();
        int currentWait = 200;
        int maxWait = 5000;
        while (!future.isDone()) {
            LOG.info("Wait commit to shuffle server for task[" + this.taskAttemptId + "] cost " + (System.currentTimeMillis() - start) + " ms");
            Uninterruptibles.sleepUninterruptibly(currentWait, TimeUnit.MILLISECONDS);
            currentWait = Math.min(currentWait * 2, maxWait);
        }
        try {
            if (!future.get().booleanValue()) {
                throw new RssException("Failed to commit task to shuffle server");
            }
        }
        catch (InterruptedException ie) {
            LOG.warn("Ignore the InterruptedException which should be caused by internal killed");
        }
        catch (Exception e) {
            throw new RssException("Exception happened when get commit status", e);
        }
        finally {
            executor.shutdown();
        }
    }

    @VisibleForTesting
    protected void checkBlockSendResult(Set<Long> blockIds) {
        block2: {
            long start = System.currentTimeMillis();
            do {
                Set<Long> failedBlockIds = this.shuffleManager.getFailedBlockIds(this.taskId);
                Set<Long> successBlockIds = this.shuffleManager.getSuccessBlockIds(this.taskId);
                if (failedBlockIds.size() > 0) {
                    String errorMsg = "Send failed: Task[" + this.taskId + "] failed because " + failedBlockIds.size() + " blocks can't be sent to shuffle server: " + this.shuffleManager.getBlockIdsFailedSendTracker(this.taskId).getFaultyShuffleServers();
                    LOG.error(errorMsg);
                    throw new RssSendFailedException(errorMsg);
                }
                blockIds.removeAll(successBlockIds);
                if (blockIds.isEmpty()) break block2;
                LOG.info("Wait " + blockIds.size() + " blocks sent to shuffle server");
                Uninterruptibles.sleepUninterruptibly(this.sendCheckInterval, TimeUnit.MILLISECONDS);
            } while (System.currentTimeMillis() - start <= this.sendCheckTimeout);
            String errorMsg = "Timeout: Task[" + this.taskId + "] failed because " + blockIds.size() + " blocks can't be sent to shuffle server in " + this.sendCheckTimeout + " ms.";
            LOG.error(errorMsg);
            throw new RssWaitFailedException(errorMsg);
        }
    }

    public Option<MapStatus> stop(boolean success) {
        try {
            if (success) {
                long[] partitionLengths = new long[this.partitioner.numPartitions()];
                Arrays.fill(partitionLengths, 1L);
                BlockManagerId blockManagerId = this.createDummyBlockManagerId(this.appId + "_" + this.taskId, this.taskAttemptId);
                long start = System.currentTimeMillis();
                this.shuffleWriteClient.reportShuffleResult(this.serverToPartitionToBlockIds, this.appId, this.shuffleId, this.taskAttemptId, this.bitmapSplitNum, this.recordReportFailedShuffleservers, this.enableWriteFailureRetry);
                long reportDuration = System.currentTimeMillis() - start;
                LOG.info("Reported all shuffle result for shuffleId[{}] task[{}] with bitmapNum[{}] cost {} ms", new Object[]{this.shuffleId, this.taskAttemptId, this.bitmapSplitNum, reportDuration});
                this.shuffleWriteMetrics.incWriteTime(TimeUnit.MILLISECONDS.toNanos(reportDuration));
                MapStatus mapStatus = MapStatus$.MODULE$.apply(blockManagerId, partitionLengths);
                Option option = Option.apply((Object)mapStatus);
                return option;
            }
            Option partitionLengths = Option.empty();
            return partitionLengths;
        }
        catch (Exception e) {
            if (this.enableWriteFailureRetry) {
                throw this.throwFetchFailedIfNecessary(e, this.recordReportFailedShuffleservers);
            }
            throw e;
        }
        finally {
            if (this.bufferManager != null) {
                this.bufferManager.freeAllMemory();
            }
            if (this.shuffleManager != null) {
                this.shuffleManager.clearTaskMeta(this.taskId);
            }
        }
    }

    @VisibleForTesting
    protected <T> int getPartition(T key) {
        int result = 0;
        if (this.shouldPartition) {
            result = this.partitioner.getPartition(key);
        }
        return result;
    }

    @VisibleForTesting
    protected Map<Integer, Set<Long>> getPartitionToBlockIds() {
        return this.serverToPartitionToBlockIds.values().stream().flatMap(s2 -> s2.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existingSet, newSet) -> {
            HashSet mergedSet = new HashSet(existingSet);
            mergedSet.addAll(newSet);
            return mergedSet;
        }));
    }

    @VisibleForTesting
    protected ShuffleWriteMetrics getShuffleWriteMetrics() {
        return this.shuffleWriteMetrics;
    }

    private RssException throwFetchFailedIfNecessary(Exception e, Set<ShuffleServerInfo> reportFailuredServers) {
        if (e instanceof RssSendFailedException) {
            FailedBlockSendTracker blockIdsFailedSendTracker = this.shuffleManager.getBlockIdsFailedSendTracker(this.taskId);
            ArrayList<ShuffleServerInfo> shuffleServerInfos = Lists.newArrayList(blockIdsFailedSendTracker.getFaultyShuffleServers());
            shuffleServerInfos.addAll(reportFailuredServers);
            RssReportShuffleWriteFailureRequest req = new RssReportShuffleWriteFailureRequest(this.appId, this.shuffleId, this.taskContext.stageId(), this.taskContext.stageAttemptNumber(), shuffleServerInfos, e.getMessage());
            RssReportShuffleWriteFailureResponse response = this.managerClientSupplier.get().reportShuffleWriteFailure(req);
            if (response.getReSubmitWholeStage()) {
                LOG.warn("Multiple task failures trigger Stage retry.");
                FetchFailedException ffe = RssSparkShuffleUtils.createFetchFailedException(this.shuffleId, -1, this.taskContext.stageAttemptNumber(), e);
                throw new RssException((Throwable)ffe);
            }
        }
        throw new RssException(e);
    }
}

