/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.writer;

import org.apache.spark.SparkConf;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.uniffle.common.exception.RssException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferManagerOptions {
    private static final Logger LOG = LoggerFactory.getLogger(BufferManagerOptions.class);
    private long bufferSize;
    private long serializerBufferSize;
    private long bufferSegmentSize;
    private long bufferSpillThreshold;
    private long preAllocatedBufferSize;
    private long requireMemoryInterval;
    private int requireMemoryRetryMax;
    private double bufferSpillPercent;

    public BufferManagerOptions(SparkConf sparkConf) {
        this.bufferSize = sparkConf.getSizeAsBytes(RssSparkConfig.RSS_WRITER_BUFFER_SIZE.key(), (String)RssSparkConfig.RSS_WRITER_BUFFER_SIZE.defaultValue().get());
        this.serializerBufferSize = sparkConf.getSizeAsBytes(RssSparkConfig.RSS_WRITER_SERIALIZER_BUFFER_SIZE.key(), (String)RssSparkConfig.RSS_WRITER_SERIALIZER_BUFFER_SIZE.defaultValue().get());
        this.bufferSegmentSize = sparkConf.getSizeAsBytes(RssSparkConfig.RSS_WRITER_BUFFER_SEGMENT_SIZE.key(), (String)RssSparkConfig.RSS_WRITER_BUFFER_SEGMENT_SIZE.defaultValue().get());
        this.bufferSpillThreshold = sparkConf.getSizeAsBytes(RssSparkConfig.RSS_WRITER_BUFFER_SPILL_SIZE.key(), (String)RssSparkConfig.RSS_WRITER_BUFFER_SPILL_SIZE.defaultValue().get());
        this.bufferSpillPercent = sparkConf.getDouble(RssSparkConfig.RSS_MEMORY_SPILL_RATIO.key(), RssSparkConfig.RSS_MEMORY_SPILL_RATIO.defaultValue().doubleValue());
        this.preAllocatedBufferSize = sparkConf.getSizeAsBytes(RssSparkConfig.RSS_WRITER_PRE_ALLOCATED_BUFFER_SIZE.key(), (String)RssSparkConfig.RSS_WRITER_PRE_ALLOCATED_BUFFER_SIZE.defaultValue().get());
        this.requireMemoryInterval = (Long)sparkConf.get(RssSparkConfig.RSS_WRITER_REQUIRE_MEMORY_INTERVAL);
        this.requireMemoryRetryMax = (Integer)sparkConf.get(RssSparkConfig.RSS_WRITER_REQUIRE_MEMORY_RETRY_MAX);
        if (LOG.isDebugEnabled()) {
            LOG.debug("New buffer manager options, bufferSize: {}, bufferSpillThreshold: {}, preAllocatedBufferSize: {}", new Object[]{this.bufferSize, this.bufferSpillThreshold, this.preAllocatedBufferSize});
        }
        this.checkBufferSize();
    }

    private void checkBufferSize() {
        if (this.bufferSize < 0L) {
            throw new RssException("Unexpected value of " + RssSparkConfig.RSS_WRITER_BUFFER_SIZE.key() + "=" + this.bufferSize);
        }
        if (this.bufferSpillThreshold < 0L) {
            throw new RssException("Unexpected value of " + RssSparkConfig.RSS_WRITER_BUFFER_SPILL_SIZE.key() + "=" + this.bufferSpillThreshold);
        }
        if (this.bufferSegmentSize > this.bufferSize) {
            LOG.warn(RssSparkConfig.RSS_WRITER_BUFFER_SEGMENT_SIZE.key() + "[" + this.bufferSegmentSize + "] should be less than " + RssSparkConfig.RSS_WRITER_BUFFER_SIZE.key() + "[" + this.bufferSize + "]");
        }
    }

    public int getBufferSize() {
        return this.parseToInt(this.bufferSize);
    }

    public int getSerializerBufferSize() {
        return this.parseToInt(this.serializerBufferSize);
    }

    public int getBufferSegmentSize() {
        return this.parseToInt(this.bufferSegmentSize);
    }

    private int parseToInt(long value) {
        if (value > Integer.MAX_VALUE) {
            value = Integer.MAX_VALUE;
        }
        return (int)value;
    }

    public long getPreAllocatedBufferSize() {
        return this.preAllocatedBufferSize;
    }

    public long getBufferSpillThreshold() {
        return this.bufferSpillThreshold;
    }

    public double getBufferSpillPercent() {
        return this.bufferSpillPercent;
    }

    public long getRequireMemoryInterval() {
        return this.requireMemoryInterval;
    }

    public int getRequireMemoryRetryMax() {
        return this.requireMemoryRetryMax;
    }
}

