/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.internet;

import jakarta.mail.Address;
import jakarta.mail.Session;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.AddressParser;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParseException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;

public class InternetAddress
extends Address
implements Cloneable {
    private static final long serialVersionUID = -7507595530758302903L;
    protected String address;
    protected String encodedPersonal;
    protected String personal;

    public InternetAddress() {
    }

    public InternetAddress(String address) throws AddressException {
        this(address, true);
    }

    public InternetAddress(String address, boolean strict) throws AddressException {
        AddressParser parser = new AddressParser(address, strict ? 2 : 0);
        InternetAddress parsedAddress = parser.parseAddress();
        this.address = parsedAddress.address;
        this.personal = parsedAddress.personal;
        this.encodedPersonal = parsedAddress.encodedPersonal;
    }

    public InternetAddress(String address, String personal) throws UnsupportedEncodingException {
        this(address, personal, null);
    }

    public InternetAddress(String address, String personal, String charset) throws UnsupportedEncodingException {
        this.address = address;
        this.setPersonal(personal, charset);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
    }

    @Override
    public String getType() {
        return "rfc822";
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPersonal(String name, String charset) throws UnsupportedEncodingException {
        this.personal = name;
        this.encodedPersonal = name != null ? MimeUtility.encodeWord(name, charset, null) : null;
    }

    public void setPersonal(String name) throws UnsupportedEncodingException {
        this.personal = name;
        this.encodedPersonal = name != null ? MimeUtility.encodeWord(name) : null;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonal() {
        if (this.personal == null && this.encodedPersonal != null) {
            try {
                this.personal = MimeUtility.decodeWord(this.encodedPersonal);
            }
            catch (ParseException e) {
                return this.encodedPersonal;
            }
            catch (UnsupportedEncodingException e) {
                return this.encodedPersonal;
            }
        }
        return this.personal;
    }

    private String getEncodedPersonal() {
        if (this.encodedPersonal == null && this.personal != null) {
            try {
                this.encodedPersonal = MimeUtility.encodeWord(this.personal);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return this.encodedPersonal;
    }

    @Override
    public String toString() {
        if (this.isGroup()) {
            return this.address;
        }
        String p = this.getEncodedPersonal();
        if (p == null) {
            return this.formatAddress(this.address);
        }
        StringBuffer buf = new StringBuffer(p.length() + 8 + this.address.length() + 3);
        buf.append(AddressParser.quoteString(p));
        buf.append(" <").append(this.address).append(">");
        return buf.toString();
    }

    private String formatAddress(String a) {
        if (this.address.endsWith(";") && this.address.indexOf(":") > 0) {
            return this.address;
        }
        if (AddressParser.containsCharacters(a, "()<>,;:\"[]")) {
            StringBuffer buf = new StringBuffer(this.address.length() + 3);
            buf.append("<").append(this.address).append(">");
            return buf.toString();
        }
        return this.address;
    }

    public String toUnicodeString() {
        if (this.isGroup()) {
            return this.address;
        }
        String p = this.getPersonal();
        if (p == null) {
            return this.formatAddress(this.address);
        }
        StringBuffer buf = new StringBuffer(p.length() + 8 + this.address.length() + 3);
        buf.append(AddressParser.quoteString(p));
        buf.append(" <").append(this.address).append(">");
        return buf.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternetAddress)) {
            return false;
        }
        InternetAddress other = (InternetAddress)o;
        String myAddress = this.getAddress();
        return myAddress == null ? other.getAddress() == null : myAddress.equalsIgnoreCase(other.getAddress());
    }

    public int hashCode() {
        return this.address == null ? 0 : this.address.toLowerCase().hashCode();
    }

    public boolean isGroup() {
        if (this.address == null) {
            return false;
        }
        return this.address.endsWith(";") && this.address.indexOf(":") > 0;
    }

    public InternetAddress[] getGroup(boolean strict) throws AddressException {
        if (this.address == null) {
            return null;
        }
        AddressParser parser = new AddressParser(this.address, strict ? 2 : 0);
        return parser.extractGroupList();
    }

    public static InternetAddress getLocalAddress(Session session) {
        String host = null;
        String user = null;
        if (session != null) {
            String address = session.getProperty("mail.from");
            if (address != null) {
                try {
                    return new InternetAddress(address);
                }
                catch (AddressException e) {
                    return null;
                }
            }
            user = session.getProperty("mail.user");
            host = session.getProperty("mail.host");
        }
        try {
            if (user == null) {
                user = System.getProperty("user.name");
            }
            if (host == null) {
                host = InetAddress.getLocalHost().getHostName();
            }
            if (user != null && host != null) {
                return new InternetAddress(user + '@' + host);
            }
        }
        catch (AddressException addressException) {
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static String toString(Address[] addresses) {
        return InternetAddress.toString(addresses, 0);
    }

    public static String toString(Address[] addresses, int used) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        if (addresses.length == 1) {
            String s = addresses[0].toString();
            if (used + s.length() > 72) {
                s = "\r\n  " + s;
            }
            return s;
        }
        StringBuffer buf = new StringBuffer(addresses.length * 32);
        for (int i = 0; i < addresses.length; ++i) {
            String s = addresses[i].toString();
            if (i == 0) {
                if (used + s.length() + 1 > 72) {
                    buf.append("\r\n  ");
                    used = 2;
                }
            } else if (used + s.length() + 1 > 72) {
                buf.append(",\r\n  ");
                used = 2;
            } else {
                buf.append(", ");
                used += 2;
            }
            buf.append(s);
            used += s.length();
        }
        return buf.toString();
    }

    public static InternetAddress[] parse(String addresses) throws AddressException {
        return InternetAddress.parse(addresses, true);
    }

    public static InternetAddress[] parse(String addresses, boolean strict) throws AddressException {
        return InternetAddress.parse(addresses, strict ? 2 : 0);
    }

    public static InternetAddress[] parseHeader(String addresses, boolean strict) throws AddressException {
        return InternetAddress.parse(addresses, strict ? 2 : 1);
    }

    private static InternetAddress[] parse(String addresses, int level) throws AddressException {
        AddressParser parser = new AddressParser(addresses, level);
        return parser.parseAddressList();
    }

    public void validate() throws AddressException {
        AddressParser parser = new AddressParser(this.formatAddress(this.address), 2);
        parser.validateAddress();
    }

    public static String toUnicodeString(Address[] addresses) {
        return InternetAddress.toUnicodeString(addresses, 0);
    }

    public static String toUnicodeString(Address[] addresses, int used) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        boolean sawNonAsciiCharacters = false;
        if (addresses.length == 1) {
            String converted = ((InternetAddress)addresses[0]).toUnicodeString();
            if (MimeUtility.verifyAscii(converted) != 1) {
                sawNonAsciiCharacters = true;
                converted = new String(converted.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            }
            if (used + converted.length() > 72) {
                converted = "\r\n  " + converted;
            }
            if (sawNonAsciiCharacters) {
                return new String(converted.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            }
            return converted;
        }
        StringBuffer buf = new StringBuffer(addresses.length * 32);
        for (int i = 0; i < addresses.length; ++i) {
            String converted = ((InternetAddress)addresses[0]).toUnicodeString();
            if (MimeUtility.verifyAscii(converted) != 1) {
                sawNonAsciiCharacters = true;
                converted = new String(converted.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            }
            if (i == 0) {
                if (used + converted.length() + 1 > 72) {
                    buf.append("\r\n  ");
                    used = 2;
                }
            } else if (used + converted.length() + 1 > 72) {
                buf.append(",\r\n  ");
                used = 2;
            } else {
                buf.append(", ");
                used += 2;
            }
            buf.append(converted);
            used += converted.length();
        }
        String finalString = buf.toString();
        if (sawNonAsciiCharacters) {
            return new String(finalString.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        return finalString;
    }
}

