/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class TracerConsumer
implements Consumer {
    private Consumer delegate;
    private String serverUrl;
    public static final String OPERATE_NAME_PREFIX = "RabbitMQ/";
    public static final String CONSUMER_OPERATE_NAME_SUFFIX = "/Consumer";

    public TracerConsumer(Consumer delegate, String serverUrl) {
        this.delegate = delegate;
        this.serverUrl = serverUrl;
    }

    public void handleConsumeOk(String consumerTag) {
        this.delegate.handleConsumeOk(consumerTag);
    }

    public void handleCancelOk(String consumerTag) {
        this.delegate.handleCancelOk(consumerTag);
    }

    public void handleCancel(String consumerTag) throws IOException {
        this.delegate.handleCancel(consumerTag);
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        this.delegate.handleShutdownSignal(consumerTag, sig);
    }

    public void handleRecoverOk(String consumerTag) {
        this.delegate.handleRecoverOk(consumerTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        ContextCarrier contextCarrier = new ContextCarrier();
        AbstractSpan activeSpan = ContextManager.createEntrySpan((String)("RabbitMQ/Topic/" + envelope.getExchange() + "Queue/" + envelope.getRoutingKey() + CONSUMER_OPERATE_NAME_SUFFIX), null).start(System.currentTimeMillis());
        Tags.MQ_BROKER.set(activeSpan, this.serverUrl);
        Tags.MQ_TOPIC.set(activeSpan, envelope.getExchange());
        Tags.MQ_QUEUE.set(activeSpan, envelope.getRoutingKey());
        activeSpan.setComponent((Component)ComponentsDefine.RABBITMQ_CONSUMER);
        activeSpan.setPeer(this.serverUrl);
        SpanLayer.asMQ((AbstractSpan)activeSpan);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            if (properties.getHeaders() == null || properties.getHeaders().get(next.getHeadKey()) == null) continue;
            next.setHeadValue(properties.getHeaders().get(next.getHeadKey()).toString());
        }
        ContextManager.extract((ContextCarrier)contextCarrier);
        try {
            this.delegate.handleDelivery(consumerTag, envelope, properties, body);
        }
        catch (Exception e) {
            activeSpan.log((Throwable)e).errorOccurred();
        }
        finally {
            ContextManager.stopSpan((AbstractSpan)activeSpan);
        }
    }
}

