/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jsonrpc4j;

import java.lang.reflect.Method;
import java.net.URL;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jsonrpc4j.JsonRpcPeerInfo;

public class JsonRpcHttpClientInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    public void onConstruct(EnhancedInstance objInst, Object[] objects) {
        URL url = (URL)objects[1];
        JsonRpcPeerInfo clientDto = new JsonRpcPeerInfo();
        int port = url.getPort();
        if (port < 0) {
            port = this.isHttps(url) ? 443 : 80;
        }
        clientDto.setPort(port);
        clientDto.setServiceUrl(url);
        objInst.setSkyWalkingDynamicField((Object)clientDto);
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] objects, Class<?>[] classes, MethodInterceptResult result) throws Throwable {
        JsonRpcPeerInfo clientDto = (JsonRpcPeerInfo)objInst.getSkyWalkingDynamicField();
        String methodName = objects[0].toString();
        String operationName = clientDto.getServiceUrl().getPath() + "." + methodName;
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (ContextCarrier)new ContextCarrier(), (String)(clientDto.getServiceUrl().getHost() + ":" + clientDto.getPort()));
        span.setComponent((Component)ComponentsDefine.JSON_RPC);
        Tags.HTTP.METHOD.set(span, "POST");
        Tags.URL.set(span, clientDto.getServiceUrlString());
        SpanLayer.asRPCFramework((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] objects, Class<?>[] classes, Object o) throws Throwable {
        ContextManager.stopSpan();
        return o;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] objects, Class<?>[] classes, Throwable throwable) {
        ContextManager.activeSpan().log(throwable);
    }

    private boolean isHttps(URL url) {
        return url.getProtocol().equals("https");
    }
}

