/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.rocketMQ.client.java.v5;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.rocketMQ.client.java.v5.define.ConsumerEnhanceInfos;

public class SimpleConsumerImplInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    public static final String CONSUMER_OPERATION_NAME_PREFIX = "RocketMQ/";

    public final void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        List list = (List)ret;
        if (list.isEmpty()) {
            return ret;
        }
        String topics = list.stream().map(MessageView::getTopic).distinct().collect(Collectors.joining(","));
        AbstractSpan span = ContextManager.createEntrySpan((String)(CONSUMER_OPERATION_NAME_PREFIX + topics + "/Consumer"), null);
        SpanLayer.asMQ((AbstractSpan)span);
        String namesrvAddr = "";
        Object skyWalkingDynamicField = objInst.getSkyWalkingDynamicField();
        if (skyWalkingDynamicField != null) {
            ConsumerEnhanceInfos consumerEnhanceInfos = (ConsumerEnhanceInfos)objInst.getSkyWalkingDynamicField();
            namesrvAddr = consumerEnhanceInfos.getNamesrvAddr();
        }
        Tags.MQ_TOPIC.set(span, topics);
        Tags.MQ_BROKER.set(span, namesrvAddr);
        span.setPeer(namesrvAddr);
        span.setComponent((Component)ComponentsDefine.ROCKET_MQ_CONSUMER);
        for (MessageView messageView : list) {
            ContextCarrier contextCarrier = this.getContextCarrierFromMessage(messageView);
            ContextManager.extract((ContextCarrier)contextCarrier);
        }
        ContextManager.stopSpan();
        return ret;
    }

    public final void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) throws Throwable {
        ClientConfiguration clientConfiguration = (ClientConfiguration)allArguments[0];
        String namesrvAddr = clientConfiguration.getEndpoints();
        ConsumerEnhanceInfos consumerEnhanceInfos = new ConsumerEnhanceInfos(namesrvAddr);
        objInst.setSkyWalkingDynamicField((Object)consumerEnhanceInfos);
    }

    private ContextCarrier getContextCarrierFromMessage(MessageView message) {
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            next.setHeadValue((String)message.getProperties().get(next.getHeadKey()));
        }
        return contextCarrier;
    }
}

