/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.netty.http.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.plugin.netty.http.config.NettyHttpPluginConfig;
import org.apache.skywalking.apm.util.StringUtil;

public class HttpDataCollectUtils {
    private static final ILog LOGGER = LogManager.getLogger(HttpDataCollectUtils.class);

    public static void collectHttpRequestBody(HttpHeaders headers, ByteBuf content, AbstractSpan span) {
        try {
            if (headers == null || content == null || span == null) {
                return;
            }
            if (Unpooled.EMPTY_BUFFER.equals((Object)content)) {
                return;
            }
            String contentTypeValue = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            boolean needCollectHttpBody = false;
            for (String contentType : NettyHttpPluginConfig.Plugin.NettyHttp.SUPPORTED_CONTENT_TYPES_PREFIX.split(",")) {
                if (!contentTypeValue.startsWith(contentType)) continue;
                needCollectHttpBody = true;
                break;
            }
            if (needCollectHttpBody) {
                String bodyStr = content.toString(HttpDataCollectUtils.getCharsetFromContentType(headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE)));
                bodyStr = NettyHttpPluginConfig.Plugin.NettyHttp.FILTER_LENGTH_LIMIT > 0 ? StringUtil.cut((String)bodyStr, (int)NettyHttpPluginConfig.Plugin.NettyHttp.FILTER_LENGTH_LIMIT) : bodyStr;
                Tags.HTTP.BODY.set(span, bodyStr);
            }
        }
        catch (Exception e) {
            LOGGER.error("Fail to collect netty http request body", (Throwable)e);
        }
    }

    private static Charset getCharsetFromContentType(String contentType) {
        String[] parts;
        for (String part : parts = contentType.split(";")) {
            if (!(part = part.trim()).startsWith("charset=")) continue;
            return Charset.forName(part.substring("charset=".length()));
        }
        return StandardCharsets.UTF_8;
    }
}

