/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.Element;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.query.PprofTaskLog;
import org.apache.skywalking.oap.server.core.query.type.PprofTaskLogOperationType;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBPprofTaskLogQueryDAO
extends AbstractBanyanDBDAO
implements IPprofTaskLogQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"operation_time", (Object)"instance_id", (Object)"task_id", (Object)"operation_type");
    private final int queryMaxSize;

    public BanyanDBPprofTaskLogQueryDAO(BanyanDBStorageClient client, int taskQueryMaxSize) {
        super(client);
        this.queryMaxSize = taskQueryMaxSize * 50;
    }

    public List<PprofTaskLog> getTaskLogList() throws IOException {
        StreamQueryResponse resp = this.query(false, "pprof_task_log", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                query.setLimit(BanyanDBPprofTaskLogQueryDAO.this.queryMaxSize);
            }
        });
        LinkedList<PprofTaskLog> tasks = new LinkedList<PprofTaskLog>();
        for (Element element : resp.getElements()) {
            tasks.add(this.buildPprofTaskLog(element));
        }
        return tasks;
    }

    private PprofTaskLog buildPprofTaskLog(Element data) {
        int operationTypeInt = ((Number)data.getTagValue("operation_type")).intValue();
        PprofTaskLogOperationType operationType = PprofTaskLogOperationType.parse((int)operationTypeInt);
        return PprofTaskLog.builder().id((String)data.getTagValue("task_id")).instanceId((String)data.getTagValue("instance_id")).operationType(operationType).operationTime(((Number)data.getTagValue("operation_time")).longValue()).build();
    }
}

