/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.dns;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.AbstractUnwrappable;
import com.linecorp.armeria.common.util.OsType;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.client.dns.ByteArrayDnsRecord;
import com.linecorp.armeria.internal.client.dns.DnsQuestionContext;
import com.linecorp.armeria.internal.client.dns.DnsResolver;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.DefaultHostsFileEntriesResolver;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.util.NetUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class HostsFileDnsResolver
extends AbstractUnwrappable<DnsResolver>
implements DnsResolver {
    private static final String LOCALHOST = "localhost";
    private static final InetAddress LOCALHOST_ADDRESS = NetUtil.isIpV4StackPreferred() || !SystemInfo.hasIpV6() ? NetUtil.LOCALHOST4 : (NetUtil.isIpV6AddressesPreferred() ? NetUtil.LOCALHOST6 : NetUtil.LOCALHOST4);
    private final HostsFileEntriesResolver hostsFileEntriesResolver;
    private final ResolvedAddressTypes resolvedAddressTypes;

    private static boolean isLocalWindowsHost(String hostname) {
        return SystemInfo.osType() == OsType.WINDOWS && (hostname.equalsIgnoreCase(LOCALHOST) || hostname.equalsIgnoreCase(SystemInfo.hostname()));
    }

    HostsFileDnsResolver(DnsResolver delegate, HostsFileEntriesResolver hostsFileEntriesResolver, ResolvedAddressTypes resolvedAddressTypes) {
        super(delegate);
        this.hostsFileEntriesResolver = hostsFileEntriesResolver;
        this.resolvedAddressTypes = resolvedAddressTypes;
    }

    @Override
    public CompletableFuture<List<DnsRecord>> resolve(DnsQuestionContext ctx, DnsQuestion question) {
        List<InetAddress> hostsFileEntries;
        DnsRecordType type = question.type();
        String hostname = question.name();
        if ((type == DnsRecordType.A || type == DnsRecordType.AAAA) && (hostsFileEntries = this.resolveHostsFileEntries(hostname)) != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (InetAddress hostsFileEntry : hostsFileEntries) {
                byte[] content = null;
                if (hostsFileEntry instanceof Inet4Address) {
                    if (type == DnsRecordType.A) {
                        content = hostsFileEntry.getAddress();
                    }
                } else if (hostsFileEntry instanceof Inet6Address && type == DnsRecordType.AAAA) {
                    content = hostsFileEntry.getAddress();
                }
                if (content == null) continue;
                builder.add(new ByteArrayDnsRecord(hostname, type, 86400L, content));
            }
            ImmutableCollection records = builder.build();
            if (!records.isEmpty()) {
                return UnmodifiableFuture.completedFuture(records);
            }
        }
        return ((DnsResolver)this.unwrap()).resolve(ctx, question);
    }

    @Nullable
    private List<InetAddress> resolveHostsFileEntries(String hostname) {
        InetAddress address;
        ImmutableList<InetAddress> addresses = this.hostsFileEntriesResolver instanceof DefaultHostsFileEntriesResolver ? ((DefaultHostsFileEntriesResolver)this.hostsFileEntriesResolver).addresses(hostname, this.resolvedAddressTypes) : ((address = this.hostsFileEntriesResolver.address(hostname, this.resolvedAddressTypes)) != null ? ImmutableList.of(address) : null);
        return addresses == null && HostsFileDnsResolver.isLocalWindowsHost(hostname) ? ImmutableList.of(LOCALHOST_ADDRESS) : addresses;
    }

    @Override
    public void close() {
        ((DnsResolver)this.unwrap()).close();
    }
}

