/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.xml.stream;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import org.apache.sis.storage.xml.stream.StaxDataStore;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

enum InputType {
    STAX((Class)XMLStreamReader.class){

        @Override
        XMLStreamReader create(StaxDataStore ds, Object s) {
            return (XMLStreamReader)s;
        }
    }
    ,
    STREAM((Class)InputStream.class){

        @Override
        XMLStreamReader create(StaxDataStore ds, Object s) throws XMLStreamException {
            XMLInputFactory f = ds.inputFactory();
            return ds.encoding != null ? f.createXMLStreamReader((InputStream)s, ds.encoding.name()) : f.createXMLStreamReader((InputStream)s);
        }
    }
    ,
    CHARACTERS((Class)Reader.class){

        @Override
        XMLStreamReader create(StaxDataStore ds, Object s) throws XMLStreamException {
            return ds.inputFactory().createXMLStreamReader((Reader)s);
        }
    }
    ,
    SOURCE((Class)Source.class){

        @Override
        XMLStreamReader create(StaxDataStore ds, Object s) throws XMLStreamException {
            return ds.inputFactory().createXMLStreamReader((Source)s);
        }
    }
    ,
    NODE((Class)Node.class){

        @Override
        XMLStreamReader create(StaxDataStore ds, Object s) throws XMLStreamException {
            return ds.inputFactory().createXMLStreamReader(new DOMSource((Node)s));
        }
    }
    ,
    SAX((Class)InputSource.class){

        @Override
        XMLStreamReader create(StaxDataStore ds, Object s) throws XMLStreamException {
            return ds.inputFactory().createXMLStreamReader(new SAXSource((InputSource)s));
        }
    }
    ,
    EVENT((Class)XMLEventReader.class){

        @Override
        XMLStreamReader create(StaxDataStore ds, Object s) throws XMLStreamException {
            return ds.inputFactory().createXMLStreamReader(new StAXSource((XMLEventReader)s));
        }
    };

    private final Class<?> inputType;

    private InputType(Class<?> inputType) {
        this.inputType = inputType;
    }

    abstract XMLStreamReader create(StaxDataStore var1, Object var2) throws XMLStreamException;

    static InputType forType(Class<?> type) {
        for (InputType c : InputType.values()) {
            if (!c.inputType.isAssignableFrom(type)) continue;
            return c;
        }
        return null;
    }
}

