/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.unittest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.junit.jupiter.api.Assertions;

public final class UnitTestSwaggerUtils {
    private static final ObjectWriter writer = Yaml.pretty();

    private UnitTestSwaggerUtils() {
    }

    public static String loadExpect(String resPath) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resPath);
        if (url == null) {
            return "can not found res " + resPath;
        }
        try {
            return IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public static String pretty(Swagger swagger) {
        try {
            return writer.writeValueAsString((Object)swagger);
        }
        catch (JsonProcessingException e) {
            throw new Error(e);
        }
    }

    public static Swagger parse(String content) {
        try {
            return (Swagger)Yaml.mapper().readValue(content, Swagger.class);
        }
        catch (Exception e) {
            return new Swagger();
        }
    }

    public static SwaggerGenerator testSwagger(String resPath, Class<?> cls, String ... methods) {
        SwaggerGenerator generator = SwaggerGenerator.create(cls);
        generator.replaceMethodWhiteList(methods);
        Swagger swagger = generator.generate();
        String schema = UnitTestSwaggerUtils.pretty(swagger);
        String expectSchema = UnitTestSwaggerUtils.loadExpect(resPath).replace("\r\n", "\n");
        int offset = expectSchema.indexOf("---\nswagger: \"2.0\"");
        if (offset > 0) {
            expectSchema = expectSchema.substring(offset);
        }
        if (!Objects.equals(expectSchema, schema)) {
            Assertions.assertEquals((Object)expectSchema, (Object)schema);
        }
        return generator;
    }

    public static Throwable getException(Class<?> cls, String ... methods) {
        try {
            SwaggerGenerator generator = SwaggerGenerator.create(cls);
            generator.replaceMethodWhiteList(methods);
            generator.generate();
        }
        catch (Throwable e) {
            return e;
        }
        Assertions.assertEquals((Object)"not allowed run to here", (Object)"run to here");
        return null;
    }

    public static void testException(String expectMsgLevel1, String expectMsgLevel2, String expectMsgLevel3, Class<?> cls, String ... methods) {
        Throwable exception = UnitTestSwaggerUtils.getException(cls, methods);
        Assertions.assertEquals((Object)expectMsgLevel1, (Object)exception.getMessage());
        Assertions.assertEquals((Object)expectMsgLevel2, (Object)exception.getCause().getMessage());
        Assertions.assertEquals((Object)expectMsgLevel3, (Object)exception.getCause().getCause().getMessage());
    }

    public static void testException(String expectMsgLevel1, String expectMsgLevel2, Class<?> cls, String ... methods) {
        Throwable exception = UnitTestSwaggerUtils.getException(cls, methods);
        Assertions.assertEquals((Object)expectMsgLevel1, (Object)exception.getMessage());
        Assertions.assertEquals((Object)expectMsgLevel2, (Object)exception.getCause().getMessage());
    }

    public static void testException(String expectMsg, Class<?> cls, String ... methods) {
        Throwable exception = UnitTestSwaggerUtils.getException(cls, methods);
        Assertions.assertEquals((Object)expectMsg, (Object)exception.getMessage());
    }
}

