/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerAdminConfig;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPolicyResourceSignature {
    static final int _SignatureVersion = 1;
    private static final Logger LOG = LoggerFactory.getLogger(RangerPolicyResourceSignature.class);
    static final RangerPolicyResourceSignature _EmptyResourceSignature = new RangerPolicyResourceSignature((RangerPolicy)null);
    private final String _string;
    private final String _hash;
    private final RangerPolicy _policy;

    public RangerPolicyResourceSignature(RangerPolicy policy) {
        this._policy = policy;
        PolicySerializer serializer = new PolicySerializer(this._policy);
        this._string = serializer.toString();
        this._hash = RangerAdminConfig.getInstance().isFipsEnabled() ? DigestUtils.sha512Hex((String)this._string) : DigestUtils.sha256Hex((String)this._string);
    }

    public RangerPolicyResourceSignature(Map<String, RangerPolicy.RangerPolicyResource> resources) {
        this(RangerPolicyResourceSignature.toSignatureString(resources));
    }

    public static RangerPolicyResourceSignature from(Map<String, List<String>> resources) {
        return new RangerPolicyResourceSignature(RangerPolicyResourceSignature.toPolicyResources(resources));
    }

    RangerPolicyResourceSignature(String string) {
        this._policy = null;
        this._string = string == null ? "" : string;
        this._hash = RangerAdminConfig.getInstance().isFipsEnabled() ? DigestUtils.sha384Hex((String)this._string) : DigestUtils.sha256Hex((String)this._string);
    }

    String asString() {
        return this._string;
    }

    public String getSignature() {
        return this._hash;
    }

    public int hashCode() {
        return Objects.hashCode(this._hash);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RangerPolicyResourceSignature)) {
            return false;
        }
        RangerPolicyResourceSignature that = (RangerPolicyResourceSignature)object;
        return Objects.equals(this._hash, that._hash);
    }

    public String toString() {
        return String.format("%s: %s", this._hash, this._string);
    }

    public static String toSignatureString(Map<String, RangerPolicy.RangerPolicyResource> resource) {
        TreeMap<String, ResourceSerializer> resources = new TreeMap<String, ResourceSerializer>();
        for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : resource.entrySet()) {
            String resourceName = entry.getKey();
            ResourceSerializer resourceView = new ResourceSerializer(entry.getValue());
            resources.put(resourceName, resourceView);
        }
        return ((Object)resources).toString();
    }

    public static String toSignatureString(Map<String, RangerPolicy.RangerPolicyResource> resource, List<Map<String, RangerPolicy.RangerPolicyResource>> additionalResources) {
        String ret = RangerPolicyResourceSignature.toSignatureString(resource);
        if (additionalResources != null && !additionalResources.isEmpty()) {
            ArrayList<String> signatures = new ArrayList<String>(additionalResources.size() + 1);
            signatures.add(ret);
            for (Map<String, RangerPolicy.RangerPolicyResource> additionalResource : additionalResources) {
                signatures.add(RangerPolicyResourceSignature.toSignatureString(additionalResource));
            }
            Collections.sort(signatures);
            ret = ((Object)signatures).toString();
        }
        return ret;
    }

    private static Map<String, RangerPolicy.RangerPolicyResource> toPolicyResources(Map<String, List<String>> resources) {
        TreeMap<String, RangerPolicy.RangerPolicyResource> ret = new TreeMap<String, RangerPolicy.RangerPolicyResource>();
        for (Map.Entry<String, List<String>> entry : resources.entrySet()) {
            ret.put(entry.getKey(), new RangerPolicy.RangerPolicyResource(entry.getValue(), (Boolean)false, (Boolean)false));
        }
        return ret;
    }

    static class CustomConditionSerialiser {
        final List<RangerPolicy.RangerPolicyItemCondition> rangerPolicyConditions;

        CustomConditionSerialiser(List<RangerPolicy.RangerPolicyItemCondition> rangerPolicyConditions) {
            this.rangerPolicyConditions = rangerPolicyConditions;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            TreeMap conditionMap = new TreeMap();
            for (RangerPolicy.RangerPolicyItemCondition rangerPolicyCondition : this.rangerPolicyConditions) {
                if (rangerPolicyCondition.getType() == null) continue;
                String type = rangerPolicyCondition.getType();
                ArrayList<String> values = new ArrayList<String>();
                if (rangerPolicyCondition.getValues() != null) {
                    values.addAll(rangerPolicyCondition.getValues());
                    Collections.sort(values);
                }
                conditionMap.put(type, values);
            }
            if (MapUtils.isNotEmpty(conditionMap)) {
                builder.append("{");
                builder.append("RangerPolicyConditions=");
                builder.append(conditionMap);
                builder.append("}");
            }
            return builder.toString();
        }
    }

    public static class ResourceSerializer {
        final RangerPolicy.RangerPolicyResource _policyResource;

        public ResourceSerializer(RangerPolicy.RangerPolicyResource policyResource) {
            this._policyResource = policyResource;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            if (this._policyResource != null) {
                builder.append("values=");
                if (this._policyResource.getValues() != null) {
                    ArrayList<String> values = new ArrayList<String>(this._policyResource.getValues());
                    Collections.sort(values);
                    builder.append(values);
                }
                builder.append(",excludes=");
                if (this._policyResource.getIsExcludes() == null) {
                    builder.append(Boolean.FALSE);
                } else {
                    builder.append(this._policyResource.getIsExcludes());
                }
                builder.append(",recursive=");
                if (this._policyResource.getIsRecursive() == null) {
                    builder.append(Boolean.FALSE);
                } else {
                    builder.append(this._policyResource.getIsRecursive());
                }
            }
            builder.append("}");
            return builder.toString();
        }
    }

    static class PolicySerializer {
        final RangerPolicy _policy;

        PolicySerializer(RangerPolicy policy) {
            this._policy = policy;
        }

        boolean isPolicyValidForResourceSignatureComputation() {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("==> RangerPolicyResourceSignature.isPolicyValidForResourceSignatureComputation(%s)", this._policy));
            }
            boolean valid = false;
            if (this._policy == null) {
                LOG.debug("isPolicyValidForResourceSignatureComputation: policy was null!");
            } else if (this._policy.getResources() == null) {
                LOG.debug("isPolicyValidForResourceSignatureComputation: resources collection on policy was null!");
            } else if (this._policy.getResources().containsKey(null)) {
                LOG.debug("isPolicyValidForResourceSignatureComputation: resources collection has resource with null name!");
            } else if (!this._policy.getIsEnabled().booleanValue() && StringUtils.isEmpty((String)this._policy.getGuid())) {
                LOG.debug("isPolicyValidForResourceSignatureComputation: policy GUID is empty for a disabled policy!");
            } else {
                valid = true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("<== RangerPolicyResourceSignature.isPolicyValidForResourceSignatureComputation(%s): %s", this._policy, valid));
            }
            return valid;
        }

        public String toString() {
            if (!this.isPolicyValidForResourceSignatureComputation()) {
                return "";
            }
            int type = 0;
            if (this._policy.getPolicyType() != null) {
                type = this._policy.getPolicyType();
            }
            String resource = RangerPolicyResourceSignature.toSignatureString(this._policy.getResources(), this._policy.getAdditionalResources());
            if (CollectionUtils.isNotEmpty(this._policy.getValiditySchedules())) {
                resource = resource + this._policy.getValiditySchedules().toString();
            }
            if (this._policy.getPolicyPriority() != null && this._policy.getPolicyPriority() != 0) {
                resource = resource + this._policy.getPolicyPriority();
            }
            if (!StringUtils.isEmpty((String)this._policy.getZoneName())) {
                resource = resource + this._policy.getZoneName();
            }
            if (this._policy.getConditions() != null) {
                CustomConditionSerialiser customConditionSerialiser = new CustomConditionSerialiser(this._policy.getConditions());
                resource = resource + customConditionSerialiser.toString();
            }
            if (!this._policy.getIsEnabled().booleanValue()) {
                resource = resource + this._policy.getGuid();
            }
            String result = String.format("{version=%d,type=%d,resource=%s}", 1, type, resource);
            return result;
        }
    }
}

