/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.checker.Checkable;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class StorageLocation
implements Checkable<CheckContext, VolumeCheckResult>,
Comparable<StorageLocation> {
    private final StorageType storageType;
    private final URI baseURI;
    private static final Pattern regex = Pattern.compile("^\\[(\\w*)\\](.+)$");

    private StorageLocation(StorageType storageType, URI uri) {
        this.storageType = storageType;
        if (uri.getScheme() == null || uri.getScheme().equals("file")) {
            uri = StorageLocation.normalizeFileURI(uri);
        }
        this.baseURI = uri;
    }

    public static URI normalizeFileURI(URI uri) {
        try {
            File uriFile = new File(uri.getPath());
            String uriStr = uriFile.toURI().normalize().toString();
            if (uriStr.endsWith("/")) {
                uriStr = uriStr.substring(0, uriStr.length() - 1);
            }
            return new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URI: " + uri + " is not in the expected format");
        }
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public URI getUri() {
        return this.baseURI;
    }

    public URI getNormalizedUri() {
        return this.baseURI.normalize();
    }

    public boolean matchesStorageDirectory(Storage.StorageDirectory sd) throws IOException {
        return this.equals(sd.getStorageLocation());
    }

    public boolean matchesStorageDirectory(Storage.StorageDirectory sd, String bpid) throws IOException {
        if (sd.getStorageLocation().getStorageType() == StorageType.PROVIDED && this.storageType == StorageType.PROVIDED) {
            return this.matchesStorageDirectory(sd);
        }
        if (sd.getStorageLocation().getStorageType() == StorageType.PROVIDED || this.storageType == StorageType.PROVIDED) {
            return false;
        }
        return this.getBpURI(bpid, "current").normalize().equals(sd.getRoot().toURI().normalize());
    }

    public static StorageLocation parse(String rawLocation) throws IOException, SecurityException {
        Matcher matcher = regex.matcher(rawLocation);
        StorageType storageType = StorageType.DEFAULT;
        String location = rawLocation;
        if (matcher.matches()) {
            String classString = matcher.group(1);
            location = matcher.group(2).trim();
            if (!classString.isEmpty()) {
                storageType = StorageType.valueOf((String)StringUtils.toUpperCase((String)classString));
            }
        }
        return new StorageLocation(storageType, new Path(location).toUri());
    }

    public String toString() {
        return "[" + this.storageType + "]" + this.baseURI.normalize();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StorageLocation)) {
            return false;
        }
        int comp = this.compareTo((StorageLocation)obj);
        return comp == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(StorageLocation obj) {
        if (obj == this) {
            return 0;
        }
        if (obj == null) {
            return -1;
        }
        StorageLocation otherStorage = obj;
        if (this.getNormalizedUri() != null && otherStorage.getNormalizedUri() != null) {
            return this.getNormalizedUri().compareTo(otherStorage.getNormalizedUri());
        }
        if (this.getNormalizedUri() == null && otherStorage.getNormalizedUri() == null) {
            return this.storageType.compareTo((Enum)otherStorage.getStorageType());
        }
        if (this.getNormalizedUri() == null) {
            return -1;
        }
        return 1;
    }

    public URI getBpURI(String bpid, String currentStorageDir) {
        try {
            File localFile = new File(this.getUri());
            return new File(new File(localFile, currentStorageDir), bpid).toURI();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void makeBlockPoolDir(String blockPoolID, Configuration conf) throws IOException {
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        if (this.storageType == StorageType.PROVIDED) {
            Storage.LOG.info("Skipping creating directory for block pool " + blockPoolID + " for PROVIDED storage location " + this);
            return;
        }
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
        FsPermission permission = new FsPermission(conf.get("dfs.datanode.data.dir.perm", "700"));
        File data = new File(this.getBpURI(blockPoolID, "current"));
        try {
            DiskChecker.checkDir((LocalFileSystem)localFS, (Path)new Path(data.toURI()), (FsPermission)permission);
        }
        catch (IOException e) {
            DataStorage.LOG.warn("Invalid directory in: " + data.getCanonicalPath() + ": " + e.getMessage());
        }
    }

    @Override
    public VolumeCheckResult check(CheckContext context) throws IOException {
        if (this.storageType != StorageType.PROVIDED) {
            DiskChecker.checkDir((LocalFileSystem)context.localFileSystem, (Path)new Path(this.baseURI), (FsPermission)context.expectedPermission);
        }
        return VolumeCheckResult.HEALTHY;
    }

    public static final class CheckContext {
        private final LocalFileSystem localFileSystem;
        private final FsPermission expectedPermission;

        public CheckContext(LocalFileSystem localFileSystem, FsPermission expectedPermission) {
            this.localFileSystem = localFileSystem;
            this.expectedPermission = expectedPermission;
        }
    }
}

