/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.session;

import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.messages.ManagementConsoleMessages;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginLogoutReporter
implements HttpSessionBindingListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginLogoutReporter.class);
    private final Subject _subject;
    private final Principal _principal;
    private final EventLoggerProvider _eventLoggerProvider;

    public LoginLogoutReporter(Subject subject, EventLoggerProvider eventLoggerProvider) {
        this._subject = subject;
        this._principal = AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject((Subject)this._subject);
        this._eventLoggerProvider = eventLoggerProvider;
    }

    public void valueBound(HttpSessionBindingEvent arg0) {
        this.reportLogin();
    }

    public void valueUnbound(HttpSessionBindingEvent arg0) {
        this.reportLogout();
    }

    private void reportLogin() {
        LOGGER.debug("User logging in : {}", (Object)this._principal);
        Subject.doAs(this._subject, () -> {
            this.getEventLogger().message(ManagementConsoleMessages.OPEN((CharSequence)this._principal.getName()));
            return null;
        });
    }

    private void reportLogout() {
        LOGGER.debug("User logging out : {}", (Object)this._principal);
        Subject.doAs(this._subject, () -> {
            this.getEventLogger().message(ManagementConsoleMessages.CLOSE((CharSequence)this._principal.getName()));
            return null;
        });
    }

    public EventLogger getEventLogger() {
        return this._eventLoggerProvider.getEventLogger();
    }
}

