/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.layout;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.myfaces.tobago.layout.Margin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarginTokens {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<Margin> margins = new ArrayList<Margin>();

    public int getSize() {
        return this.margins.size();
    }

    public Margin get(int index) {
        return this.margins.get(index);
    }

    public void addMargin(Margin token) {
        this.margins.add(token);
    }

    public List<Margin> getMargins() {
        return this.margins;
    }

    public static MarginTokens parse(String tokens) {
        if (tokens == null) {
            return null;
        }
        MarginTokens marginTokens = new MarginTokens();
        StringTokenizer tokenizer = new StringTokenizer(tokens, "; ");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            marginTokens.addMargin(MarginTokens.parseToken(token));
        }
        return marginTokens;
    }

    public static Margin parseToken(String token) {
        for (Margin margin : Margin.values()) {
            if (!margin.name().equals(token)) continue;
            return margin;
        }
        LOG.error("Error parsing layout token '" + token + "'! Using 'none' instead.");
        return Margin.none;
    }
}

