/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.SupportsAutoSpacing;
import org.apache.myfaces.tobago.event.TabChangeEvent;
import org.apache.myfaces.tobago.event.TabChangeListener;
import org.apache.myfaces.tobago.event.TabChangeSource;
import org.apache.myfaces.tobago.event.TobagoActionSource;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanelBase;
import org.apache.myfaces.tobago.internal.component.AbstractUITab;
import org.apache.myfaces.tobago.model.SwitchType;
import org.apache.myfaces.tobago.util.FacesELUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUITabGroup
extends AbstractUIPanelBase
implements TabChangeSource,
TobagoActionSource,
ClientBehaviorHolder,
SupportsAutoSpacing {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void encodeChildren(FacesContext facesContext) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        super.encodeEnd(facesContext);
        this.setRenderedIndex(this.getSelectedIndex());
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void queueEvent(FacesEvent event) {
        if (this == event.getSource()) {
            if (this.isImmediate() || this.getSwitchType() == SwitchType.client) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public AbstractUITab[] getTabs() {
        ArrayList<AbstractUITab> tabs = new ArrayList<AbstractUITab>();
        for (UIComponent kid : this.getChildren()) {
            if (kid instanceof AbstractUITab) {
                tabs.add((AbstractUITab)kid);
                continue;
            }
            LOG.error("Invalid component in UITabGroup: " + String.valueOf(kid));
        }
        return tabs.toArray(new AbstractUITab[0]);
    }

    public AbstractUITab getActiveTab() {
        return this.getTab(this.getSelectedIndex());
    }

    public void processDecodes(FacesContext context) {
        if (this.getSwitchType() != SwitchType.client) {
            if (context == null) {
                throw new NullPointerException("context");
            }
            if (!this.isRendered()) {
                return;
            }
            int index = 0;
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof AbstractUITab)) continue;
                AbstractUITab tab = (AbstractUITab)child;
                if (tab.isRendered() && this.getRenderedIndex() == index) {
                    tab.processDecodes(context);
                }
                ++index;
            }
            for (UIComponent facet : this.getFacets().values()) {
                facet.processDecodes(context);
            }
            try {
                this.decode(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (this.getSwitchType() != SwitchType.client) {
            if (!this.isRendered()) {
                return;
            }
            AbstractUITab renderedTab = this.getTab(this.getRenderedIndex());
            if (renderedTab != null) {
                renderedTab.processValidators(context);
            }
            for (UIComponent facet : this.getFacets().values()) {
                facet.processValidators(context);
            }
        } else {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (this.getSwitchType() != SwitchType.client) {
            if (!this.isRendered()) {
                return;
            }
            AbstractUITab renderedTab = this.getTab(this.getRenderedIndex());
            if (renderedTab != null) {
                renderedTab.processUpdates(context);
            }
            for (UIComponent facet : this.getFacets().values()) {
                facet.processUpdates(context);
            }
        } else {
            super.processUpdates(context);
        }
    }

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        super.broadcast(facesEvent);
        if (facesEvent instanceof TabChangeEvent && facesEvent.getComponent() == this) {
            ActionListener defaultActionListener;
            TabChangeEvent event = (TabChangeEvent)facesEvent;
            MethodExpression methodExpression = this.getTabChangeListenerExpression();
            if (methodExpression != null) {
                FacesELUtils.invokeMethodExpression(FacesContext.getCurrentInstance(), methodExpression, facesEvent);
            }
            if (this.getSwitchType() != SwitchType.client && (defaultActionListener = this.getFacesContext().getApplication().getActionListener()) != null) {
                defaultActionListener.processAction((ActionEvent)event);
            }
            Integer index = event.getNewTabIndex();
            ValueExpression expression = this.getValueExpression(Attributes.selectedIndex.getName());
            if (expression != null) {
                expression.setValue(this.getFacesContext().getELContext(), (Object)index);
            } else {
                this.setSelectedIndex(index);
            }
        }
    }

    @Override
    public void addTabChangeListener(TabChangeListener listener) {
        if (LOG.isWarnEnabled() && this.getSwitchType() == SwitchType.client) {
            LOG.warn("Adding TabChangeListener to client side TabGroup!");
        }
        this.addFacesListener(listener);
    }

    @Override
    public void removeTabChangeListener(TabChangeListener listener) {
        this.removeFacesListener(listener);
    }

    @Override
    public TabChangeListener[] getTabChangeListeners() {
        return (TabChangeListener[])this.getFacesListeners(TabChangeListener.class);
    }

    public abstract Integer getRenderedIndex();

    public abstract void setRenderedIndex(Integer var1);

    public abstract boolean isShowNavigationBar();

    public abstract Integer getSelectedIndex();

    public abstract void setSelectedIndex(Integer var1);

    public abstract SwitchType getSwitchType();

    private AbstractUITab getTab(int index) {
        int i = 0;
        for (UIComponent component : this.getChildren()) {
            if (component instanceof AbstractUITab) {
                if (i == index) {
                    return (AbstractUITab)component;
                }
                ++i;
                continue;
            }
            LOG.error("Invalid component in UITabGroup: " + String.valueOf(component));
        }
        LOG.error("Found no component with index: " + index + " childCount: " + this.getChildCount());
        return null;
    }

    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }
}

