/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.contrib.server.filter;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.filter.InputHandler;
import org.apache.sshd.common.filter.IoFilter;
import org.apache.sshd.common.filter.OutputHandler;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.contrib.server.session.proxyprotocol.ProxyProtocolAcceptor;
import org.apache.sshd.contrib.server.session.proxyprotocolv2.ProxyProtocolV2Acceptor;
import org.apache.sshd.server.session.ServerSession;

public class HAProxyProtocolFilter
extends IoFilter {
    private AtomicReference<InputHandler> input = new AtomicReference();

    public HAProxyProtocolFilter(ServerSession session) {
        this.input.set(new ProxyHeaderReceiver(session));
    }

    public InputHandler in() {
        return this.input.get();
    }

    public OutputHandler out() {
        return null;
    }

    private class ProxyHeaderReceiver
    implements InputHandler {
        private final ServerSession session;
        private final ProxyProtocolAcceptor handler = new ProxyProtocolV2Acceptor();
        private Buffer buffer = new ByteArrayBuffer();

        ProxyHeaderReceiver(ServerSession session) {
            this.session = Objects.requireNonNull(session);
        }

        public synchronized void received(Readable message) throws Exception {
            if (this.buffer == null) {
                HAProxyProtocolFilter.this.owner().passOn(message);
            } else {
                this.buffer.putBuffer(message);
                if (this.handler.acceptServerProxyMetadata(this.session, this.buffer)) {
                    if (this.buffer.available() > 0) {
                        this.buffer.compact();
                        HAProxyProtocolFilter.this.owner().passOn((Readable)this.buffer);
                    }
                    HAProxyProtocolFilter.this.input.set(null);
                    this.buffer = null;
                }
            }
        }
    }
}

