/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.nio.file.Path;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;

public interface LocalRepositoryManager {
    public LocalRepository getRepository();

    default public Path getAbsolutePathForLocalArtifact(Artifact artifact) {
        return this.getRepository().getBasePath().resolve(this.getPathForLocalArtifact(artifact));
    }

    @Deprecated
    public String getPathForLocalArtifact(Artifact var1);

    default public Path getAbsolutePathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.getRepository().getBasePath().resolve(this.getPathForRemoteArtifact(artifact, repository, context));
    }

    @Deprecated
    public String getPathForRemoteArtifact(Artifact var1, RemoteRepository var2, String var3);

    default public Path getAbsolutePathForLocalMetadata(Metadata metadata) {
        return this.getRepository().getBasePath().resolve(this.getPathForLocalMetadata(metadata));
    }

    @Deprecated
    public String getPathForLocalMetadata(Metadata var1);

    default public Path getAbsolutePathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.getRepository().getBasePath().resolve(this.getPathForRemoteMetadata(metadata, repository, context));
    }

    @Deprecated
    public String getPathForRemoteMetadata(Metadata var1, RemoteRepository var2, String var3);

    public LocalArtifactResult find(RepositorySystemSession var1, LocalArtifactRequest var2);

    public void add(RepositorySystemSession var1, LocalArtifactRegistration var2);

    public LocalMetadataResult find(RepositorySystemSession var1, LocalMetadataRequest var2);

    public void add(RepositorySystemSession var1, LocalMetadataRegistration var2);
}

