/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import org.slf4j.impl.MvndBaseLogger;
import org.slf4j.impl.MvndSimpleLogger;

public class MvndDaemonLogger
extends MvndBaseLogger {
    final DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss.SSS").toFormatter();
    PrintStream printStream;

    public MvndDaemonLogger(String name) {
        super(name);
    }

    @Override
    protected void doLog(int level, String message, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.append(this.dateTimeFormatter.format(LocalTime.now()));
        pw.append(" ");
        switch (level) {
            case 40: {
                pw.append("E");
                break;
            }
            case 30: {
                pw.append("W");
                break;
            }
            case 20: {
                pw.append("I");
                break;
            }
            case 10: {
                pw.append("D");
                break;
            }
            case 0: {
                pw.append("T");
            }
        }
        pw.append(" ");
        pw.append(message);
        if (t != null) {
            t.printStackTrace(pw);
        }
        PrintStream printStream = MvndSimpleLogger.CONFIG_PARAMS.outputChoice.getTargetPrintStream();
        printStream.println(sw);
        printStream.flush();
    }
}

