/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ProblemCollector;

public interface ModelProblemCollector {
    public ProblemCollector<ModelProblem> getProblemCollector();

    default public boolean hasErrors() {
        return this.getProblemCollector().hasErrorProblems();
    }

    default public boolean hasFatalErrors() {
        return this.getProblemCollector().hasFatalProblems();
    }

    default public void add(BuilderProblem.Severity severity, ModelProblem.Version version, String message) {
        this.add(severity, version, message, null, null);
    }

    default public void add(BuilderProblem.Severity severity, ModelProblem.Version version, String message, InputLocation location) {
        this.add(severity, version, message, location, null);
    }

    default public void add(BuilderProblem.Severity severity, ModelProblem.Version version, String message, Exception exception) {
        this.add(severity, version, message, null, exception);
    }

    public void add(BuilderProblem.Severity var1, ModelProblem.Version var2, String var3, InputLocation var4, Exception var5);

    default public void add(ModelProblem problem) {
        this.getProblemCollector().reportProblem(problem);
    }

    public ModelBuilderException newModelBuilderException();

    public void setSource(String var1);

    public void setSource(Model var1);

    public String getSource();

    public void setRootModel(Model var1);

    public Model getRootModel();
}

