/*
 * Decompiled with CFR 0.152.
 */
package cisco.infra.dft.dma.pom.enforcer;

import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class DftRules
implements EnforcerRule {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            MavenSession session = (MavenSession)helper.evaluate("${session}");
            String target = (String)helper.evaluate("${project.build.directory}");
            String artifactId = (String)helper.evaluate("${project.artifactId}");
            ArtifactResolver resolver = (ArtifactResolver)helper.getComponent(ArtifactResolver.class);
            RuntimeInformation rti = (RuntimeInformation)helper.getComponent(RuntimeInformation.class);
            String packaging = project.getPackaging();
            if (packaging != null && packaging.toLowerCase().equals("pom")) {
                return;
            }
            log.info((CharSequence)("Project Packaging: " + project.getPackaging()));
            log.info((CharSequence)("Project SCM Content: " + project.getScm()));
            log.info((CharSequence)("Retrieved Target Folder: " + target));
            log.info((CharSequence)("Retrieved ArtifactId: " + artifactId));
            log.info((CharSequence)("Retrieved Project: " + project));
            log.info((CharSequence)("Retrieved RuntimeInfo: " + rti));
            log.info((CharSequence)("Retrieved Session: " + session));
            log.info((CharSequence)("Retrieved Resolver: " + resolver));
            if (project.getScm() == null) {
                throw new EnforcerRuleException("Project POM missing SCM element");
            }
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup a component " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule arg0) {
        return false;
    }
}

