/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.analysis;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.tests.analysis.LookaheadTokenFilter;
import org.apache.lucene.tests.util.TestUtil;

public final class MockGraphTokenFilter
extends LookaheadTokenFilter<LookaheadTokenFilter.Position> {
    private static final boolean DEBUG = false;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final long seed;
    private Random random;

    public MockGraphTokenFilter(Random random, TokenStream input) {
        super(input);
        this.seed = random.nextLong();
    }

    @Override
    protected LookaheadTokenFilter.Position newPosition() {
        return new LookaheadTokenFilter.Position();
    }

    @Override
    protected void afterPosition() throws IOException {
        if (this.random.nextInt(7) == 5) {
            int posLength = TestUtil.nextInt(this.random, 1, 5);
            LookaheadTokenFilter.Position posEndData = (LookaheadTokenFilter.Position)this.positions.get(this.outputPos + posLength);
            while (!this.end && posEndData.endOffset == -1 && this.inputPos <= this.outputPos + posLength && this.peekToken()) {
            }
            if (posEndData.endOffset != -1) {
                this.insertToken();
                this.clearAttributes();
                this.posLenAtt.setPositionLength(posLength);
                this.termAtt.append(TestUtil.randomUnicodeString(this.random));
                this.posIncAtt.setPositionIncrement(0);
                this.offsetAtt.setOffset(((LookaheadTokenFilter.Position)this.positions.get((int)this.outputPos)).startOffset, posEndData.endOffset);
            }
        }
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.random = new Random(this.seed);
    }

    public void close() throws IOException {
        super.close();
        this.random = null;
    }

    public boolean incrementToken() throws IOException {
        if (this.random == null) {
            throw new IllegalStateException("incrementToken called in wrong state!");
        }
        return this.nextToken();
    }
}

