/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.workload.ThroughputGenerator;

public class ConstantThroughputGenerator
implements ThroughputGenerator {
    private final int messagesPerWindow;
    private final long windowSizeMs;
    private long nextWindowStarts = 0L;
    private int messageTracker = 0;

    @JsonCreator
    public ConstantThroughputGenerator(@JsonProperty(value="messagesPerWindow") int messagesPerWindow, @JsonProperty(value="windowSizeMs") long windowSizeMs) {
        if (windowSizeMs <= 0L) {
            windowSizeMs = 100L;
        }
        this.windowSizeMs = windowSizeMs;
        this.messagesPerWindow = messagesPerWindow;
        this.calculateNextWindow();
    }

    @JsonProperty
    public long windowSizeMs() {
        return this.windowSizeMs;
    }

    @JsonProperty
    public int messagesPerWindow() {
        return this.messagesPerWindow;
    }

    private void calculateNextWindow() {
        this.messageTracker = 0;
        long now = Time.SYSTEM.milliseconds();
        if (this.nextWindowStarts > 0L) {
            while (this.nextWindowStarts <= now) {
                this.nextWindowStarts += this.windowSizeMs;
            }
        } else {
            this.nextWindowStarts = now + this.windowSizeMs;
        }
    }

    @Override
    public synchronized void throttle() throws InterruptedException {
        if (this.messagesPerWindow <= 0) {
            return;
        }
        if (Time.SYSTEM.milliseconds() >= this.nextWindowStarts) {
            this.calculateNextWindow();
        }
        ++this.messageTracker;
        if (this.messageTracker >= this.messagesPerWindow) {
            while (this.nextWindowStarts > Time.SYSTEM.milliseconds()) {
                this.wait(this.nextWindowStarts - Time.SYSTEM.milliseconds());
            }
        }
    }
}

