/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.namedtopology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.LagInfo;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetadata;
import org.apache.kafka.streams.TaskMetadata;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.UnknownStateStoreException;
import org.apache.kafka.streams.errors.UnknownTopologyException;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.namedtopology.AddNamedTopologyResult;
import org.apache.kafka.streams.processor.internals.namedtopology.NamedTopology;
import org.apache.kafka.streams.processor.internals.namedtopology.NamedTopologyBuilder;
import org.apache.kafka.streams.processor.internals.namedtopology.NamedTopologyStoreQueryParameters;
import org.apache.kafka.streams.processor.internals.namedtopology.RemoveNamedTopologyResult;
import org.slf4j.Logger;

@Deprecated
public class KafkaStreamsNamedTopologyWrapper
extends KafkaStreams {
    private final Logger log;

    public KafkaStreamsNamedTopologyWrapper(Properties props) {
        this(new StreamsConfig(props), (KafkaClientSupplier)new DefaultKafkaClientSupplier());
    }

    public KafkaStreamsNamedTopologyWrapper(Properties props, KafkaClientSupplier clientSupplier) {
        this(new StreamsConfig(props), clientSupplier);
    }

    private KafkaStreamsNamedTopologyWrapper(StreamsConfig config, KafkaClientSupplier clientSupplier) {
        super(new TopologyMetadata(new ConcurrentSkipListMap<String, InternalTopologyBuilder>(), config), config, clientSupplier);
        LogContext logContext = new LogContext(String.format("stream-client [%s] ", this.clientId));
        this.log = logContext.logger(this.getClass());
    }

    public void start(NamedTopology initialTopology) {
        this.start(Collections.singleton(initialTopology));
    }

    public synchronized void start(Collection<NamedTopology> initialTopologies) {
        this.log.info("Starting Streams with topologies: {}", initialTopologies);
        for (NamedTopology topology : initialTopologies) {
            AddNamedTopologyResult addNamedTopologyResult = this.addNamedTopology(topology);
            if (!addNamedTopologyResult.all().isCompletedExceptionally()) continue;
            StreamsException e = addNamedTopologyResult.exceptionNow();
            this.log.error("Failed to start Streams when adding topology " + topology.name() + " due to", (Throwable)((Object)e));
            throw e;
        }
        super.start();
    }

    public NamedTopologyBuilder newNamedTopologyBuilder(String topologyName, Properties topologyOverrides) {
        if (topologyName.contains("__")) {
            throw new IllegalArgumentException("The character sequence '__' is not allowed in a NamedTopology, please select a new name");
        }
        return new NamedTopologyBuilder(topologyName, this.applicationConfigs, topologyOverrides);
    }

    public NamedTopologyBuilder newNamedTopologyBuilder(String topologyName) {
        return this.newNamedTopologyBuilder(topologyName, new Properties());
    }

    public synchronized Optional<NamedTopology> getTopologyByName(String name) {
        return Optional.ofNullable(this.topologyMetadata.lookupBuilderForNamedTopology(name)).map(InternalTopologyBuilder::namedTopology);
    }

    public Collection<NamedTopology> getAllTopologies() {
        return this.topologyMetadata.allNamedTopologies();
    }

    public AddNamedTopologyResult addNamedTopology(NamedTopology newTopology) {
        this.log.info("Adding new NamedTopology: {}", (Object)newTopology.name());
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (this.hasStartedOrFinishedShuttingDown()) {
            future.completeExceptionally((Throwable)new IllegalStateException("Cannot add a NamedTopology while the state is " + String.valueOf((Object)this.state)));
        } else if (this.getTopologyByName(newTopology.name()).isPresent()) {
            future.completeExceptionally((Throwable)new IllegalArgumentException("Unable to add the new NamedTopology " + newTopology.name() + " as another of the same name already exists"));
        } else {
            this.topologyMetadata.registerAndBuildNewTopology((KafkaFutureImpl<Void>)future, newTopology.internalTopologyBuilder());
            this.maybeCompleteFutureIfStillInCREATED((KafkaFutureImpl<Void>)future, "adding topology " + newTopology.name());
        }
        return new AddNamedTopologyResult((KafkaFuture<Void>)future);
    }

    public RemoveNamedTopologyResult removeNamedTopology(String topologyToRemove, boolean resetOffsets) {
        this.log.info("Informed to remove topology {} with resetOffsets={} ", (Object)topologyToRemove, (Object)resetOffsets);
        KafkaFutureImpl removeTopologyFuture = new KafkaFutureImpl();
        if (this.hasStartedOrFinishedShuttingDown()) {
            this.log.error("Attempted to remove topology {} from while the Kafka Streams was in state {}, topologies cannot be modified if the application has begun or completed shutting down.", (Object)topologyToRemove, (Object)this.state);
            removeTopologyFuture.completeExceptionally((Throwable)new IllegalStateException("Cannot remove a NamedTopology while the state is " + String.valueOf((Object)this.state)));
        } else if (!this.getTopologyByName(topologyToRemove).isPresent()) {
            this.log.error("Attempted to remove unknown topology {}. This application currently contains thefollowing topologies: {}.", (Object)topologyToRemove, this.topologyMetadata.namedTopologiesView());
            removeTopologyFuture.completeExceptionally((Throwable)((Object)new UnknownTopologyException("Unable to remove topology", topologyToRemove)));
        }
        Set partitionsToReset = this.metadataForLocalThreads().stream().flatMap(t -> {
            HashSet<TaskMetadata> tasks = new HashSet<TaskMetadata>(t.activeTasks());
            return tasks.stream();
        }).flatMap(t -> t.topicPartitions().stream()).filter(t -> this.topologyMetadata.sourceTopicsForTopology(topologyToRemove).contains(t.topic())).collect(Collectors.toSet());
        this.topologyMetadata.unregisterTopology((KafkaFutureImpl<Void>)removeTopologyFuture, topologyToRemove);
        boolean skipResetForUnstartedApplication = this.maybeCompleteFutureIfStillInCREATED((KafkaFutureImpl<Void>)removeTopologyFuture, "removing topology " + topologyToRemove);
        if (resetOffsets && !skipResetForUnstartedApplication && !partitionsToReset.isEmpty()) {
            this.log.info("Resetting offsets for the following partitions of {} removed NamedTopology {}: {}", new Object[]{removeTopologyFuture.isCompletedExceptionally() ? "unsuccessfully" : "successfully", topologyToRemove, partitionsToReset});
            return new RemoveNamedTopologyResult((KafkaFutureImpl<Void>)removeTopologyFuture, topologyToRemove, () -> this.resetOffsets(partitionsToReset));
        }
        return new RemoveNamedTopologyResult((KafkaFutureImpl<Void>)removeTopologyFuture);
    }

    public void pauseNamedTopology(String topologyName) {
        this.topologyMetadata.pauseTopology(topologyName);
    }

    public boolean isNamedTopologyPaused(String topologyName) {
        return this.topologyMetadata.isPaused(topologyName);
    }

    public void resumeNamedTopology(String topologyName) {
        this.topologyMetadata.resumeTopology(topologyName);
        this.threads.forEach(StreamThread::signalResume);
    }

    private boolean maybeCompleteFutureIfStillInCREATED(KafkaFutureImpl<Void> updateTopologyFuture, String operation) {
        if (this.state == KafkaStreams.State.CREATED && !updateTopologyFuture.isDone()) {
            updateTopologyFuture.complete(null);
            this.log.info("Completed {} since application has not been started", (Object)operation);
            return true;
        }
        return false;
    }

    private void resetOffsets(Set<TopicPartition> partitionsToReset) throws StreamsException {
        int retries = 100;
        while (true) {
            try {
                DeleteConsumerGroupOffsetsResult deleteOffsetsResult = this.adminClient.deleteConsumerGroupOffsets(this.applicationConfigs.getString("application.id"), partitionsToReset);
                deleteOffsetsResult.all().get();
                this.log.info("Successfully completed resetting offsets.");
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                this.log.error("Offset reset failed.", (Throwable)ex);
                throw new StreamsException(ex);
            }
            catch (ExecutionException ex) {
                Throwable error;
                Throwable throwable = error = ex.getCause() != null ? ex.getCause() : ex;
                if (error instanceof GroupSubscribedToTopicException && error.getMessage().equals("Deleting offsets of a topic is forbidden while the consumer group is actively subscribed to it.")) {
                    this.log.debug("Offset reset failed, there may be other nodes which have not yet finished removing this topology", error);
                } else {
                    if (error instanceof GroupIdNotFoundException) {
                        this.log.info("The offsets have been reset by another client or the group has been deleted, no need to retry further.");
                        break;
                    }
                    if (--retries > 0) {
                        this.log.error("Offset reset failed, retries remaining: " + retries, error);
                    } else {
                        this.log.error("Offset reset failed, no retries remaining.", error);
                        throw new StreamsException(error);
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex2) {
                    ex2.printStackTrace();
                }
                continue;
            }
            break;
        }
    }

    public RemoveNamedTopologyResult removeNamedTopology(String topologyToRemove) {
        return this.removeNamedTopology(topologyToRemove, false);
    }

    public void cleanUpNamedTopology(String name) {
        if (this.getTopologyByName(name).isPresent()) {
            throw new IllegalStateException("Can't clean up local state for an active NamedTopology: " + name);
        }
        this.stateDirectory.clearLocalStateForNamedTopology(name);
    }

    public String getFullTopologyDescription() {
        return this.topologyMetadata.topologyDescriptionString();
    }

    private void verifyTopologyStateStore(String topologyName, String storeName) {
        InternalTopologyBuilder builder = this.topologyMetadata.lookupBuilderForNamedTopology(topologyName);
        if (builder == null) {
            throw new UnknownTopologyException("Cannot get state store " + storeName, topologyName);
        }
        if (!builder.hasStore(storeName)) {
            throw new UnknownStateStoreException("Cannot get state store " + storeName + " from NamedTopology " + topologyName + " because no such state store exists in this topology.");
        }
    }

    public <T> T store(NamedTopologyStoreQueryParameters<T> storeQueryParameters) {
        String topologyName = storeQueryParameters.topologyName;
        String storeName = storeQueryParameters.storeName();
        this.verifyTopologyStateStore(topologyName, storeName);
        return super.store(storeQueryParameters);
    }

    public Collection<StreamsMetadata> streamsMetadataForStore(String storeName, String topologyName) {
        this.verifyTopologyStateStore(topologyName, storeName);
        this.validateIsRunningOrRebalancing();
        return this.streamsMetadataState.allMetadataForStore(storeName, topologyName);
    }

    public Collection<StreamsMetadata> allStreamsClientsMetadataForTopology(String topologyName) {
        this.validateIsRunningOrRebalancing();
        return this.streamsMetadataState.allMetadataForTopology(topologyName);
    }

    public <K> KeyQueryMetadata queryMetadataForKey(String storeName, K key, Serializer<K> keySerializer, String topologyName) {
        this.verifyTopologyStateStore(topologyName, storeName);
        this.validateIsRunningOrRebalancing();
        return this.streamsMetadataState.keyQueryMetadataForKey(storeName, key, keySerializer, topologyName);
    }

    public Map<String, Map<Integer, LagInfo>> allLocalStorePartitionLagsForTopology(String topologyName) {
        if (!this.getTopologyByName(topologyName).isPresent()) {
            this.log.error("Can't get local store partition lags since topology {} does not exist in this application", (Object)topologyName);
            throw new UnknownTopologyException("Can't get local store partition lags", topologyName);
        }
        ArrayList<Task> allTopologyTasks = new ArrayList<Task>();
        this.processStreamThread(thread -> allTopologyTasks.addAll(thread.readyOnlyAllTasks().stream().filter(t -> topologyName.equals(t.id().topologyName())).collect(Collectors.toList())));
        return this.allLocalStorePartitionLags(allTopologyTasks);
    }
}

