/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.BasicNamedAttribute;
import org.apache.juneau.rest.httppart.NamedAttribute;
import org.apache.juneau.rest.httppart.NamedAttributeMap;
import org.apache.juneau.rest.httppart.RequestAttribute;
import org.apache.juneau.svl.VarResolverSession;

public class RequestAttributes {
    final RestRequest req;
    final HttpServletRequest sreq;
    final VarResolverSession vs;

    public RequestAttributes(RestRequest req) {
        this.req = req;
        this.sreq = req.getHttpServletRequest();
        this.vs = req.getVarResolverSession();
    }

    public RequestAttributes addDefault(List<NamedAttribute> pairs) {
        for (NamedAttribute p : pairs) {
            if (this.sreq.getAttribute(p.getName()) != null) continue;
            Object o = p.getValue();
            this.sreq.setAttribute(p.getName(), o instanceof String ? this.vs.resolve(o) : o);
        }
        return this;
    }

    public RequestAttributes addDefault(NamedAttributeMap pairs) {
        for (NamedAttribute p : pairs.values()) {
            if (this.sreq.getAttribute(p.getName()) != null) continue;
            Object o = p.getValue();
            this.sreq.setAttribute(p.getName(), o instanceof String ? this.vs.resolve(o) : o);
        }
        return this;
    }

    public RequestAttributes addDefault(NamedAttribute ... pairs) {
        return this.addDefault(CollectionUtils.alist(pairs));
    }

    public RequestAttributes addDefault(String name, Object value) {
        return this.addDefault(BasicNamedAttribute.of(name, value));
    }

    public RequestAttribute get(String name) {
        return new RequestAttribute(this.req, name, this.sreq.getAttribute(name));
    }

    public List<RequestAttribute> getAll() {
        ArrayList<RequestAttribute> l = CollectionUtils.list(new RequestAttribute[0]);
        Enumeration e = this.sreq.getAttributeNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            l.add(new RequestAttribute(this.req, n, this.sreq.getAttribute(n)));
        }
        return l;
    }

    public boolean contains(String ... names) {
        ArgUtils.assertArgNotNull("names", names);
        for (String n : names) {
            if (this.sreq.getAttribute(n) != null) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(String ... names) {
        ArgUtils.assertArgNotNull("names", names);
        for (String n : names) {
            if (this.sreq.getAttribute(n) == null) continue;
            return true;
        }
        return false;
    }

    public RequestAttributes set(String name, Object value) {
        ArgUtils.assertArgNotNull("name", name);
        this.sreq.setAttribute(name, value);
        return this;
    }

    public RequestAttributes set(NamedAttribute ... attributes) {
        ArgUtils.assertArgNotNull("attributes", attributes);
        for (NamedAttribute p : attributes) {
            this.set(p);
        }
        return this;
    }

    public RequestAttributes remove(String ... name) {
        ArgUtils.assertArgNotNull("name", name);
        for (String n : name) {
            this.sreq.removeAttribute(n);
        }
        return this;
    }

    public RequestAttributes remove(NamedAttribute ... attributes) {
        for (NamedAttribute p : attributes) {
            this.remove(p.getName());
        }
        return this;
    }

    public Map<String, Object> asMap() {
        JsonMap m = new JsonMap();
        Enumeration e = this.sreq.getAttributeNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            m.put(n, this.sreq.getAttribute(n));
        }
        return m;
    }

    public String toString() {
        return this.asMap().toString();
    }
}

